/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.caches;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.BuiltInWithDifferentJvmName;
import ksp.org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethods;
import ksp.org.jetbrains.kotlin.backend.common.lower.SpecialMethodWithDefaultInfo;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.SpecialBridge;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/caches/BridgeLoweringCache;", "", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "signatureCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "specialBridgeMethods", "Lksp/org/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "canHaveSpecialBridge", "", "function", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "computeJvmMethod", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "computeSpecialBridge", "Lksp/org/jetbrains/kotlin/backend/jvm/SpecialBridge;", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nBridgeLoweringCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeLoweringCache.kt\norg/jetbrains/kotlin/backend/jvm/caches/BridgeLoweringCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,121:1\n72#2,2:122\n1#3:124\n1745#4,3:125\n1557#4:128\n1588#4,4:129\n1547#4:137\n1618#4,3:138\n237#5,4:133\n*S KotlinDebug\n*F\n+ 1 BridgeLoweringCache.kt\norg/jetbrains/kotlin/backend/jvm/caches/BridgeLoweringCache\n*L\n31#1:122,2\n31#1:124\n38#1:125,3\n82#1:128\n82#1:129,4\n92#1:137\n92#1:138,3\n86#1:133,4\n*E\n"})
public final class BridgeLoweringCache {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final SpecialBridgeMethods specialBridgeMethods;
    @NotNull
    private final ConcurrentHashMap<IrFunctionSymbol, Method> signatureCache;

    public BridgeLoweringCache(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.specialBridgeMethods = new SpecialBridgeMethods(this.context);
        this.signatureCache = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Method computeJvmMethod(@NotNull IrFunction function2) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(function2, "function");
        ConcurrentMap concurrentMap = this.signatureCache;
        IrFunctionSymbol key$iv = function2.getSymbol();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Method default$iv = this.context.getDefaultMethodSignatureMapper().mapAsmMethod(function2);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, "getOrPut(...)");
        return (Method)object;
    }

    private final boolean canHaveSpecialBridge(IrSimpleFunction function2) {
        boolean bl;
        block4: {
            if (this.specialBridgeMethods.getSpecialMethodNames().contains(function2.getName())) {
                return true;
            }
            String string2 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String functionName = string2;
            Iterable $this$any$iv = this.specialBridgeMethods.getSpecialMethodNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String specialMethodNameString;
                    Name it = (Name)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it.asString(), "asString(...)");
                    int specialMethodNameLength = specialMethodNameString.length();
                    if (!(StringsKt.startsWith$default(functionName, specialMethodNameString, false, 2, null) && functionName.length() > specialMethodNameLength && functionName.charAt(specialMethodNameLength) == '-')) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SpecialBridge computeSpecialBridge(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        IrPropertySymbol correspondingProperty = function2.getCorrespondingPropertySymbol();
        if (correspondingProperty != null ? !this.specialBridgeMethods.getSpecialPropertyNames().contains(((IrProperty)correspondingProperty.getOwner()).getName()) : !this.canHaveSpecialBridge(function2)) {
            return null;
        }
        SpecialMethodWithDefaultInfo specialMethodInfo = this.specialBridgeMethods.getSpecialMethodInfo(function2);
        if (specialMethodInfo != null) {
            return new SpecialBridge(function2, this.computeJvmMethod(function2), specialMethodInfo.getNeedsGenericSignature(), null, null, specialMethodInfo, null, false, false, false, specialMethodInfo.getNeedsUnsubstitutedBridge(), null, 3032, null);
        }
        BuiltInWithDifferentJvmName specialBuiltInInfo = this.specialBridgeMethods.getBuiltInWithDifferentJvmName(function2);
        if (specialBuiltInInfo != null) {
            return new SpecialBridge(function2, this.computeJvmMethod(function2), specialBuiltInInfo.getNeedsGenericSignature(), null, null, null, null, false, false, specialBuiltInInfo.isOverriding(), false, null, 3576, null);
        }
        for (IrSimpleFunctionSymbol overridden : function2.getOverriddenSymbols()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object item$iv$iv2;
            void $this$mapIndexedTo$iv$iv;
            SpecialBridge specialBridge = this.computeSpecialBridge((IrSimpleFunction)overridden.getOwner());
            if (specialBridge == null) continue;
            SpecialBridge specialBridge2 = specialBridge;
            if (!specialBridge2.getNeedsGenericSignature()) {
                return specialBridge2;
            }
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = specialBridge2.getMethodInfo();
            int erasedParameterCount = specialMethodWithDefaultInfo != null ? specialMethodWithDefaultInfo.getArgumentsToCheck() : 0;
            Iterable $this$mapIndexed$iv = function2.getValueParameters();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void param;
                void index2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(index2 < erasedParameterCount ? this.context.getIrBuiltIns().getAnyNType() : param.getType());
            }
            List substitutedParameterTypes = (List)destination$iv$iv;
            Object $this$buildFun$iv = this.context.getIrFactory();
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
            IrFunctionBuilder $this$computeSpecialBridge_u24lambda_u243 = $this$buildFun_u24lambda_u2420$iv;
            boolean bl = false;
            $this$computeSpecialBridge_u24lambda_u243.updateFrom(specialBridge2.getOverridden());
            Name name2 = Name.identifier(specialBridge2.getSignature().getName());
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            $this$computeSpecialBridge_u24lambda_u243.setName(name2);
            $this$computeSpecialBridge_u24lambda_u243.setReturnType(function2.getReturnType());
            Object $this$computeSpecialBridge_u24lambda_u245 = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
            boolean bl2 = false;
            Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = CollectionsKt.zip((Iterable)function2.getValueParameters(), substitutedParameterTypes);
            Object object = $this$computeSpecialBridge_u24lambda_u245;
            boolean $i$f$map = false;
            item$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv3;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                IrValueParameter param = (IrValueParameter)pair.component1();
                IrType type2 = (IrType)pair.component2();
                collection.add(IrUtilsKt.copyTo$default(param, (IrFunction)$this$computeSpecialBridge_u24lambda_u245, IrDeclarationOrigin.Companion.getBRIDGE(), 0, 0, 0, null, null, type2, null, null, false, false, false, 8060, null));
            }
            ((IrFunction)object).setValueParameters((List)destination$iv$iv2);
            $this$computeSpecialBridge_u24lambda_u245.setOverriddenSymbols(CollectionsKt.listOf(specialBridge2.getOverridden().getSymbol()));
            $this$computeSpecialBridge_u24lambda_u245.setParent(function2.getParent());
            Object substitutedOverride = $this$buildFun$iv;
            Method substitutedOverrideSignature = this.computeJvmMethod((IrFunction)substitutedOverride);
            SpecialBridge unsubstitutedSpecialBridge = specialBridge2.getUnsubstitutedSpecialBridge() != null ? specialBridge2.getUnsubstitutedSpecialBridge() : (specialBridge2.getNeedsUnsubstitutedBridge() && !Intrinsics.areEqual(specialBridge2.getSignature(), substitutedOverrideSignature) ? SpecialBridge.copy$default(specialBridge2, null, null, false, null, null, null, null, false, true, false, false, null, 3839, null) : null);
            return SpecialBridge.copy$default(specialBridge2, null, substitutedOverrideSignature, false, substitutedParameterTypes, function2.getReturnType(), null, null, false, false, false, false, unsubstitutedSpecialBridge, 2021, null);
        }
        return null;
    }
}

