/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.lower;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.backend.common.BackendContext;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.ir.ExpectSymbolTransformer;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import ksp.org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import ksp.org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import ksp.org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import ksp.org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import ksp.org.jetbrains.kotlin.ir.util.ReferenceSymbolTableExtension;
import ksp.org.jetbrains.kotlin.ir.util.SymbolRemapper;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolverKt;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0019H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u001cH\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010+2\u0006\u0010(\u001a\u00020)J\u0010\u0010,\u001a\u00020$2\u0006\u0010(\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020$2\u0006\u0010(\u001a\u00020&H\u0016J\u0010\u0010/\u001a\u00020$2\u0006\u0010(\u001a\u00020-H\u0016J(\u00100\u001a\u000201*\u0002012\u0006\u00102\u001a\u00020\u00102\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u000e\u00104\u001a\u0004\u0018\u000105*\u000205H\u0002J\u000e\u00106\u001a\u0004\u0018\u000105*\u000205H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR2\u0010\r\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover;", "Lksp/org/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "symbolTable", "Lksp/org/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "doRemove", "", "(Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Z)V", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeParameterSubstitutionMap", "", "Lkotlin/Pair;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "getActualClass", "Lksp/org/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "getActualConstructor", "Lksp/org/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lksp/org/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "getActualFunction", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getActualProperty", "Lksp/org/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer$ActualPropertyResult;", "Lksp/org/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isOptionalAnnotationClass", "klass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "shouldRemoveTopLevelDeclaration", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "transformFlat", "", "tryCopyDefaultArguments", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitFile", "visitValueParameter", "copyAndActualizeDefaultValue", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "actualFunction", "expectActualTypeParametersMap", "findActualForExpect", "Lksp/org/jetbrains/kotlin/descriptors/MemberDescriptor;", "findExpectForActual", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nExpectDeclarationRemover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectDeclarationRemover.kt\norg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n*L\n1#1,188:1\n1#2:189\n28#3,10:190\n*S KotlinDebug\n*F\n+ 1 ExpectDeclarationRemover.kt\norg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover\n*L\n169#1:190,10\n*E\n"})
public class ExpectDeclarationRemover
extends ExpectSymbolTransformer
implements FileLoweringPass {
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    private final boolean doRemove;
    @NotNull
    private final Map<Pair<IrFunction, IrFunction>, Map<IrTypeParameter, IrTypeParameter>> typeParameterSubstitutionMap;

    public ExpectDeclarationRemover(@NotNull ReferenceSymbolTable symbolTable, boolean doRemove) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        this.symbolTable = symbolTable;
        this.doRemove = doRemove;
        this.typeParameterSubstitutionMap = new LinkedHashMap();
    }

    @NotNull
    public final ReferenceSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public ExpectDeclarationRemover(@NotNull BackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this(context2.getIr().getSymbols().getExternalSymbolTable(), true);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.visitFile(irFile);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (this.doRemove) {
            CollectionsKt.removeAll(declaration2.getDeclarations(), (Function1)new Function1<IrDeclaration, Boolean>(this){
                final /* synthetic */ ExpectDeclarationRemover this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(IrDeclaration it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return ExpectDeclarationRemover.access$shouldRemoveTopLevelDeclaration(this.this$0, it);
                }
            });
        }
        super.visitFile(declaration2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        this.tryCopyDefaultArguments(declaration2);
        super.visitValueParameter(declaration2);
    }

    @Nullable
    public final List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (AdditionalIrUtilsKt.isTopLevelDeclaration(declaration2) && this.shouldRemoveTopLevelDeclaration(declaration2)) {
            return CollectionsKt.emptyList();
        }
        if (declaration2 instanceof IrValueParameter) {
            this.tryCopyDefaultArguments((IrValueParameter)declaration2);
        }
        return null;
    }

    @Override
    @Nullable
    protected IrClassSymbol getActualClass(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor2);
        ClassDescriptor classDescriptor2 = memberDescriptor instanceof ClassDescriptor ? (ClassDescriptor)memberDescriptor : null;
        if (classDescriptor2 == null) {
            return null;
        }
        return this.symbolTable.getDescriptorExtension().referenceClass(classDescriptor2);
    }

    @Override
    @Nullable
    protected ExpectSymbolTransformer.ActualPropertyResult getActualProperty(@NotNull PropertyDescriptor descriptor2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor2);
        PropertyDescriptor propertyDescriptor = memberDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)memberDescriptor : null;
        if (propertyDescriptor == null) {
            return null;
        }
        IrPropertySymbol newSymbol = this.symbolTable.getDescriptorExtension().referenceProperty(propertyDescriptor);
        PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)newSymbol.getDescriptor()).getGetter();
        if (propertyGetterDescriptor != null) {
            PropertyGetterDescriptor it = propertyGetterDescriptor;
            boolean bl = false;
            irSimpleFunctionSymbol2 = this.symbolTable.getDescriptorExtension().referenceSimpleFunction(it);
        } else {
            irSimpleFunctionSymbol2 = null;
        }
        IrSimpleFunctionSymbol newGetter = irSimpleFunctionSymbol2;
        PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)newSymbol.getDescriptor()).getSetter();
        if (propertySetterDescriptor != null) {
            PropertySetterDescriptor it = propertySetterDescriptor;
            boolean bl = false;
            irSimpleFunctionSymbol = this.symbolTable.getDescriptorExtension().referenceSimpleFunction(it);
        } else {
            irSimpleFunctionSymbol = null;
        }
        IrSimpleFunctionSymbol newSetter = irSimpleFunctionSymbol;
        return new ExpectSymbolTransformer.ActualPropertyResult(newSymbol, newGetter, newSetter);
    }

    @Override
    @Nullable
    protected IrConstructorSymbol getActualConstructor(@NotNull ClassConstructorDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor2);
        ClassConstructorDescriptor classConstructorDescriptor = memberDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)memberDescriptor : null;
        if (classConstructorDescriptor == null) {
            return null;
        }
        return this.symbolTable.getDescriptorExtension().referenceConstructor(classConstructorDescriptor);
    }

    @Override
    @Nullable
    protected IrSimpleFunctionSymbol getActualFunction(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor2);
        FunctionDescriptor functionDescriptor = memberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)memberDescriptor : null;
        if (functionDescriptor == null) {
            return null;
        }
        return this.symbolTable.getDescriptorExtension().referenceSimpleFunction(functionDescriptor);
    }

    private final MemberDescriptor findActualForExpect(MemberDescriptor $this$findActualForExpect) {
        if (!$this$findActualForExpect.isExpect()) {
            throw new IllegalStateException($this$findActualForExpect.toString());
        }
        return (MemberDescriptor)CollectionsKt.singleOrNull(ExpectedActualResolverKt.findCompatibleActualsForExpected$default($this$findActualForExpect, DescriptorUtilsKt.getModule($this$findActualForExpect), null, 2, null));
    }

    private final boolean shouldRemoveTopLevelDeclaration(IrDeclaration declaration2) {
        IrDeclaration irDeclaration2;
        return this.doRemove && ((irDeclaration2 = declaration2) instanceof IrClass ? ((IrClass)declaration2).isExpect() : (irDeclaration2 instanceof IrProperty ? ((IrProperty)declaration2).isExpect() : (irDeclaration2 instanceof IrFunction ? ((IrFunction)declaration2).isExpect() : false)));
    }

    private final boolean isOptionalAnnotationClass(IrClass klass) {
        return klass.getKind() == ClassKind.ANNOTATION_CLASS && klass.isExpect() && AdditionalIrUtilsKt.hasAnnotation(klass.getAnnotations(), OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME());
    }

    private final void tryCopyDefaultArguments(IrValueParameter declaration2) {
        Object object;
        int index2;
        IrFunction function2;
        block12: {
            block11: {
                if (declaration2.getDefaultValue() != null) {
                    return;
                }
                IrDeclarationParent irDeclarationParent = declaration2.getParent();
                IrFunction irFunction = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
                if (irFunction == null) {
                    return;
                }
                function2 = irFunction;
                if (function2 instanceof IrConstructor && this.isOptionalAnnotationClass(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)function2))) {
                    return;
                }
                if (!function2.getDescriptor().isActual()) {
                    return;
                }
                index2 = declaration2.getIndex();
                if (index2 < 0) {
                    return;
                }
                boolean bl = Intrinsics.areEqual(function2.getValueParameters().get(index2), declaration2);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                MemberDescriptor memberDescriptor = this.findExpectForActual(function2.getDescriptor());
                object = memberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)memberDescriptor : null;
                if (object == null) break block11;
                FunctionDescriptor it = object;
                boolean bl2 = false;
                IrFunction irFunction2 = IrUtilsKt.referenceFunction(this.symbolTable, it).getOwner();
                object = irFunction2;
                if (irFunction2 != null) break block12;
            }
            return;
        }
        Object expectFunction = object;
        IrExpressionBody irExpressionBody = ((IrFunction)expectFunction).getValueParameters().get(index2).getDefaultValue();
        if (irExpressionBody == null) {
            return;
        }
        IrExpressionBody defaultValue = irExpressionBody;
        Pair<Object, IrFunction> expectToActual = TuplesKt.to(expectFunction, function2);
        if (!this.typeParameterSubstitutionMap.containsKey(expectToActual)) {
            List<IrTypeParameter> functionTypeParameters = IrTypeSystemContextKt.extractTypeParameters(function2);
            List<IrTypeParameter> expectFunctionTypeParameters = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)expectFunction);
            List typeParametersMapping = CollectionsKt.zip((Iterable)expectFunctionTypeParameters, (Iterable)functionTypeParameters);
            boolean bl = false;
            this.typeParameterSubstitutionMap.put(expectToActual, MapsKt.toMap(typeParametersMapping));
        }
        IrExpressionBody originalDefault = defaultValue;
        boolean bl = false;
        declaration2.setDefaultValue(this.copyAndActualizeDefaultValue(originalDefault, function2, MapsKt.getValue(this.typeParameterSubstitutionMap, expectToActual)));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpressionBody copyAndActualizeDefaultValue(IrExpressionBody $this$copyAndActualizeDefaultValue, IrFunction actualFunction, Map<IrTypeParameter, ? extends IrTypeParameter> expectActualTypeParametersMap) {
        void symbolRemapper;
        void $this$deepCopyWithSymbols$iv$iv;
        void $this$deepCopyWithSymbols$iv;
        IrElement irElement = $this$copyAndActualizeDefaultValue;
        boolean $i$f$deepCopyWithSymbols = false;
        void var6_6 = $this$deepCopyWithSymbols$iv;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        boolean $i$f$deepCopyWithSymbols2 = false;
        IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
        DeepCopyTypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
        SymbolRemapper symbolRemapper2 = symbolRemapper$iv$iv;
        void var12_11 = $this$deepCopyWithSymbols$iv$iv;
        boolean bl = false;
        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var12_11.transform(new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper, new IrTypeParameterRemapper(expectActualTypeParametersMap)), null), actualFunction);
        if (irElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
        }
        return ((IrExpressionBody)((IrElement)((IrExpressionBody)irElement2))).transform((IrElementTransformer)new IrElementTransformerVoid(this){
            final /* synthetic */ ExpectDeclarationRemover this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitGetValue(IrGetValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.transformChildrenVoid(expression2);
                return LowerUtilsKt.actualize(expression2, (Function1<? super IrClass, ? extends IrClass>)new Function1<IrClass, IrClass>(this.this$0){
                    final /* synthetic */ ExpectDeclarationRemover this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final IrClass invoke(IrClass it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        ReferenceSymbolTableExtension<ClassDescriptor, TypeAliasDescriptor, ScriptDescriptor, FunctionDescriptor, ClassConstructorDescriptor, PropertyDescriptor, ParameterDescriptor, TypeParameterDescriptor> referenceSymbolTableExtension = this.this$0.getSymbolTable().getDescriptorExtension();
                        MemberDescriptor memberDescriptor = ExpectDeclarationRemover.access$findActualForExpect(this.this$0, it.getDescriptor());
                        Intrinsics.checkNotNull(memberDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        return (IrClass)referenceSymbolTableExtension.referenceClass((ClassDescriptor)memberDescriptor).getOwner();
                    }
                }, (Function1<? super IrFunction, ? extends IrFunction>)new Function1<IrFunction, IrFunction>(this.this$0){
                    final /* synthetic */ ExpectDeclarationRemover this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final IrFunction invoke(IrFunction it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        ReferenceSymbolTable referenceSymbolTable = this.this$0.getSymbolTable();
                        MemberDescriptor memberDescriptor = ExpectDeclarationRemover.access$findActualForExpect(this.this$0, it.getDescriptor());
                        Intrinsics.checkNotNull(memberDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                        return IrUtilsKt.referenceFunction(referenceSymbolTable, (FunctionDescriptor)memberDescriptor).getOwner();
                    }
                });
            }
        }, (Object)null);
    }

    private final MemberDescriptor findExpectForActual(MemberDescriptor $this$findExpectForActual) {
        if (!$this$findExpectForActual.isActual()) {
            throw new IllegalStateException($this$findExpectForActual.toString());
        }
        return (MemberDescriptor)CollectionsKt.singleOrNull(ExpectedActualResolverKt.findCompatibleExpectsForActual$default($this$findExpectForActual, null, 1, null));
    }

    public static final /* synthetic */ boolean access$shouldRemoveTopLevelDeclaration(ExpectDeclarationRemover $this, IrDeclaration declaration2) {
        return $this.shouldRemoveTopLevelDeclaration(declaration2);
    }

    public static final /* synthetic */ MemberDescriptor access$findActualForExpect(ExpectDeclarationRemover $this, MemberDescriptor $receiver) {
        return $this.findActualForExpect($receiver);
    }
}

