/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.project.structure.builder;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.mock.MockProject;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.org.jetbrains.kotlin.analysis.api.impl.base.util.LibraryUtils;
import ksp.org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.StandaloneProjectFactory;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.builder.KtBinaryModuleBuilder;
import ksp.org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilderDsl;
import ksp.org.jetbrains.kotlin.analysis.project.structure.impl.KtSdkModuleImpl;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import ksp.org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.annotations.NotNull;

@KtModuleBuilderDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/analysis/project/structure/builder/KtSdkModuleBuilder;", "Lksp/org/jetbrains/kotlin/analysis/project/structure/builder/KtBinaryModuleBuilder;", "kotlinCoreProjectEnvironment", "Lksp/org/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;)V", "sdkName", "", "getSdkName", "()Ljava/lang/String;", "setSdkName", "(Ljava/lang/String;)V", "addBinaryRootsFromJdkHome", "", "jdkHome", "Ljava/nio/file/Path;", "isJre", "", "build", "Lksp/org/jetbrains/kotlin/analysis/project/structure/KtSdkModule;", "analysis-api-standalone"})
public final class KtSdkModuleBuilder
extends KtBinaryModuleBuilder {
    @NotNull
    private final KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment;
    public String sdkName;

    public KtSdkModuleBuilder(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment) {
        Intrinsics.checkNotNullParameter(kotlinCoreProjectEnvironment, "kotlinCoreProjectEnvironment");
        this.kotlinCoreProjectEnvironment = kotlinCoreProjectEnvironment;
    }

    @NotNull
    public final String getSdkName() {
        String string2 = this.sdkName;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("sdkName");
        return null;
    }

    public final void setSdkName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.sdkName = string2;
    }

    public final void addBinaryRootsFromJdkHome(@NotNull Path jdkHome, boolean isJre) {
        Intrinsics.checkNotNullParameter(jdkHome, "jdkHome");
        List<Path> jdkRoots = LibraryUtils.INSTANCE.findClassesFromJdkHome(jdkHome, isJre);
        this.addBinaryRoots((Collection<? extends Path>)jdkRoots);
    }

    @Override
    @NotNull
    public KtSdkModule build() {
        List<Path> binaryRoots = this.getBinaryRoots();
        GlobalSearchScope contentScope = StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection<? extends Path>)binaryRoots, this.kotlinCoreProjectEnvironment);
        List<KtModule> list2 = this.getDirectRegularDependencies();
        List<KtModule> list3 = this.getDirectDependsOnDependencies();
        List<KtModule> list4 = this.getDirectFriendDependencies();
        TargetPlatform targetPlatform = this.getPlatform();
        MockProject mockProject = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue(mockProject, "getProject(...)");
        return new KtSdkModuleImpl(list2, list3, list4, contentScope, targetPlatform, mockProject, (Collection<? extends Path>)binaryRoots, this.getSdkName());
    }
}

