/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextKt;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import ksp.org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.SpecialNames;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRenderer;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import ksp.org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;
import ksp.org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DECOMPILED_CODE_COMMENT", "", "DECOMPILED_COMMENT_FOR_PARAMETER", "DECOMPILED_CONTRACT_STUB", "FLEXIBLE_TYPE_COMMENT", "buildDecompiledText", "Lksp/org/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "packageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "descriptors", "", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorRenderer", "Lksp/org/jetbrains/kotlin/renderer/DescriptorRenderer;", "defaultDecompilerRendererOptions", "", "Lksp/org/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "mustNotBeWrittenToDecompiledText", "", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nbuildDecompiledText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n3183#2,10:207\n*S KotlinDebug\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n*L\n162#1:207,10\n*E\n"})
public final class BuildDecompiledTextKt {
    @NotNull
    private static final String DECOMPILED_CODE_COMMENT = "/* compiled code */";
    @NotNull
    private static final String DECOMPILED_COMMENT_FOR_PARAMETER = "/* = compiled code */";
    @NotNull
    private static final String FLEXIBLE_TYPE_COMMENT = "/* platform type */";
    @NotNull
    private static final String DECOMPILED_CONTRACT_STUB = "contract { /* compiled contract */ }";

    public static final void defaultDecompilerRendererOptions(@NotNull DescriptorRendererOptions $this$defaultDecompilerRendererOptions) {
        Intrinsics.checkNotNullParameter($this$defaultDecompilerRendererOptions, "<this>");
        $this$defaultDecompilerRendererOptions.setWithDefinedIn(false);
        $this$defaultDecompilerRendererOptions.setClassWithPrimaryConstructor(true);
        $this$defaultDecompilerRendererOptions.setSecondaryConstructorsAsPrimary(false);
        $this$defaultDecompilerRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
        $this$defaultDecompilerRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.emptySet());
        $this$defaultDecompilerRendererOptions.setAlwaysRenderModifiers(true);
        $this$defaultDecompilerRendererOptions.setParameterNamesInFunctionalTypes(false);
        $this$defaultDecompilerRendererOptions.setDefaultParameterValueRenderer(defaultDecompilerRendererOptions.1.INSTANCE);
        $this$defaultDecompilerRendererOptions.setIncludePropertyConstant(true);
        $this$defaultDecompilerRendererOptions.setPropertyConstantRenderer(defaultDecompilerRendererOptions.2.INSTANCE);
    }

    public static final boolean mustNotBeWrittenToDecompiledText(@NotNull CallableMemberDescriptor $this$mustNotBeWrittenToDecompiledText) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$mustNotBeWrittenToDecompiledText, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mustNotBeWrittenToDecompiledText.getKind().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                Name name2 = $this$mustNotBeWrittenToDecompiledText.getName();
                Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
                if (!DataClassDescriptorResolver.INSTANCE.isComponentLike(name2)) {
                    Name[] nameArray = new Name[]{OperatorNameConventions.EQUALS, StandardNames.HASHCODE_NAME, OperatorNameConventions.TO_STRING};
                    if (!CollectionsKt.listOf(nameArray).contains($this$mustNotBeWrittenToDecompiledText.getName())) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@NotNull FqName packageFqName, @NotNull List<? extends DeclarationDescriptor> descriptors, @NotNull DescriptorRenderer descriptorRenderer2) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        Intrinsics.checkNotNullParameter(descriptorRenderer2, "descriptorRenderer");
        StringBuilder builder2 = new StringBuilder();
        BuildDecompiledTextKt.buildDecompiledText$appendDecompiledTextAndPackageName(builder2, packageFqName);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, descriptorRenderer2, declarationDescriptor, "", null, 16, null);
            builder2.append("\n");
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return new DecompiledText(string2);
    }

    private static final void buildDecompiledText$appendDecompiledTextAndPackageName(StringBuilder builder2, FqName $packageFqName) {
        builder2.append("// IntelliJ API Decompiler stub source generated from a class file\n// Implementation of methods is not available");
        builder2.append("\n\n");
        if (!$packageFqName.isRoot()) {
            builder2.append("package ").append(RenderingUtilsKt.render($packageFqName)).append("\n\n");
        }
    }

    private static final void buildDecompiledText$appendDescriptor$newlineExceptFirst(Ref.BooleanRef firstPassed, StringBuilder builder2) {
        if (firstPassed.element) {
            builder2.append("\n");
        } else {
            firstPassed.element = true;
        }
    }

    private static final void buildDecompiledText$appendDescriptor(StringBuilder builder2, DescriptorRenderer $descriptorRenderer, DeclarationDescriptor descriptor2, String indent, Boolean lastEnumEntry) {
        if (DescriptorUtils.isEnumEntry(descriptor2)) {
            for (AnnotationDescriptor annotation2 : descriptor2.getAnnotations()) {
                builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation2, null, 2, null));
                builder2.append(" ");
            }
            String string2 = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            builder2.append(KtPsiUtilKt.quoteIfNeeded(string2));
            Boolean bl = lastEnumEntry;
            Intrinsics.checkNotNull(bl);
            builder2.append(bl != false ? ";" : ",");
        } else {
            builder2.append(StringsKt.replace$default($descriptorRenderer.render(descriptor2), "= ...", DECOMPILED_COMMENT_FOR_PARAMETER, false, 4, null));
        }
        if (descriptor2 instanceof CallableDescriptor) {
            KotlinType kotlinType = ((CallableDescriptor)descriptor2).getReturnType();
            Intrinsics.checkNotNull(kotlinType);
            if (FlexibleTypesKt.isFlexible(kotlinType)) {
                builder2.append(" ").append(FLEXIBLE_TYPE_COMMENT);
            }
        }
        if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PropertyDescriptor) {
            if (((MemberDescriptor)descriptor2).getModality() != Modality.ABSTRACT) {
                if (descriptor2 instanceof FunctionDescriptor) {
                    StringBuilder $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240 = builder2;
                    boolean bl = false;
                    $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append(" { ");
                    AbstractContractProvider abstractContractProvider = (AbstractContractProvider)((FunctionDescriptor)descriptor2).getUserData(ContractProviderKey.INSTANCE);
                    if ((abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null) != null) {
                        $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append(DECOMPILED_CONTRACT_STUB).append("; ");
                    }
                    $this$buildDecompiledText_u24appendDescriptor_u24lambda_u240.append(DECOMPILED_CODE_COMMENT).append(" }");
                } else {
                    builder2.append(" ").append(DECOMPILED_CODE_COMMENT);
                }
            }
            if (descriptor2 instanceof PropertyDescriptor) {
                for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor2).getAccessors()) {
                    Name name2;
                    Object annotation32;
                    if (accessor.isDefault()) continue;
                    builder2.append('\n' + indent + "    ");
                    builder2.append(accessor.getVisibility().getInternalDisplayName()).append(" ");
                    builder2.append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(accessor.getModality().name())).append(" ");
                    if (accessor.isExternal()) {
                        builder2.append("external ");
                    }
                    for (Object annotation32 : accessor.getAnnotations()) {
                        builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, (AnnotationDescriptor)annotation32, null, 2, null));
                        builder2.append(" ");
                    }
                    if (accessor instanceof PropertyGetterDescriptor) {
                        builder2.append("get");
                        continue;
                    }
                    if (!(accessor instanceof PropertySetterDescriptor)) continue;
                    builder2.append("set(");
                    ValueParameterDescriptor parameterDescriptor = ((PropertySetterDescriptor)accessor).getValueParameters().get(0);
                    annotation32 = parameterDescriptor.getAnnotations().iterator();
                    while (annotation32.hasNext()) {
                        AnnotationDescriptor annotation4 = (AnnotationDescriptor)annotation32.next();
                        builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation4, null, 2, null));
                        builder2.append(" ");
                    }
                    Intrinsics.checkNotNullExpressionValue(parameterDescriptor.getName(), "getName(...)");
                    Name paramName = Intrinsics.areEqual(name2, SpecialNames.IMPLICIT_SET_PARAMETER) ? StandardNames.DEFAULT_VALUE_PARAMETER : name2;
                    StringBuilder stringBuilder2 = builder2.append(paramName.asString()).append(": ");
                    KotlinType kotlinType = parameterDescriptor.getType();
                    Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                    stringBuilder2.append($descriptorRenderer.renderType(kotlinType));
                    builder2.append(")");
                    builder2.append(" {").append(DECOMPILED_CODE_COMMENT).append(" }");
                }
            }
        } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry(descriptor2)) {
            builder2.append(" {\n");
            String subindent = indent + "    ";
            Ref.BooleanRef firstPassed = new Ref.BooleanRef();
            List allDescriptors2 = CollectionsKt.plus((Collection)DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)descriptor2), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getDefaultType().getMemberScope(), null, null, 3, null));
            Iterable $this$partition$iv = allDescriptors2;
            boolean $i$f$partition = false;
            Object first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                if (DescriptorUtils.isEnumEntry(p0)) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List enumEntries2 = pair.component1();
            List members = pair.component2();
            first$iv = enumEntries2.iterator();
            int n = 0;
            while (first$iv.hasNext()) {
                int index2 = n++;
                DeclarationDescriptor enumEntry = (DeclarationDescriptor)first$iv.next();
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                Intrinsics.checkNotNull(enumEntry);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(builder2, $descriptorRenderer, enumEntry, subindent, index2 == CollectionsKt.getLastIndex(enumEntries2));
            }
            ClassDescriptor companionObject2 = ((ClassDescriptor)descriptor2).getCompanionObjectDescriptor();
            if (companionObject2 != null) {
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, $descriptorRenderer, companionObject2, subindent, null, 16, null);
            }
            for (DeclarationDescriptor member2 : members) {
                if (!Intrinsics.areEqual(member2.getContainingDeclaration(), descriptor2) || Intrinsics.areEqual(member2, companionObject2) || member2 instanceof CallableMemberDescriptor && BuildDecompiledTextKt.mustNotBeWrittenToDecompiledText((CallableMemberDescriptor)member2)) continue;
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                Intrinsics.checkNotNull(member2);
                BuildDecompiledTextKt.buildDecompiledText$appendDescriptor$default(builder2, $descriptorRenderer, member2, subindent, null, 16, null);
            }
            builder2.append(indent).append("}");
        }
        builder2.append("\n");
    }

    static /* synthetic */ void buildDecompiledText$appendDescriptor$default(StringBuilder stringBuilder2, DescriptorRenderer descriptorRenderer2, DeclarationDescriptor declarationDescriptor, String string2, Boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = null;
        }
        BuildDecompiledTextKt.buildDecompiledText$appendDescriptor(stringBuilder2, descriptorRenderer2, declarationDescriptor, string2, bl);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.SYNTHESIZED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

