/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin;

import java.lang.reflect.Constructor;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.kotlin.idea.KotlinLanguage;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class KtNodeType
extends IElementType {
    private final Constructor<? extends KtElement> myPsiFactory;

    public KtNodeType(@NotNull @NonNls String debugName, Class<? extends KtElement> psiClass) {
        if (debugName == null) {
            KtNodeType.$$$reportNull$$$0(0);
        }
        super(debugName, KotlinLanguage.INSTANCE);
        try {
            this.myPsiFactory = psiClass != null ? psiClass.getConstructor(ASTNode.class) : null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Must have a constructor with ASTNode");
        }
    }

    public KtElement createPsi(ASTNode node) {
        assert (node.getElementType() == this);
        try {
            if (this.myPsiFactory == null) {
                return new KtElementImpl(node);
            }
            return this.myPsiFactory.newInstance(node);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating psi element for node", e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "ksp/org/jetbrains/kotlin/KtNodeType", "<init>"));
    }

    public static class KtLeftBoundNodeType
    extends KtNodeType {
        public KtLeftBoundNodeType(@NotNull @NonNls String debugName, Class<? extends KtElement> psiClass) {
            if (debugName == null) {
                KtLeftBoundNodeType.$$$reportNull$$$0(0);
            }
            super(debugName, psiClass);
        }

        @Override
        public boolean isLeftBound() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "ksp/org/jetbrains/kotlin/KtNodeType$KtLeftBoundNodeType", "<init>"));
        }
    }
}

