/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import ksp.com.intellij.openapi.util.io.ByteArraySequence;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.io.UnsyncByteArrayInputStream;
import org.jetbrains.annotations.NotNull;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    protected byte[] myBuffer;
    protected int myCount;
    private boolean myIsShared;
    @NotNull
    private final ByteArrayAllocator myAllocator;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int size) {
        this(ArrayUtil.newByteArray(size));
    }

    public UnsyncByteArrayOutputStream(byte @NotNull [] buffer) {
        if (buffer == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(0);
        }
        this.myAllocator = size -> ArrayUtil.newByteArray(size);
        this.myBuffer = buffer;
    }

    public UnsyncByteArrayOutputStream(@NotNull ByteArrayAllocator allocator, int initialSize) {
        if (allocator == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(1);
        }
        this.myAllocator = allocator;
        this.myBuffer = allocator.allocate(initialSize);
    }

    @Override
    public void write(int b) {
        int newCount = this.myCount + 1;
        if (newCount > this.myBuffer.length || this.myIsShared) {
            this.grow(newCount);
            this.myIsShared = false;
        }
        this.myBuffer[this.myCount] = (byte)b;
        this.myCount = newCount;
    }

    private void grow(int newCount) {
        int newLength = newCount > this.myBuffer.length ? Math.max(this.myBuffer.length << 1, newCount) : this.myBuffer.length;
        byte[] newBuffer = this.myAllocator.allocate(newLength);
        System.arraycopy(this.myBuffer, 0, newBuffer, 0, this.myBuffer.length);
        this.myBuffer = newBuffer;
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) {
        if (b == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(2);
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newCount = this.myCount + len;
        if (newCount > this.myBuffer.length || this.myIsShared) {
            this.grow(newCount);
            this.myIsShared = false;
        }
        System.arraycopy(b, off, this.myBuffer, this.myCount, len);
        this.myCount = newCount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.myBuffer, 0, this.myCount);
    }

    public void reset() {
        this.myCount = 0;
    }

    public byte[] toByteArray() {
        if (this.myBuffer.length == this.myCount) {
            this.myIsShared = true;
            return this.myBuffer;
        }
        return Arrays.copyOf(this.myBuffer, this.myCount);
    }

    public int size() {
        return this.myCount;
    }

    public String toString() {
        return new String(this.myBuffer, 0, this.myCount, StandardCharsets.UTF_8);
    }

    @NotNull
    public ByteArraySequence toByteArraySequence() {
        return this.myCount == 0 ? ByteArraySequence.EMPTY : new ByteArraySequence(this.myBuffer, 0, this.myCount);
    }

    @NotNull
    public InputStream toInputStream() {
        return new UnsyncByteArrayInputStream(this.myBuffer, 0, this.myCount);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/util/io/UnsyncByteArrayOutputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface ByteArrayAllocator {
        public byte[] allocate(int var1);
    }
}

