/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import ksp.com.intellij.util.containers.SLRUMap;
import ksp.com.intellij.util.containers.hash.EqualityPolicy;
import ksp.com.intellij.util.io.ResourceHandle;
import org.jetbrains.annotations.NotNull;

public abstract class FileAccessorCache<K, T>
implements EqualityPolicy<K> {
    private final SLRUMap<K, Handle<T>> myCache;
    private final List<T> myElementsToBeDisposed = new ArrayList<T>();
    private final Object myCacheLock = new Object();
    private final Object myUpdateLock = new Object();

    public FileAccessorCache(int protectedQueueSize, int probationalQueueSize) {
        this.myCache = new SLRUMap<K, Handle<T>>(protectedQueueSize, probationalQueueSize, this){

            @Override
            protected void onDropFromCache(K key, @NotNull Handle<T> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                value2.release();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "ksp/com/intellij/util/io/FileAccessorCache$1", "onDropFromCache"));
            }
        };
    }

    @NotNull
    protected abstract T createAccessor(K var1) throws IOException;

    protected abstract void disposeAccessor(@NotNull T var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Handle<T> get(K key) {
        Handle<T> cached2 = this.getIfCached(key);
        if (cached2 != null) {
            Handle<T> handle2 = cached2;
            if (handle2 != null) return handle2;
            FileAccessorCache.$$$reportNull$$$0(0);
            return handle2;
        }
        Object object = this.myUpdateLock;
        // MONITORENTER : object
        cached2 = this.getIfCached(key);
        if (cached2 != null) {
            Handle<T> handle3 = cached2;
            // MONITOREXIT : object
            if (handle3 != null) return handle3;
            FileAccessorCache.$$$reportNull$$$0(1);
            return handle3;
        }
        Handle<T> handle4 = this.createHandle(key);
        // MONITOREXIT : object
        if (handle4 != null) return handle4;
        FileAccessorCache.$$$reportNull$$$0(2);
        return handle4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handle<T> createHandle(K key) {
        try {
            Handle<T> cached2 = new Handle<T>(this.createAccessor(key), this);
            cached2.allocate();
            Object object = this.myCacheLock;
            synchronized (object) {
                this.myCache.put(key, cached2);
            }
            this.disposeInvalidAccessors();
            return cached2;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeInvalidAccessors() {
        ArrayList<T> fileAccessorsToBeDisposed;
        Iterator iterator2 = this.myCacheLock;
        synchronized (iterator2) {
            if (this.myElementsToBeDisposed.isEmpty()) {
                return;
            }
            fileAccessorsToBeDisposed = new ArrayList<T>(this.myElementsToBeDisposed);
            this.myElementsToBeDisposed.clear();
        }
        for (Object t : fileAccessorsToBeDisposed) {
            try {
                this.disposeAccessor(t);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handle<T> getIfCached(K key) {
        Object object = this.myCacheLock;
        synchronized (object) {
            Handle<T> value2 = this.myCache.get(key);
            if (value2 != null) {
                value2.allocate();
            }
            return value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        try {
            Object object = this.myCacheLock;
            synchronized (object) {
                boolean bl = this.myCache.remove(key);
                return bl;
            }
        }
        finally {
            Object object = this.myUpdateLock;
            synchronized (object) {
                this.disposeInvalidAccessors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object;
        try {
            object = this.myCacheLock;
            synchronized (object) {
                this.myCache.clear();
            }
        }
        finally {
            object = this.myUpdateLock;
            synchronized (object) {
                this.disposeInvalidAccessors();
            }
        }
    }

    @Override
    public int getHashCode(K value2) {
        return value2.hashCode();
    }

    @Override
    public boolean isEqual(K val1, K val2) {
        return val1.equals(val2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/util/io/FileAccessorCache", "get"));
    }

    public static final class Handle<T>
    extends ResourceHandle<T> {
        private final FileAccessorCache<?, ? super T> myOwner;
        @NotNull
        private final T myResource;
        private final AtomicInteger myRefCount;

        public Handle(@NotNull T fileAccessor, @NotNull FileAccessorCache<?, ? super T> owner) {
            if (fileAccessor == null) {
                Handle.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Handle.$$$reportNull$$$0(1);
            }
            this.myRefCount = new AtomicInteger(1);
            this.myResource = fileAccessor;
            this.myOwner = owner;
        }

        public void allocate() {
            this.myRefCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.myRefCount.decrementAndGet() == 0) {
                Object object = ((FileAccessorCache)this.myOwner).myCacheLock;
                synchronized (object) {
                    ((FileAccessorCache)this.myOwner).myElementsToBeDisposed.add(this.myResource);
                }
            }
        }

        public int getRefCount() {
            return this.myRefCount.get();
        }

        @Override
        public void close() {
            this.release();
        }

        @Override
        @NotNull
        public T get() {
            T t = this.myResource;
            if (t == null) {
                Handle.$$$reportNull$$$0(2);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAccessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/util/io/FileAccessorCache$Handle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/util/io/FileAccessorCache$Handle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

