/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.NotNull;

public final class ByteBufferUtil {
    public static boolean cleanBuffer(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            ByteBufferUtil.$$$reportNull$$$0(0);
        }
        if (!buffer.isDirect()) {
            return true;
        }
        if (JavaVersion.current().feature >= 9) {
            Object unsafe = ReflectionUtil.getUnsafe();
            try {
                MethodType type2 = MethodType.methodType(Void.TYPE, ByteBuffer.class);
                MethodHandle handle2 = MethodHandles.lookup().findVirtual(unsafe.getClass(), "invokeCleaner", type2);
                handle2.invoke(unsafe, buffer);
                return true;
            }
            catch (Throwable t) {
                Logger.getInstance(ByteBufferUtil.class).warn(t);
                return false;
            }
        }
        try {
            Class<?> directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
            Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
            Object cleaner = directBufferClass.getDeclaredMethod("cleaner", new Class[0]).invoke((Object)buffer, new Object[0]);
            if (cleaner != null) {
                cleanerClass.getDeclaredMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
            }
            return true;
        }
        catch (Exception e) {
            Logger.getInstance(ByteBufferUtil.class).warn(e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "ksp/com/intellij/util/io/ByteBufferUtil", "cleanBuffer"));
    }
}

