/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.codeInsight;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.CodeDocumentationAwareCommenterEx;
import ksp.com.intellij.lang.Commenter;
import ksp.com.intellij.lang.LanguageCommenters;
import ksp.com.intellij.lang.LanguageParserDefinitions;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.psi.PsiComment;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class CommentUtilCore {
    public static boolean isComment(@Nullable PsiElement element2) {
        return element2 != null && CommentUtilCore.isComment(element2.getNode());
    }

    public static boolean isComment(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        IElementType type2 = node.getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type2.getLanguage());
        return parserDefinition != null && parserDefinition.getCommentTokens().contains(type2);
    }

    public static boolean isCommentTextElement(PsiElement element2) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element2.getLanguage());
        if (commenter instanceof CodeDocumentationAwareCommenterEx) {
            CodeDocumentationAwareCommenterEx commenterEx = (CodeDocumentationAwareCommenterEx)commenter;
            if (commenterEx.isDocumentationCommentText(element2)) {
                return true;
            }
            if (element2 instanceof PsiComment && commenterEx.isDocumentationComment((PsiComment)element2)) {
                return false;
            }
        }
        return CommentUtilCore.isComment(element2);
    }
}

