/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.presentation.java;

import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.extapi.psi.StubBasedPsiElementBase;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassOwner;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiEnumConstant;
import ksp.com.intellij.psi.PsiEnumConstantInitializer;
import ksp.com.intellij.psi.PsiField;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiFunctionalExpression;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import ksp.com.intellij.psi.util.PsiExpressionTrimRenderer;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ClassPresentationUtil {
    private ClassPresentationUtil() {
    }

    @Nls
    public static String getNameForClass(@NotNull PsiClass aClass, boolean qualified) {
        String qName;
        if (aClass == null) {
            ClassPresentationUtil.$$$reportNull$$$0(0);
        }
        if (aClass instanceof PsiAnonymousClass) {
            if (aClass instanceof PsiEnumConstantInitializer) {
                PsiEnumConstant enumConstant = ((PsiEnumConstantInitializer)aClass).getEnumConstant();
                String name2 = enumConstant.getName();
                return JavaPsiBundle.message("enum.constant.context", name2, ClassPresentationUtil.getContextName(enumConstant, qualified, false));
            }
            return JavaPsiBundle.message("anonymous.class.context.display", ClassPresentationUtil.getContextName(aClass, qualified, false));
        }
        if (qualified && (qName = aClass.getQualifiedName()) != null) {
            return qName;
        }
        String className2 = aClass.getName();
        String contextName = ClassPresentationUtil.getContextName(aClass, qualified);
        return contextName != null ? JavaPsiBundle.message("class.context.display", className2, contextName) : className2;
    }

    private static String getNameForElement(@NotNull PsiElement element2, boolean qualified, boolean ignorePsiClassOwner) {
        if (element2 == null) {
            ClassPresentationUtil.$$$reportNull$$$0(1);
        }
        if (element2 instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element2, qualified);
        }
        if (element2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element2;
            String methodName = method.getName();
            return JavaPsiBundle.message("method.context.display", methodName, ClassPresentationUtil.getContextName(method, qualified, false));
        }
        if (element2 instanceof PsiClassOwner && ignorePsiClassOwner) {
            return null;
        }
        if (element2 instanceof PsiFile) {
            return ((PsiFile)element2).getName();
        }
        if (element2 instanceof PsiField) {
            return ((PsiField)element2).getName() + " in " + ClassPresentationUtil.getContextName(element2, qualified, false);
        }
        return null;
    }

    public static String getContextName(@NotNull PsiElement element2, boolean qualified) {
        if (element2 == null) {
            ClassPresentationUtil.$$$reportNull$$$0(2);
        }
        return ClassPresentationUtil.getContextName(element2, qualified, true);
    }

    public static String getContextName(@NotNull PsiElement element2, boolean qualified, boolean ignorePsiClassOwner) {
        PsiElement parent2;
        if (element2 == null) {
            ClassPresentationUtil.$$$reportNull$$$0(3);
        }
        if ((parent2 = PsiTreeUtil.getStubOrPsiParentOfType(element2, PsiMember.class)) == null) {
            parent2 = element2.getContainingFile();
        }
        while (parent2 != null) {
            String name2 = ClassPresentationUtil.getNameForElement(parent2, qualified, ignorePsiClassOwner);
            if (name2 != null) {
                return name2;
            }
            if (parent2 instanceof PsiFile) {
                return null;
            }
            parent2 = PsiTreeUtil.getStubOrPsiParent(parent2);
        }
        return null;
    }

    @Nls
    public static String getFunctionalExpressionPresentation(PsiFunctionalExpression functionalExpression, boolean qualified) {
        Object stub = ((StubBasedPsiElementBase)((Object)functionalExpression)).getGreenStub();
        String lambdaText = stub instanceof FunctionalExpressionStub ? ((FunctionalExpressionStub)stub).getPresentableText() : PsiExpressionTrimRenderer.render(functionalExpression);
        return JavaPsiBundle.message("class.context.display", lambdaText, ClassPresentationUtil.getContextName(functionalExpression, qualified, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/presentation/java/ClassPresentationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameForClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameForElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

