/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree;

import java.util.Objects;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.progress.ProgressIndicator;
import ksp.com.intellij.psi.PsiErrorElement;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import ksp.com.intellij.psi.impl.source.tree.LazyParseableElement;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.util.ThreeState;
import ksp.com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.annotations.NotNull;

public class ASTShallowComparator
implements ShallowNodeComparator<ASTNode, ASTNode> {
    private final ProgressIndicator myIndicator;

    public ASTShallowComparator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ASTShallowComparator.$$$reportNull$$$0(0);
        }
        this.myIndicator = indicator;
    }

    @Override
    @NotNull
    public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            ASTShallowComparator.$$$reportNull$$$0(1);
        }
        if (newNode == null) {
            ASTShallowComparator.$$$reportNull$$$0(2);
        }
        ThreeState threeState = this.textMatches(oldNode, newNode);
        if (threeState == null) {
            ASTShallowComparator.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    private ThreeState textMatches(ASTNode oldNode, ASTNode newNode) {
        String newText;
        this.myIndicator.checkCanceled();
        String oldText = TreeUtil.isCollapsedChameleon(oldNode) ? oldNode.getText() : null;
        String string2 = newText = TreeUtil.isCollapsedChameleon(newNode) ? newNode.getText() : null;
        if (oldText != null && newText != null) {
            return oldText.equals(newText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldText != null) {
            return this.compareTreeToText((TreeElement)newNode, oldText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (newText != null) {
            return this.compareTreeToText((TreeElement)oldNode, newText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldNode instanceof ForeignLeafPsiElement) {
            return newNode instanceof ForeignLeafPsiElement && oldNode.getText().equals(newNode.getText()) ? ThreeState.YES : ThreeState.NO;
        }
        if (newNode instanceof ForeignLeafPsiElement) {
            return ThreeState.NO;
        }
        if (oldNode instanceof LeafElement) {
            return ((LeafElement)oldNode).textMatches(newNode.getChars()) ? ThreeState.YES : ThreeState.NO;
        }
        if (newNode instanceof LeafElement) {
            return ((LeafElement)newNode).textMatches(oldNode.getChars()) ? ThreeState.YES : ThreeState.NO;
        }
        if (oldNode instanceof PsiErrorElement && newNode instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)((Object)oldNode);
            PsiErrorElement e2 = (PsiErrorElement)((Object)newNode);
            if (!Objects.equals(e1.getErrorDescription(), e2.getErrorDescription())) {
                return ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    }

    private boolean compareTreeToText(@NotNull TreeElement root, final @NotNull String text) {
        if (root == null) {
            ASTShallowComparator.$$$reportNull$$$0(4);
        }
        if (text == null) {
            ASTShallowComparator.$$$reportNull$$$0(5);
        }
        final int[] curOffset = new int[]{0};
        root.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(text, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                ASTShallowComparator.this.myIndicator.checkCanceled();
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0] == text.length();
    }

    @Override
    public boolean typesEqual(@NotNull ASTNode n1, @NotNull ASTNode n2) {
        if (n1 == null) {
            ASTShallowComparator.$$$reportNull$$$0(6);
        }
        if (n2 == null) {
            ASTShallowComparator.$$$reportNull$$$0(7);
        }
        return n1.getElementType() == n2.getElementType();
    }

    @Override
    public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull ASTNode n2) {
        if (n1 == null) {
            ASTShallowComparator.$$$reportNull$$$0(8);
        }
        if (n2 == null) {
            ASTShallowComparator.$$$reportNull$$$0(9);
        }
        if (n1 instanceof LeafElement && n2 instanceof LeafElement) {
            return this.textMatches(n1, n2) == ThreeState.YES;
        }
        if (n1 instanceof PsiErrorElement && n2 instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)((Object)n1);
            PsiErrorElement e2 = (PsiErrorElement)((Object)n2);
            if (!Objects.equals(e1.getErrorDescription(), e2.getErrorDescription())) {
                return false;
            }
        }
        return ((TreeElement)n1).hc() == ((TreeElement)n2).hc();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/ASTShallowComparator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/ASTShallowComparator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deepEqual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deepEqual";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTreeToText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "typesEqual";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hashCodesEqual";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

