/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.Set;
import java.util.function.Function;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiArrayInitializerExpression;
import ksp.com.intellij.psi.PsiAssignmentExpression;
import ksp.com.intellij.psi.PsiBreakStatement;
import ksp.com.intellij.psi.PsiCallExpression;
import ksp.com.intellij.psi.PsiConditionalExpression;
import ksp.com.intellij.psi.PsiDiamondType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiExpressionList;
import ksp.com.intellij.psi.PsiExpressionStatement;
import ksp.com.intellij.psi.PsiFunctionalExpression;
import ksp.com.intellij.psi.PsiLambdaExpression;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodCallExpression;
import ksp.com.intellij.psi.PsiNewExpression;
import ksp.com.intellij.psi.PsiParenthesizedExpression;
import ksp.com.intellij.psi.PsiPrimitiveType;
import ksp.com.intellij.psi.PsiReturnStatement;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiSwitchExpression;
import ksp.com.intellij.psi.PsiSwitchLabeledRuleStatement;
import ksp.com.intellij.psi.PsiThrowStatement;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiVariable;
import ksp.com.intellij.psi.PsiYieldStatement;
import ksp.com.intellij.psi.infos.MethodCandidateInfo;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiTypesUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nullable;

public final class PsiPolyExpressionUtil {
    public static boolean hasStandaloneForm(PsiExpression expression2) {
        return !(expression2 instanceof PsiFunctionalExpression) && !(expression2 instanceof PsiParenthesizedExpression) && !(expression2 instanceof PsiConditionalExpression) && !(expression2 instanceof PsiSwitchExpression) && !(expression2 instanceof PsiCallExpression);
    }

    public static boolean isPolyExpression(PsiExpression expression2) {
        ConditionalKind conditionalKind;
        if (expression2 instanceof PsiFunctionalExpression) {
            return true;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isPolyExpression(((PsiParenthesizedExpression)expression2).getExpression());
        }
        if (expression2 instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression2)) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression2);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression2, (? super PsiExpression expr) -> ((PsiMethodCallExpression)expr).resolveMethod());
        }
        if (expression2 instanceof PsiConditionalExpression && (conditionalKind = PsiPolyExpressionUtil.isBooleanOrNumeric(expression2)) == null) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression2);
        }
        if (expression2 instanceof PsiSwitchExpression) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression2);
        }
        return false;
    }

    public static boolean isMethodCallPolyExpression(PsiExpression expression2, PsiMethod method) {
        return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression2, (? super PsiExpression e) -> method);
    }

    private static boolean isMethodCallPolyExpression(PsiExpression expression2, Function<? super PsiExpression, ? extends PsiMethod> methodResolver) {
        if (PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression2) && ((PsiCallExpression)expression2).getTypeArguments().length == 0) {
            PsiMethod method = methodResolver.apply(expression2);
            return method == null || PsiPolyExpressionUtil.isMethodCallTypeDependsOnInference(expression2, method);
        }
        return false;
    }

    private static boolean isMethodCallTypeDependsOnInference(PsiExpression expression2, PsiMethod method) {
        Set<PsiTypeParameter> typeParameters2 = ContainerUtil.set(method.getTypeParameters());
        if (!typeParameters2.isEmpty()) {
            PsiType returnType2 = method.getReturnType();
            if (returnType2 != null) {
                return PsiTypesUtil.mentionsTypeParameters(returnType2, typeParameters2);
            }
        } else if (method.isConstructor() && expression2 instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression2)) {
            return true;
        }
        return false;
    }

    public static boolean isInAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement context2 = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return context2 instanceof PsiExpressionList || context2 instanceof PsiArrayInitializerExpression || context2 instanceof PsiConditionalExpression && (expr instanceof PsiCallExpression || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context2)) || PsiPolyExpressionUtil.isSwitchExpressionAssignmentOrInvocationContext(expr) || PsiPolyExpressionUtil.isAssignmentContext(expr, context2);
    }

    private static boolean isSwitchExpressionAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(expr).getParent();
        if (parent2 instanceof PsiExpressionStatement && parent2.getParent() instanceof PsiSwitchLabeledRuleStatement || parent2 instanceof PsiBreakStatement || parent2 instanceof PsiYieldStatement || parent2 instanceof PsiThrowStatement) {
            PsiSwitchExpression switchExpression = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiSwitchExpression.class, true, PsiMember.class, PsiLambdaExpression.class);
            return switchExpression != null && PsiUtil.getSwitchResultExpressions(switchExpression).contains(expr) && PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(switchExpression);
        }
        return false;
    }

    private static boolean isAssignmentContext(PsiExpression expr, PsiElement context2) {
        return PsiUtil.isCondition(expr, context2) || context2 instanceof PsiReturnStatement || context2 instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context2).getOperationTokenType() == JavaTokenType.EQ || context2 instanceof PsiVariable && !PsiPolyExpressionUtil.isVarContext((PsiVariable)context2) || context2 instanceof PsiLambdaExpression;
    }

    private static boolean isVarContext(PsiVariable variable2) {
        PsiTypeElement typeElement;
        return PsiUtil.isLanguageLevel10OrHigher(variable2) && (typeElement = variable2.getTypeElement()) != null && typeElement.isInferredType();
    }

    public static boolean isExpressionOfPrimitiveType(@Nullable PsiExpression arg) {
        if (arg != null && !PsiPolyExpressionUtil.isPolyExpression(arg)) {
            PsiType type2 = arg.getType();
            return type2 instanceof PsiPrimitiveType && type2 != PsiType.NULL;
        }
        if (arg instanceof PsiNewExpression || arg instanceof PsiFunctionalExpression) {
            return false;
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isExpressionOfPrimitiveType(((PsiParenthesizedExpression)arg).getExpression());
        }
        if (arg instanceof PsiConditionalExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(arg) != null;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)arg).resolveMethod();
            return method != null && method.getReturnType() instanceof PsiPrimitiveType;
        }
        if (arg instanceof PsiSwitchExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(arg) != null;
        }
        assert (false) : arg;
        return false;
    }

    public static boolean sameBooleanOrNumeric(PsiExpression thenExpression, PsiExpression elseExpression) {
        ConditionalKind elseKind;
        ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
        if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == ConditionalKind.NULL) {
            return thenKind != null;
        }
        if (thenKind == ConditionalKind.NULL) {
            return elseKind != null;
        }
        return false;
    }

    private static ConditionalKind isBooleanOrNumeric(PsiExpression expr) {
        JavaResolveResult result2;
        PsiMethod method;
        if (expr instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(((PsiParenthesizedExpression)expr).getExpression());
        }
        if (expr == null) {
            return null;
        }
        PsiType type2 = null;
        if (expr instanceof PsiNewExpression && !PsiDiamondType.hasDiamond((PsiNewExpression)expr) || PsiPolyExpressionUtil.hasStandaloneForm(expr)) {
            type2 = expr.getType();
        } else if (expr instanceof PsiMethodCallExpression && (method = (PsiMethod)(result2 = ((PsiMethodCallExpression)expr).getMethodExpression().advancedResolve(false)).getElement()) != null) {
            type2 = method.getReturnType();
            if (result2 instanceof MethodCandidateInfo) {
                PsiSubstitutor substitutor2 = ((MethodCandidateInfo)result2).getSubstitutorFromQualifier();
                type2 = substitutor2.substitute(type2);
            }
        }
        ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(type2);
        if (kind != null) {
            return kind;
        }
        if (expr instanceof PsiConditionalExpression) {
            ConditionalKind elseKind;
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
            if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == ConditionalKind.NULL) {
                return thenKind;
            }
            if (thenKind == ConditionalKind.NULL) {
                return elseKind;
            }
        }
        if (expr instanceof PsiSwitchExpression) {
            ConditionalKind switchKind = null;
            for (PsiExpression resultExpression2 : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)expr)) {
                ConditionalKind resultKind = PsiPolyExpressionUtil.isBooleanOrNumeric(resultExpression2);
                if (resultKind == null) {
                    return null;
                }
                if (switchKind == null) {
                    switchKind = resultKind;
                    continue;
                }
                if (switchKind == resultKind) continue;
                if (switchKind == ConditionalKind.NULL) {
                    switchKind = resultKind;
                    continue;
                }
                if (resultKind == ConditionalKind.NULL) continue;
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static ConditionalKind isBooleanOrNumericType(PsiType type2) {
        if (type2 == PsiType.NULL) {
            return ConditionalKind.NULL;
        }
        if (TypeConversionUtil.isNumericType(type2)) {
            return ConditionalKind.NUMERIC;
        }
        if (TypeConversionUtil.isBooleanType(type2)) {
            return ConditionalKind.BOOLEAN;
        }
        return null;
    }

    private static enum ConditionalKind {
        BOOLEAN,
        NUMERIC,
        NULL;

    }
}

