/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.light;

import java.util.ArrayList;
import java.util.List;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.java.JavaLanguage;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiReferenceList;
import ksp.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.annotations.NotNull;

public class LightReferenceListBuilder
extends LightElement
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private volatile PsiClassType[] myCachedTypes;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public LightReferenceListBuilder(PsiManager manager, PsiReferenceList.Role role) {
        this(manager, JavaLanguage.INSTANCE, role);
    }

    public LightReferenceListBuilder(PsiManager manager, Language language, PsiReferenceList.Role role) {
        super(manager, language);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory(this.getProject());
    }

    @Override
    public String toString() {
        return "light reference list";
    }

    public void addReference(PsiClass aClass) {
        this.addReference(aClass.getQualifiedName());
    }

    public void addReference(String qualifiedName2) {
        this.myRefs.add(this.myFactory.createReferenceElementByFQClassName(qualifiedName2, this.getResolveScope()));
    }

    public void addReference(PsiClassType type2) {
        this.myRefs.add(this.myFactory.createReferenceElementByType(type2));
    }

    @Override
    public PsiJavaCodeReferenceElement @NotNull [] getReferenceElements() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = this.myRefs.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
        if (psiJavaCodeReferenceElementArray == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(0);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public PsiClassType @NotNull [] getReferencedTypes() {
        PsiClassType[] types2 = this.myCachedTypes;
        if (types2 == null) {
            int size = this.myRefs.size();
            types2 = size == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[size];
            for (int i = 0; i < size; ++i) {
                types2[i] = this.myFactory.createType(this.myRefs.get(i));
            }
            this.myCachedTypes = types2;
        }
        if (types2 == null) {
            LightReferenceListBuilder.$$$reportNull$$$0(1);
        }
        return types2;
    }

    @Override
    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ksp/com/intellij/psi/impl/light/LightReferenceListBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

