/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.java.stubs.impl;

import ksp.com.intellij.extapi.psi.StubBasedPsiElementBase;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.impl.DebugUtil;
import ksp.com.intellij.psi.impl.java.stubs.JavaClassElementType;
import ksp.com.intellij.psi.impl.java.stubs.PsiClassStub;
import ksp.com.intellij.psi.stubs.StubBase;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassStubImpl<T extends PsiClass>
extends StubBase<T>
implements PsiClassStub<T> {
    private static final int DEPRECATED = 1;
    private static final int INTERFACE = 2;
    private static final int ENUM = 4;
    private static final int ENUM_CONSTANT_INITIALIZER = 8;
    private static final int ANONYMOUS = 16;
    private static final int ANON_TYPE = 32;
    private static final int IN_QUALIFIED_NEW = 64;
    private static final int DEPRECATED_ANNOTATION = 128;
    private static final int ANONYMOUS_INNER = 256;
    private static final int LOCAL_CLASS_INNER = 512;
    private static final int HAS_DOC_COMMENT = 1024;
    private static final int RECORD = 2048;
    private final String myQualifiedName;
    private final String myName;
    private final String myBaseRefText;
    private final short myFlags;
    private String mySourceFileName;

    public PsiClassStubImpl(@NotNull JavaClassElementType type2, StubElement parent2, @Nullable String qualifiedName2, @Nullable String name2, @Nullable String baseRefText, short flags) {
        if (type2 == null) {
            PsiClassStubImpl.$$$reportNull$$$0(0);
        }
        super(parent2, type2);
        this.myQualifiedName = qualifiedName2;
        this.myName = name2;
        this.myBaseRefText = baseRefText;
        this.myFlags = flags;
        if (StubBasedPsiElementBase.ourTraceStubAstBinding) {
            String creationTrace = "Stub creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            this.putUserData(StubBasedPsiElementBase.CREATION_TRACE, creationTrace);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    public String getBaseClassReferenceText() {
        return this.myBaseRefText;
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet(this.myFlags, 1);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet(this.myFlags, 128);
    }

    @Override
    public boolean isInterface() {
        return BitUtil.isSet(this.myFlags, 2);
    }

    @Override
    public boolean isEnum() {
        return BitUtil.isSet(this.myFlags, 4);
    }

    @Override
    public boolean isRecord() {
        return BitUtil.isSet(this.myFlags, 2048);
    }

    @Override
    public boolean isEnumConstantInitializer() {
        return PsiClassStubImpl.isEnumConstInitializer(this.myFlags);
    }

    public static boolean isEnumConstInitializer(short flags) {
        return BitUtil.isSet(flags, 8);
    }

    @Override
    public boolean isAnonymous() {
        return PsiClassStubImpl.isAnonymous(this.myFlags);
    }

    public static boolean isAnonymous(short flags) {
        return BitUtil.isSet(flags, 16);
    }

    @Override
    public boolean isAnnotationType() {
        return BitUtil.isSet(this.myFlags, 32);
    }

    @Override
    public boolean hasDocComment() {
        return BitUtil.isSet(this.myFlags, 1024);
    }

    @Override
    public String getSourceFileName() {
        return this.mySourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.mySourceFileName = sourceFileName;
    }

    @Override
    public boolean isAnonymousInQualifiedNew() {
        return BitUtil.isSet(this.myFlags, 64);
    }

    public short getFlags() {
        return this.myFlags;
    }

    public static short packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation, boolean anonymousInner, boolean localClassInner, boolean hasDocComment) {
        return PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, isEnumConstantInitializer, isAnonymous, isAnnotationType, isInQualifiedNew, hasDeprecatedAnnotation, anonymousInner, localClassInner, hasDocComment, false);
    }

    public static short packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation, boolean anonymousInner, boolean localClassInner, boolean hasDocComment, boolean isRecord) {
        short flags = 0;
        if (isDeprecated) {
            flags = (short)(flags | 1);
        }
        if (isInterface) {
            flags = (short)(flags | 2);
        }
        if (isEnum) {
            flags = (short)(flags | 4);
        }
        if (isEnumConstantInitializer) {
            flags = (short)(flags | 8);
        }
        if (isAnonymous) {
            flags = (short)(flags | 0x10);
        }
        if (isAnnotationType) {
            flags = (short)(flags | 0x20);
        }
        if (isInQualifiedNew) {
            flags = (short)(flags | 0x40);
        }
        if (hasDeprecatedAnnotation) {
            flags = (short)(flags | 0x80);
        }
        if (anonymousInner) {
            flags = (short)(flags | 0x100);
        }
        if (localClassInner) {
            flags = (short)(flags | 0x200);
        }
        if (hasDocComment) {
            flags = (short)(flags | 0x400);
        }
        if (isRecord) {
            flags = (short)(flags | 0x800);
        }
        return flags;
    }

    public boolean isAnonymousInner() {
        return BitUtil.isSet(this.myFlags, 256);
    }

    public boolean isLocalClassInner() {
        return BitUtil.isSet(this.myFlags, 512);
    }

    @Override
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("PsiClassStub[");
        if (this.isInterface()) {
            builder2.append("interface ");
        }
        if (this.isAnonymous()) {
            builder2.append("anonymous ");
        }
        if (this.isEnum()) {
            builder2.append("enum ");
        }
        if (this.isRecord()) {
            builder2.append("record ");
        }
        if (this.isAnnotationType()) {
            builder2.append("annotation ");
        }
        if (this.isEnumConstantInitializer()) {
            builder2.append("enumInit ");
        }
        if (this.isDeprecated()) {
            builder2.append("deprecated ");
        }
        if (this.hasDeprecatedAnnotation()) {
            builder2.append("deprecatedA ");
        }
        builder2.append("name=").append(this.getName()).append(" fqn=").append(this.getQualifiedName());
        if (this.getBaseClassReferenceText() != null) {
            builder2.append(" baseref=").append(this.getBaseClassReferenceText());
        }
        if (this.isAnonymousInQualifiedNew()) {
            builder2.append(" inqualifnew");
        }
        if (this.isAnonymousInner()) {
            builder2.append(" jvmAnonymousInner");
        }
        if (this.isLocalClassInner()) {
            builder2.append(" jvmLocalClassInner");
        }
        builder2.append("]");
        return builder2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "ksp/com/intellij/psi/impl/java/stubs/impl/PsiClassStubImpl", "<init>"));
    }
}

