/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.java.stubs;

import java.util.List;
import java.util.Objects;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiLambdaExpression;
import ksp.com.intellij.psi.impl.cache.RecordUtil;
import ksp.com.intellij.psi.impl.java.stubs.FunctionalExpressionElementType;
import ksp.com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import ksp.com.intellij.psi.impl.source.tree.LightTreeUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.java.PsiLambdaExpressionImpl;
import ksp.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class LambdaExpressionElementType
extends FunctionalExpressionElementType<PsiLambdaExpression> {
    public LambdaExpressionElementType() {
        super("LAMBDA_EXPRESSION");
    }

    @Override
    public PsiLambdaExpression createPsi(@NotNull ASTNode node) {
        if (node == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(0);
        }
        return new PsiLambdaExpressionImpl(node);
    }

    @Override
    public PsiLambdaExpression createPsi(@NotNull FunctionalExpressionStub<PsiLambdaExpression> stub) {
        if (stub == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(1);
        }
        return new PsiLambdaExpressionImpl(stub);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        return new CompositeElement(this){

            @Override
            public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
                if (child == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.replaceChildInternal(child, JavaSourceUtil.addParenthToReplacedChild(child, newElement, this.getManager()));
            }

            @Override
            public int getChildRole(@NotNull ASTNode child) {
                IElementType elType;
                if (child == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((elType = child.getElementType()) == JavaTokenType.ARROW) {
                    return 252;
                }
                if (elType == JavaElementType.PARAMETER_LIST) {
                    return 14;
                }
                if (elType == JavaElementType.CODE_BLOCK) {
                    return 18;
                }
                return 64;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "child";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElement";
                        break;
                    }
                }
                objectArray2[1] = "ksp/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "replaceChildInternal";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildRole";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    protected String getPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode funExpr) {
        if (tree == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(2);
        }
        if (funExpr == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(3);
        }
        LighterASTNode parameterList2 = Objects.requireNonNull(LightTreeUtil.firstChildOfType(tree, funExpr, JavaStubElementTypes.PARAMETER_LIST));
        String string2 = LambdaExpressionElementType.getLambdaPresentableText(tree, parameterList2);
        if (string2 == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static String getLambdaPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList2) {
        if (tree == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(5);
        }
        if (parameterList2 == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(6);
        }
        StringBuilder buf = new StringBuilder(parameterList2.getEndOffset() - parameterList2.getStartOffset());
        LambdaExpressionElementType.formatParameterList(tree, parameterList2, buf);
        buf.append(" -> {...}");
        return buf.toString();
    }

    private static void formatParameterList(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList2, StringBuilder buf) {
        if (tree == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(7);
        }
        if (parameterList2 == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(8);
        }
        List<LighterASTNode> children2 = tree.getChildren(parameterList2);
        boolean isFirstParameter = true;
        boolean appendCloseBracket = false;
        for (LighterASTNode node : children2) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.LPARENTH) {
                buf.append('(');
                appendCloseBracket = true;
                continue;
            }
            if (tokenType != JavaStubElementTypes.PARAMETER) continue;
            if (!isFirstParameter) {
                buf.append(", ");
            }
            LambdaExpressionElementType.formatParameter(tree, node, buf);
            if (!isFirstParameter) continue;
            isFirstParameter = false;
        }
        if (appendCloseBracket) {
            buf.append(')');
        }
    }

    private static void formatParameter(@NotNull LighterAST tree, @NotNull LighterASTNode parameter2, StringBuilder buf) {
        if (tree == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(9);
        }
        if (parameter2 == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(10);
        }
        List<LighterASTNode> children2 = tree.getChildren(parameter2);
        for (LighterASTNode node : children2) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionElementType.formatType(tree, node, buf);
                buf.append(' ');
                continue;
            }
            if (tokenType != JavaTokenType.IDENTIFIER) continue;
            buf.append(RecordUtil.intern(tree.getCharTable(), node));
        }
    }

    private static void formatType(LighterAST tree, LighterASTNode typeElement, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(typeElement)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                LambdaExpressionElementType.formatCodeReference(tree, node, buf);
                continue;
            }
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionElementType.formatType(tree, node, buf);
                continue;
            }
            if (tokenType == JavaTokenType.QUEST) {
                buf.append("? ");
                continue;
            }
            if (ElementType.KEYWORD_BIT_SET.contains(tokenType)) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) continue;
                buf.append(" ");
                continue;
            }
            if (tokenType == JavaTokenType.ELLIPSIS) {
                buf.append("...");
                continue;
            }
            if (tokenType == JavaTokenType.RBRACKET) {
                buf.append("]");
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) continue;
            buf.append("[");
        }
    }

    private static void formatCodeReference(LighterAST tree, LighterASTNode codeRef, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(codeRef)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                continue;
            }
            if (tokenType != JavaElementType.REFERENCE_PARAMETER_LIST) continue;
            LambdaExpressionElementType.formatTypeParameters(tree, node, buf);
        }
    }

    private static void formatTypeParameters(LighterAST tree, LighterASTNode typeParameters2, StringBuilder buf) {
        List<LighterASTNode> children2 = LightTreeUtil.getChildrenOfType(tree, typeParameters2, JavaElementType.TYPE);
        if (children2.isEmpty()) {
            return;
        }
        buf.append('<');
        for (int i = 0; i < children2.size(); ++i) {
            LighterASTNode child = children2.get(i);
            LambdaExpressionElementType.formatType(tree, child, buf);
            if (i == children2.size() - 1) continue;
            buf.append(", ");
        }
        buf.append('>');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/java/stubs/LambdaExpressionElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaPresentableText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatParameterList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatParameter";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

