/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.compiled;

import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.util.Function;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.cls.ClsFormatException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.TypeReference;

public final class SignatureParsing {
    private static final char VARIANCE_NONE = '\u0000';
    private static final char VARIANCE_EXTENDS = '+';
    private static final char VARIANCE_SUPER = '-';
    private static final char VARIANCE_INVARIANT = '*';
    private static final String VARIANCE_EXTENDS_PREFIX = "? extends ";
    private static final String VARIANCE_SUPER_PREFIX = "? super ";

    private SignatureParsing() {
    }

    @NotNull
    static TypeParametersDeclaration parseTypeParametersDeclaration(CharacterIterator signature, Function<? super String, String> mapping2) throws ClsFormatException {
        if (signature.current() != '<') {
            TypeParametersDeclaration typeParametersDeclaration = TypeParametersDeclaration.EMPTY;
            if (typeParametersDeclaration == null) {
                SignatureParsing.$$$reportNull$$$0(0);
            }
            return typeParametersDeclaration;
        }
        ArrayList<TypeParameterDeclaration> typeParameters2 = new ArrayList<TypeParameterDeclaration>();
        signature.next();
        while (signature.current() != '>') {
            typeParameters2.add(SignatureParsing.parseTypeParameter(signature, mapping2));
        }
        signature.next();
        return new TypeParametersDeclaration(typeParameters2);
    }

    private static TypeParameterDeclaration parseTypeParameter(CharacterIterator signature, Function<? super String, String> mapping2) throws ClsFormatException {
        StringBuilder name2 = new StringBuilder();
        while (signature.current() != ':' && signature.current() != '\uffff') {
            name2.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        String parameterName = mapping2.fun(name2.toString());
        SmartList<TypeInfo> bounds2 = new SmartList<TypeInfo>();
        while (signature.current() == ':') {
            signature.next();
            String bound = SignatureParsing.parseTopLevelClassRefSignature(signature, mapping2);
            if (!bounds2.isEmpty() && bound == null) continue;
            bounds2.add(new TypeInfo(bound));
        }
        return new TypeParameterDeclaration(parameterName, bounds2.toArray(TypeInfo.EMPTY_ARRAY));
    }

    @Nullable
    public static String parseTopLevelClassRefSignature(CharacterIterator signature, Function<? super String, String> mapping2) throws ClsFormatException {
        switch (signature.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignature(signature, mapping2);
            }
            case 'T': {
                return SignatureParsing.parseTypeVariableRefSignature(signature);
            }
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharacterIterator signature) throws ClsFormatException {
        StringBuilder id = new StringBuilder();
        signature.next();
        while (signature.current() != ';' && signature.current() != '>' && signature.current() != '\uffff') {
            id.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        if (signature.current() == ';') {
            signature.next();
        }
        return id.toString();
    }

    private static String parseParameterizedClassRefSignature(CharacterIterator signature, Function<? super String, String> mapping2) throws ClsFormatException {
        StringBuilder canonicalText = new StringBuilder();
        boolean mapped = false;
        signature.next();
        while (signature.current() != ';' && signature.current() != '\uffff') {
            char c = signature.current();
            if (c == '<') {
                canonicalText = new StringBuilder(mapping2.fun(canonicalText.toString()));
                mapped = true;
                boolean firstArg = true;
                signature.next();
                do {
                    canonicalText.append(firstArg ? (char)'<' : ',').append(SignatureParsing.parseClassOrTypeVariableElement(signature, mapping2));
                    firstArg = false;
                } while (signature.current() != '>');
                canonicalText.append('>');
            } else if (c != ' ') {
                canonicalText.append(c);
            }
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        signature.next();
        String text = canonicalText.toString();
        if (!mapped) {
            text = mapping2.fun(text);
        }
        return text;
    }

    private static String parseClassOrTypeVariableElement(CharacterIterator signature, Function<? super String, String> mapping2) throws ClsFormatException {
        char variance2 = SignatureParsing.parseVariance(signature);
        if (variance2 == '*') {
            return SignatureParsing.decorateTypeText(null, variance2);
        }
        int dimensions = SignatureParsing.parseDimensions(signature);
        String text = SignatureParsing.parseTypeWithoutVariance(signature, mapping2);
        if (text == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text = text + StringUtil.repeat("[]", dimensions);
        }
        return SignatureParsing.decorateTypeText(text, variance2);
    }

    private static String decorateTypeText(String canonical, char variance2) {
        switch (variance2) {
            case '\u0000': {
                return canonical;
            }
            case '+': {
                return VARIANCE_EXTENDS_PREFIX + canonical;
            }
            case '-': {
                return VARIANCE_SUPER_PREFIX + canonical;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : "unknown variance";
        return null;
    }

    private static char parseVariance(CharacterIterator signature) {
        char variance2;
        switch (signature.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance2 = signature.current();
                signature.next();
                break;
            }
            case '.': 
            case '=': {
                signature.next();
            }
            default: {
                variance2 = '\u0000';
            }
        }
        return variance2;
    }

    private static int parseDimensions(CharacterIterator signature) {
        int dimensions = 0;
        while (signature.current() == '[') {
            ++dimensions;
            signature.next();
        }
        return dimensions;
    }

    @NotNull
    public static String parseTypeString(CharacterIterator signature, Function<? super String, String> mapping2) throws ClsFormatException {
        int dimensions = SignatureParsing.parseDimensions(signature);
        String text = SignatureParsing.parseTypeWithoutVariance(signature, mapping2);
        if (text == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text = text + StringUtil.repeat("[]", dimensions);
        }
        String string2 = text;
        if (string2 == null) {
            SignatureParsing.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Nullable
    private static String parseTypeWithoutVariance(CharacterIterator signature, Function<? super String, String> mapping2) throws ClsFormatException {
        String text = null;
        switch (signature.current()) {
            case 'L': {
                text = SignatureParsing.parseParameterizedClassRefSignature(signature, mapping2);
                break;
            }
            case 'T': {
                text = SignatureParsing.parseTypeVariableRefSignature(signature);
                break;
            }
            case 'B': {
                text = "byte";
                signature.next();
                break;
            }
            case 'C': {
                text = "char";
                signature.next();
                break;
            }
            case 'D': {
                text = "double";
                signature.next();
                break;
            }
            case 'F': {
                text = "float";
                signature.next();
                break;
            }
            case 'I': {
                text = "int";
                signature.next();
                break;
            }
            case 'J': {
                text = "long";
                signature.next();
                break;
            }
            case 'S': {
                text = "short";
                signature.next();
                break;
            }
            case 'Z': {
                text = "boolean";
                signature.next();
                break;
            }
            case 'V': {
                text = "void";
                signature.next();
            }
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ksp/com/intellij/psi/impl/compiled/SignatureParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParametersDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TypeParameterDeclaration {
        private final TypeInfo myTypeParameter;
        private final TypeInfo[] myBounds;

        private TypeParameterDeclaration(String parameter2, TypeInfo[] bounds2) {
            this.myTypeParameter = new TypeInfo(parameter2);
            this.myBounds = bounds2;
        }

        private void createTypeParameter(PsiTypeParameterListStub listStub) {
            PsiTypeParameterStubImpl stub = new PsiTypeParameterStubImpl((StubElement)listStub, this.myTypeParameter.text);
            this.myTypeParameter.getTypeAnnotations().createAnnotationStubs(stub);
            TypeInfo[] info = this.myBounds;
            if (info.length > 0 && info[0].text == null) {
                info = Arrays.copyOfRange(info, 1, info.length);
            }
            new PsiClassReferenceListStubImpl(JavaStubElementTypes.EXTENDS_BOUND_LIST, (StubElement)stub, info);
        }
    }

    static class TypeParametersDeclaration {
        static final TypeParametersDeclaration EMPTY = new TypeParametersDeclaration(Collections.emptyList());
        private final List<TypeParameterDeclaration> myDeclarations;

        private TypeParametersDeclaration(List<TypeParameterDeclaration> declarations2) {
            this.myDeclarations = declarations2;
        }

        TypeInfo getBoundType(TypeReference ref) {
            TypeParameterDeclaration typeParam;
            int typeParameterIndex = ref.getTypeParameterIndex();
            int boundIndex = ref.getTypeParameterBoundIndex();
            if (typeParameterIndex < this.myDeclarations.size() && boundIndex < (typeParam = this.myDeclarations.get(typeParameterIndex)).myBounds.length) {
                return typeParam.myBounds[boundIndex];
            }
            return null;
        }

        TypeInfo getParameterType(TypeReference ref) {
            int typeParameterIndex = ref.getTypeParameterIndex();
            if (typeParameterIndex < this.myDeclarations.size()) {
                return this.myDeclarations.get(typeParameterIndex).myTypeParameter;
            }
            return null;
        }

        void fillInTypeParameterList(StubElement<?> parent2) {
            PsiTypeParameterListStub listStub = parent2.findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST);
            if (listStub == null) {
                return;
            }
            for (TypeParameterDeclaration parameter2 : this.myDeclarations) {
                parameter2.createTypeParameter(listStub);
            }
        }
    }
}

