/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageParserDefinitions;
import ksp.com.intellij.lang.LanguageUtil;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.lang.PsiBuilderFactory;
import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.FileTypeRegistry;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.FileViewProviderFactory;
import ksp.com.intellij.psi.LanguageFileViewProviders;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiFileFactory;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.SingleRootFileViewProvider;
import ksp.com.intellij.psi.impl.GeneratedMarkerVisitor;
import ksp.com.intellij.psi.impl.source.DummyHolder;
import ksp.com.intellij.psi.impl.source.DummyHolderFactory;
import ksp.com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import ksp.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import ksp.com.intellij.psi.impl.source.tree.FileElement;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.serviceContainer.NonInjectable;
import ksp.com.intellij.testFramework.LightVirtualFile;
import ksp.com.intellij.util.LocalTimeCounter;
import ksp.com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileFactoryImpl
extends PsiFileFactory {
    private static final Logger LOG = Logger.getInstance(PsiFileFactoryImpl.class);
    private final PsiManager myManager;

    public PsiFileFactoryImpl(@NotNull Project project) {
        if (project == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(0);
        }
        this.myManager = PsiManager.getInstance(project);
    }

    @NonInjectable
    public PsiFileFactoryImpl(@NotNull PsiManager manager) {
        if (manager == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(1);
        }
        this.myManager = manager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean bl) {
        void eventSystemEnabled;
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(3);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(4);
        }
        PsiFile psiFile = this.createFileFromText(name2, fileType, text, modificationStamp, (boolean)eventSystemEnabled, true);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(6);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(7);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(8);
        }
        return this.createFileFromText(name2, language, text, true, true);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(9);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(10);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(11);
        }
        return this.createFileFromText(name2, language, text, eventSystemEnabled, markAsCopy, false);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(12);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(13);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(14);
        }
        return this.createFileFromText(name2, language, text, eventSystemEnabled, markAsCopy, noSizeLimit, null);
    }

    @Override
    public PsiFile createFileFromText(@NotNull String name2, @NotNull Language language, @NotNull CharSequence text, boolean eventSystemEnabled, boolean markAsCopy, boolean noSizeLimit, @Nullable VirtualFile original) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(15);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(16);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(17);
        }
        LightVirtualFile virtualFile2 = new LightVirtualFile(name2, language, text);
        if (original != null) {
            virtualFile2.setOriginalFile(original);
            virtualFile2.setFileType(original.getFileType());
        }
        if (noSizeLimit) {
            SingleRootFileViewProvider.doNotCheckFileSizeLimit(virtualFile2);
        }
        return this.trySetupPsiForFile(virtualFile2, language, eventSystemEnabled, markAsCopy);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text, long modificationStamp, boolean eventSystemEnabled, boolean bl) {
        void markAsCopy;
        PsiFile file2;
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(18);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(19);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(20);
        }
        LightVirtualFile virtualFile2 = new LightVirtualFile(name2, fileType, text, modificationStamp);
        Language language = LanguageUtil.getLanguageForPsi(this.myManager.getProject(), virtualFile2, fileType);
        if (language != null && (file2 = this.trySetupPsiForFile(virtualFile2, language, eventSystemEnabled, (boolean)markAsCopy)) != null) {
            PsiFile psiFile = file2;
            if (psiFile == null) {
                PsiFileFactoryImpl.$$$reportNull$$$0(21);
            }
            return psiFile;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile2, eventSystemEnabled);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(22);
        }
        return psiPlainTextFileImpl;
    }

    @Nullable
    public PsiFile trySetupPsiForFile(@NotNull LightVirtualFile virtualFile2, @NotNull Language language, boolean physical, boolean markAsCopy) {
        PsiFile psiFile;
        ParserDefinition parserDefinition;
        FileViewProviderFactory factory2;
        FileViewProvider viewProvider;
        if (virtualFile2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(23);
        }
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(24);
        }
        FileViewProvider fileViewProvider = viewProvider = (factory2 = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language)) != null ? factory2.createFileViewProvider(virtualFile2, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile2, physical);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language = viewProvider.getBaseLanguage())) != null && (psiFile = viewProvider.getPsi(language)) != null) {
            if (markAsCopy) {
                if (psiFile.getNode() == null) {
                    throw new AssertionError((Object)("No node for file " + psiFile + "; language=" + language));
                }
                PsiFileFactoryImpl.markGenerated(psiFile);
            }
            return psiFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, Language language, @NotNull Language targetLanguage, @NotNull CharSequence text, long modificationStamp, boolean physical, boolean bl) {
        void markAsCopy;
        PsiFile psiFile;
        FileViewProvider viewProvider;
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(25);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(26);
        }
        if (targetLanguage == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(27);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(28);
        }
        LightVirtualFile virtualFile2 = new LightVirtualFile(name2, fileType, text, modificationStamp);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        FileViewProviderFactory factory2 = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider fileViewProvider = viewProvider = factory2 != null ? factory2.createFileViewProvider(virtualFile2, language, this.myManager, physical) : null;
        if (viewProvider == null) {
            viewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile2, physical);
        }
        if (parserDefinition != null && (psiFile = viewProvider.getPsi(targetLanguage)) != null) {
            if (markAsCopy != false) {
                PsiFileFactoryImpl.markGenerated(psiFile);
            }
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                PsiFileFactoryImpl.$$$reportNull$$$0(29);
            }
            return psiFile2;
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, virtualFile2, physical);
        PsiPlainTextFileImpl plainTextFile = new PsiPlainTextFileImpl(singleRootFileViewProvider);
        if (markAsCopy != false) {
            CodeEditUtil.setNodeGenerated(plainTextFile.getNode(), true);
        }
        PsiPlainTextFileImpl psiPlainTextFileImpl = plainTextFile;
        if (psiPlainTextFileImpl == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(30);
        }
        return psiPlainTextFileImpl;
    }

    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull FileType fileType, @NotNull CharSequence text) {
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(31);
        }
        if (fileType == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(32);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(33);
        }
        PsiFile psiFile = this.createFileFromText(name2, fileType, text, LocalTimeCounter.currentTime(), false);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(34);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PsiFile createFileFromText(@NotNull String name2, @NotNull String text) {
        FileType type2;
        if (name2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(35);
        }
        if (text == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(36);
        }
        if ((type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(name2)).isBinary()) {
            throw new RuntimeException("Cannot create binary files from text: name " + name2 + ", file type " + type2);
        }
        PsiFile psiFile = this.createFileFromText(name2, type2, (CharSequence)text);
        if (psiFile == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(37);
        }
        return psiFile;
    }

    @Override
    public PsiFile createFileFromText(FileType fileType, String fileName2, CharSequence chars, int startOffset, int endOffset) {
        LOG.assertTrue(!fileType.isBinary());
        CharSequence text = startOffset == 0 && endOffset == chars.length() ? chars : new CharSequenceSubSequence(chars, startOffset, endOffset);
        return this.createFileFromText(fileName2, fileType, text);
    }

    @Override
    @Nullable
    public PsiFile createFileFromText(@NotNull CharSequence chars, @NotNull PsiFile original) {
        PsiFile file2;
        if (chars == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(38);
        }
        if (original == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(39);
        }
        if ((file2 = this.createFileFromText(original.getName(), original.getLanguage(), chars, false, true)) != null) {
            file2.putUserData(ORIGINAL_FILE, original);
        }
        return file2;
    }

    @Nullable
    public PsiElement createElementFromText(@Nullable String text, @NotNull Language language, @NotNull IElementType type2, @Nullable PsiElement context2) {
        if (language == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(40);
        }
        if (type2 == null) {
            PsiFileFactoryImpl.$$$reportNull$$$0(41);
        }
        if (text == null) {
            return null;
        }
        DummyHolder result2 = DummyHolderFactory.createHolder(this.myManager, language, context2);
        FileElement holder2 = result2.getTreeElement();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            throw new AssertionError((Object)("No parser definition for " + language));
        }
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(project, holder2, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project).parse(type2, builder2);
        holder2.rawAddChildren((TreeElement)node);
        PsiFileFactoryImpl.markGenerated(result2);
        return node.getPsi();
    }

    public static void markGenerated(PsiElement element2) {
        TreeElement node = (TreeElement)element2.getNode();
        assert (node != null);
        node.acceptTree(new GeneratedMarkerVisitor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 34: 
            case 37: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 34: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 25: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 19: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 28: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/PsiFileFactoryImpl";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 24: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLanguage";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/PsiFileFactoryImpl";
                break;
            }
            case 5: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 5: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 34: 
            case 37: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "trySetupPsiForFile";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createElementFromText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 34: 
            case 37: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

