/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.Couple;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiAnnotation;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiCallExpression;
import ksp.com.intellij.psi.PsiCapturedWildcardType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiEllipsisType;
import ksp.com.intellij.psi.PsiIntersectionType;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiPrimitiveType;
import ksp.com.intellij.psi.PsiReferenceParameterList;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiTypeVisitor;
import ksp.com.intellij.psi.PsiWildcardType;
import ksp.com.intellij.psi.TypeAnnotationProvider;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.util.InheritanceUtil;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiTypesUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.psi.util.TypesDistinctProver;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenericsUtil {
    private static final Logger LOG = Logger.getInstance(GenericsUtil.class);

    private GenericsUtil() {
    }

    public static PsiType getGreatestLowerBound(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (type1.equalsToText("java.lang.Object")) {
            return type2;
        }
        if (type2.equalsToText("java.lang.Object")) {
            return type1;
        }
        return PsiIntersectionType.createIntersection(type1, type2);
    }

    @Nullable
    public static PsiType getLeastUpperBound(PsiType type1, PsiType type2, PsiManager manager) {
        if (TypeConversionUtil.isPrimitiveAndNotNull(type1) || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        if (TypeConversionUtil.isNullType(type1)) {
            return type2;
        }
        if (TypeConversionUtil.isNullType(type2)) {
            return type1;
        }
        if (Comparing.equal(type1, type2)) {
            return type1;
        }
        return GenericsUtil.getLeastUpperBound(type1, type2, new LinkedHashSet<Couple<PsiType>>(), manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PsiType getLeastUpperBound(PsiType type1, PsiType type2, Set<Couple<PsiType>> compared, PsiManager manager) {
        if (type1 instanceof PsiCapturedWildcardType) {
            return GenericsUtil.getLeastUpperBound(((PsiCapturedWildcardType)type1).getUpperBound(), type2, compared, manager);
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return GenericsUtil.getLeastUpperBound(type1, ((PsiCapturedWildcardType)type2).getUpperBound(), compared, manager);
        }
        if (type1 instanceof PsiWildcardType) {
            return GenericsUtil.getLeastUpperBound(((PsiWildcardType)type1).getExtendsBound(), type2, compared, manager);
        }
        if (type2 instanceof PsiWildcardType) {
            return GenericsUtil.getLeastUpperBound(type1, ((PsiWildcardType)type2).getExtendsBound(), compared, manager);
        }
        if (type1 instanceof PsiArrayType && type2 instanceof PsiArrayType) {
            PsiType componentType1 = ((PsiArrayType)type1).getComponentType();
            PsiType componentType2 = ((PsiArrayType)type2).getComponentType();
            PsiType componentType = GenericsUtil.getLeastUpperBound(componentType1, componentType2, compared, manager);
            if ((componentType1 instanceof PsiPrimitiveType || componentType2 instanceof PsiPrimitiveType) && componentType.equalsToText("java.lang.Object")) {
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(manager.getProject());
                GlobalSearchScope resolveScope2 = GlobalSearchScope.allScope(manager.getProject());
                PsiClassType cloneable2 = factory2.createTypeByFQClassName("java.lang.Cloneable", resolveScope2);
                PsiClassType serializable = factory2.createTypeByFQClassName("java.io.Serializable", resolveScope2);
                PsiType psiType2 = PsiIntersectionType.createIntersection(componentType, cloneable2, serializable);
                if (psiType2 == null) {
                    GenericsUtil.$$$reportNull$$$0(0);
                }
                return psiType2;
            }
            PsiArrayType psiArrayType = componentType.createArrayType();
            if (psiArrayType == null) {
                GenericsUtil.$$$reportNull$$$0(1);
            }
            return psiArrayType;
        }
        if (type1 instanceof PsiIntersectionType) {
            PsiType[] conjuncts2;
            LinkedHashSet<PsiType> newConjuncts = new LinkedHashSet<PsiType>();
            for (PsiType type3 : conjuncts2 = ((PsiIntersectionType)type1).getConjuncts()) {
                newConjuncts.add(GenericsUtil.getLeastUpperBound(type3, type2, compared, manager));
            }
            PsiType psiType3 = PsiIntersectionType.createIntersection(newConjuncts.toArray(PsiType.createArray(newConjuncts.size())));
            if (psiType3 == null) {
                GenericsUtil.$$$reportNull$$$0(2);
            }
            return psiType3;
        }
        if (type2 instanceof PsiIntersectionType) {
            return GenericsUtil.getLeastUpperBound(type2, type1, compared, manager);
        }
        if (type1 instanceof PsiClassType && type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult1 = ((PsiClassType)type1).resolveGenerics();
            PsiClassType.ClassResolveResult classResolveResult2 = ((PsiClassType)type2).resolveGenerics();
            PsiClass aClass = classResolveResult1.getElement();
            PsiClass bClass = classResolveResult2.getElement();
            if (aClass == null || bClass == null) {
                PsiClassType psiClassType = PsiType.getJavaLangObject(manager, GlobalSearchScope.allScope(manager.getProject()));
                if (psiClassType == null) {
                    GenericsUtil.$$$reportNull$$$0(3);
                }
                return psiClassType;
            }
            PsiClass[] supers = GenericsUtil.getLeastUpperClasses(aClass, bClass);
            if (supers.length == 0) {
                PsiClassType psiClassType = PsiType.getJavaLangObject(manager, aClass.getResolveScope());
                if (psiClassType == null) {
                    GenericsUtil.$$$reportNull$$$0(4);
                }
                return psiClassType;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(manager.getProject());
            PsiType[] conjuncts3 = new PsiClassType[supers.length];
            HashSet<Couple<PsiClassType>> siblings2 = new HashSet<Couple<PsiClassType>>();
            try {
                for (int i = 0; i < supers.length; ++i) {
                    PsiClass aSuper = supers[i];
                    PsiSubstitutor subst1 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, aClass, classResolveResult1.getSubstitutor());
                    PsiSubstitutor subst2 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, bClass, classResolveResult2.getSubstitutor());
                    PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
                    Couple<PsiClassType> types2 = Couple.of(elementFactory.createType(aSuper, subst1), elementFactory.createType(aSuper, subst2));
                    boolean skip2 = compared.contains(types2);
                    for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable(aSuper)) {
                        PsiType mapping1 = subst1.substitute(parameter2);
                        PsiType mapping2 = subst2.substitute(parameter2);
                        if (mapping1 != null && mapping2 != null) {
                            if (skip2) {
                                substitutor2 = substitutor2.put(parameter2, PsiWildcardType.createUnbounded(manager));
                                continue;
                            }
                            compared.add(types2);
                            try {
                                PsiType argument2 = GenericsUtil.getLeastContainingTypeArgument(mapping1, mapping2, compared, manager);
                                substitutor2 = substitutor2.put(parameter2, argument2);
                                continue;
                            }
                            finally {
                                siblings2.add(types2);
                                continue;
                            }
                        }
                        substitutor2 = substitutor2.put(parameter2, null);
                    }
                    conjuncts3[i] = elementFactory.createType(aSuper, substitutor2);
                }
            }
            finally {
                compared.removeAll(siblings2);
            }
            PsiType psiType4 = PsiIntersectionType.createIntersection(conjuncts3);
            if (psiType4 == null) {
                GenericsUtil.$$$reportNull$$$0(5);
            }
            return psiType4;
        }
        if (type2 instanceof PsiArrayType) {
            return GenericsUtil.getLeastUpperBound(type2, type1, compared, manager);
        }
        if (type1 instanceof PsiArrayType) {
            PsiElementFactory factory3 = JavaPsiFacade.getElementFactory(manager.getProject());
            GlobalSearchScope all2 = GlobalSearchScope.allScope(manager.getProject());
            PsiClassType serializable = factory3.createTypeByFQClassName("java.io.Serializable", all2);
            PsiClassType cloneable3 = factory3.createTypeByFQClassName("java.lang.Cloneable", all2);
            PsiType arraySupers = PsiIntersectionType.createIntersection(serializable, cloneable3);
            return GenericsUtil.getLeastUpperBound(arraySupers, type2, compared, manager);
        }
        PsiClassType psiClassType = PsiType.getJavaLangObject(manager, GlobalSearchScope.allScope(manager.getProject()));
        if (psiClassType == null) {
            GenericsUtil.$$$reportNull$$$0(6);
        }
        return psiClassType;
    }

    private static PsiType getLeastContainingTypeArgument(PsiType type1, PsiType type2, Set<Couple<PsiType>> compared, PsiManager manager) {
        if (type1 instanceof PsiWildcardType) {
            PsiWildcardType wild1 = (PsiWildcardType)type1;
            PsiType bound1 = wild1.getBound();
            if (bound1 == null) {
                return type1;
            }
            if (type2 instanceof PsiWildcardType) {
                PsiWildcardType wild2 = (PsiWildcardType)type2;
                PsiType bound2 = wild2.getBound();
                if (bound2 == null) {
                    return type2;
                }
                if (wild1.isExtends() == wild2.isExtends()) {
                    return wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, bound2, compared, manager)) : PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, bound2));
                }
                return bound1.equals(bound2) ? bound1 : PsiWildcardType.createUnbounded(manager);
            }
            return wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, type2, compared, manager)) : (wild1.isSuper() ? PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, type2)) : wild1);
        }
        if (type2 instanceof PsiWildcardType) {
            return GenericsUtil.getLeastContainingTypeArgument(type2, type1, compared, manager);
        }
        if (type1.equals(type2)) {
            return type1;
        }
        return PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(type1, type2, compared, manager));
    }

    public static PsiClass @NotNull [] getLeastUpperClasses(PsiClass aClass, PsiClass bClass) {
        if (InheritanceUtil.isInheritorOrSelf(aClass, bClass, true)) {
            PsiClass[] psiClassArray = new PsiClass[]{bClass};
            if (psiClassArray == null) {
                GenericsUtil.$$$reportNull$$$0(7);
            }
            return psiClassArray;
        }
        LinkedHashSet<PsiClass> supers = new LinkedHashSet<PsiClass>();
        HashSet visited2 = new HashSet();
        GenericsUtil.getLeastUpperClassesInner(aClass, bClass, supers, visited2);
        PsiClass[] psiClassArray = supers.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            GenericsUtil.$$$reportNull$$$0(8);
        }
        return psiClassArray;
    }

    private static void getLeastUpperClassesInner(PsiClass aClass, PsiClass bClass, Set<PsiClass> supers, Set<? super PsiClass> visited2) {
        if (bClass.isInheritor(aClass, true)) {
            GenericsUtil.addSuper(supers, aClass);
        } else {
            PsiClass[] aSupers;
            for (PsiClass aSuper : aSupers = aClass.getSupers()) {
                if (!visited2.add(aSuper)) continue;
                GenericsUtil.getLeastUpperClassesInner(aSuper, bClass, supers, visited2);
            }
        }
    }

    private static void addSuper(Set<PsiClass> supers, PsiClass classToAdd) {
        Iterator<PsiClass> iterator2 = supers.iterator();
        while (iterator2.hasNext()) {
            PsiClass superClass = iterator2.next();
            if (InheritanceUtil.isInheritorOrSelf(superClass, classToAdd, true)) {
                return;
            }
            if (!classToAdd.isInheritor(superClass, true)) continue;
            iterator2.remove();
        }
        supers.add(classToAdd);
    }

    public static boolean isTypeArgumentsApplicable(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor2, PsiElement context2) {
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, substitutor2, context2, true);
    }

    public static boolean isTypeArgumentsApplicable(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor2, PsiElement context2, boolean allowUncheckedConversion) {
        return GenericsUtil.findTypeParameterWithBoundError(typeParams, substitutor2, context2, allowUncheckedConversion) == null;
    }

    public static Pair<PsiTypeParameter, PsiType> findTypeParameterWithBoundError(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor2, PsiElement context2, boolean allowUncheckedConversion) {
        for (PsiTypeParameter typeParameter : typeParams) {
            PsiType boundError = GenericsUtil.findTypeParameterBoundError(typeParameter, typeParameter.getExtendsListTypes(), substitutor2, context2, allowUncheckedConversion);
            if (boundError == null) continue;
            return Pair.create(typeParameter, boundError);
        }
        return null;
    }

    public static PsiType findTypeParameterBoundError(PsiTypeParameter typeParameter, PsiType[] extendsTypes, PsiSubstitutor substitutor2, PsiElement context2, boolean allowUncheckedConversion) {
        PsiType substituted = substitutor2.substitute(typeParameter);
        if (substituted == null) {
            return null;
        }
        if (context2 != null) {
            substituted = PsiUtil.captureToplevelWildcards(substituted, context2);
        }
        if (substituted instanceof PsiWildcardType && ((PsiWildcardType)substituted).isSuper()) {
            return null;
        }
        for (PsiType type2 : extendsTypes) {
            PsiType extendsType = substitutor2.substitute(type2);
            if (extendsType == null || TypeConversionUtil.isAssignable(extendsType, substituted, allowUncheckedConversion)) continue;
            return extendsType;
        }
        return null;
    }

    @Contract(value="null -> null; !null->!null")
    public static PsiType getVariableTypeByExpressionType(@Nullable PsiType type2) {
        return type2 == null ? null : GenericsUtil.getVariableTypeByExpressionType(type2, true);
    }

    @NotNull
    public static PsiType getVariableTypeByExpressionType(@NotNull PsiType type2, final boolean openCaptured) {
        PsiType transformed;
        PsiType componentType;
        PsiType deepComponentType;
        PsiClass refClass;
        if (type2 == null) {
            GenericsUtil.$$$reportNull$$$0(9);
        }
        if ((refClass = PsiUtil.resolveClassInType(type2)) instanceof PsiAnonymousClass) {
            type2 = ((PsiAnonymousClass)refClass).getBaseClassType();
        }
        if ((deepComponentType = type2.getDeepComponentType()) instanceof PsiCapturedWildcardType) {
            type2 = PsiTypesUtil.createArrayType(((PsiCapturedWildcardType)deepComponentType).getUpperBound(), type2.getArrayDimensions());
        }
        if ((componentType = (transformed = type2.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(@NotNull PsiArrayType arrayType2) {
                PsiType componentType;
                PsiType type2;
                if (arrayType2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((type2 = (componentType = arrayType2.getComponentType()).accept(this)) == componentType) {
                    return arrayType2;
                }
                if (type2 instanceof PsiWildcardType) {
                    type2 = ((PsiWildcardType)type2).getBound();
                }
                return type2 != null ? type2.createArrayType().annotate(arrayType2.getAnnotationProvider()) : arrayType2;
            }

            @Override
            public PsiType visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return type2;
            }

            @Override
            public PsiType visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                if (wildcardType == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiType bound = wildcardType.getBound();
                PsiManager manager = wildcardType.getManager();
                if (bound != null) {
                    if (wildcardType.isSuper() && bound instanceof PsiIntersectionType) {
                        return PsiWildcardType.createUnbounded(manager);
                    }
                    PsiType acceptedBound = bound.accept(this);
                    if (acceptedBound instanceof PsiWildcardType) {
                        if (((PsiWildcardType)acceptedBound).isExtends() != wildcardType.isExtends()) {
                            return PsiWildcardType.createUnbounded(manager);
                        }
                        return acceptedBound;
                    }
                    if (wildcardType.isExtends() && acceptedBound.equalsToText("java.lang.Object")) {
                        return PsiWildcardType.createUnbounded(manager);
                    }
                    if (acceptedBound.equals(bound)) {
                        return wildcardType;
                    }
                    return wildcardType.isExtends() ? PsiWildcardType.createExtends(manager, acceptedBound) : PsiWildcardType.createSuper(manager, acceptedBound);
                }
                return wildcardType;
            }

            @Override
            public PsiType visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
                if (capturedWildcardType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return openCaptured ? capturedWildcardType.getWildcard().accept(this) : capturedWildcardType;
            }

            @Override
            public PsiType visitClassType(@NotNull PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiClass aClass;
                if (classType == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((aClass = (resolveResult = classType.resolveGenerics()).getElement()) == null) {
                    return classType;
                }
                boolean toExtend = false;
                PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType toPut;
                    PsiType typeArgument = resolveResult.getSubstitutor().substitute(typeParameter);
                    if (typeArgument instanceof PsiCapturedWildcardType) {
                        toExtend = true;
                    }
                    if (typeArgument instanceof PsiWildcardType && ((PsiWildcardType)typeArgument).getBound() instanceof PsiIntersectionType) {
                        toExtend = true;
                    }
                    if (typeArgument == null) {
                        toPut = null;
                    } else {
                        PsiType accepted = typeArgument.accept(this);
                        toPut = typeArgument instanceof PsiIntersectionType && !(accepted instanceof PsiWildcardType) ? PsiWildcardType.createExtends(typeParameter.getManager(), accepted) : accepted;
                    }
                    LOG.assertTrue(toPut == null || toPut.isValid(), toPut);
                    substitutor2 = substitutor2.put(typeParameter, toPut);
                }
                PsiAnnotation[] applicableAnnotations = classType.getApplicableAnnotations();
                if (substitutor2 == PsiSubstitutor.EMPTY && !toExtend && applicableAnnotations.length == 0 && !(aClass instanceof PsiTypeParameter)) {
                    return classType;
                }
                PsiManager manager = aClass.getManager();
                PsiType result2 = JavaPsiFacade.getElementFactory(manager.getProject()).createType(aClass, substitutor2, PsiUtil.getLanguageLevel(aClass)).annotate(TypeAnnotationProvider.Static.create(applicableAnnotations));
                if (toExtend) {
                    result2 = PsiWildcardType.createExtends(manager, result2);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "capturedWildcardType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                }
                objectArray2[1] = "ksp/com/intellij/psi/GenericsUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWildcardType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCapturedWildcardType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).getDeepComponentType()) instanceof PsiWildcardType) {
            componentType = ((PsiWildcardType)componentType).getExtendsBound();
            PsiType psiType2 = PsiTypesUtil.createArrayType(componentType, transformed.getArrayDimensions());
            if (psiType2 == null) {
                GenericsUtil.$$$reportNull$$$0(10);
            }
            return psiType2;
        }
        if (transformed instanceof PsiEllipsisType) {
            PsiType psiType3 = ((PsiEllipsisType)transformed).toArrayType();
            if (psiType3 == null) {
                GenericsUtil.$$$reportNull$$$0(11);
            }
            return psiType3;
        }
        PsiType psiType4 = transformed;
        if (psiType4 == null) {
            GenericsUtil.$$$reportNull$$$0(12);
        }
        return psiType4;
    }

    public static PsiSubstitutor substituteByParameterName(PsiClass psiClass, PsiSubstitutor parentSubstitutor) {
        Map<PsiTypeParameter, PsiType> substitutionMap = parentSubstitutor.getSubstitutionMap();
        ArrayList<PsiType> result2 = new ArrayList<PsiType>(substitutionMap.size());
        for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
            String name2 = typeParameter.getName();
            PsiTypeParameter key = (PsiTypeParameter)((Object)ContainerUtil.find(substitutionMap.keySet(), psiTypeParameter -> name2.equals(psiTypeParameter.getName())));
            if (key == null) continue;
            result2.add(substitutionMap.get(key));
        }
        return PsiSubstitutor.EMPTY.putAll(psiClass, result2.toArray(PsiType.createArray(result2.size())));
    }

    public static PsiType eliminateWildcards(PsiType type2) {
        return GenericsUtil.eliminateWildcards(type2, true);
    }

    public static PsiType eliminateWildcards(PsiType type2, boolean eliminateInTypeArguments) {
        return GenericsUtil.eliminateWildcards(type2, eliminateInTypeArguments, !eliminateInTypeArguments);
    }

    public static PsiType eliminateWildcards(PsiType type2, boolean eliminateInTypeArguments, boolean eliminateCapturedWildcards) {
        if (eliminateInTypeArguments && type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = (PsiClass)resolveResult.getElement();
            if (aClass != null) {
                PsiManager manager = aClass.getManager();
                PsiTypeParameter[] typeParams = aClass.getTypeParameters();
                HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
                for (PsiTypeParameter typeParam : typeParams) {
                    PsiType substituted = resolveResult.getSubstitutor().substitute(typeParam);
                    if (substituted instanceof PsiWildcardType) {
                        if ((substituted = ((PsiWildcardType)substituted).getBound()) instanceof PsiCapturedWildcardType) {
                            substituted = ((PsiCapturedWildcardType)substituted).getWildcard().getBound();
                        }
                        if (substituted == null) {
                            substituted = TypeConversionUtil.typeParameterErasure(typeParam);
                        }
                    }
                    map.put(typeParam, substituted);
                }
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(manager.getProject());
                PsiSubstitutor substitutor2 = factory2.createSubstitutor(map);
                type2 = factory2.createType(aClass, substitutor2).annotate(classType.getAnnotationProvider());
            }
        } else {
            if (type2 instanceof PsiArrayType) {
                PsiType component = GenericsUtil.eliminateWildcards(((PsiArrayType)type2).getComponentType(), false);
                PsiArrayType newArray = type2 instanceof PsiEllipsisType ? new PsiEllipsisType(component) : new PsiArrayType(component);
                return newArray.annotate(type2.getAnnotationProvider());
            }
            if (type2 instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)type2).getBound();
                return GenericsUtil.eliminateWildcards(bound != null ? bound : ((PsiWildcardType)type2).getExtendsBound(), false);
            }
            if (type2 instanceof PsiCapturedWildcardType && eliminateCapturedWildcards) {
                return GenericsUtil.eliminateWildcards(((PsiCapturedWildcardType)type2).getUpperBound(), false);
            }
        }
        return type2;
    }

    public static boolean checkNotInBounds(PsiType type2, PsiType bound, PsiReferenceParameterList referenceParameterList) {
        PsiType capturedType = PsiUtil.captureToplevelWildcards(type2, referenceParameterList);
        return GenericsUtil.checkNotInBounds(capturedType, bound, PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiCallExpression.class) != null);
    }

    public static boolean checkNotInBounds(PsiType type2, PsiType bound, boolean uncheckedConversionByDefault) {
        if (type2 instanceof PsiClassType) {
            return GenericsUtil.checkNotAssignable(bound, type2, uncheckedConversionByDefault);
        }
        if (type2 instanceof PsiWildcardType) {
            if (((PsiWildcardType)type2).isExtends()) {
                return GenericsUtil.checkExtendsWildcardCaptureFailure((PsiWildcardType)type2, bound);
            }
            if (((PsiWildcardType)type2).isSuper()) {
                PsiType superBound = ((PsiWildcardType)type2).getSuperBound();
                if (PsiUtil.resolveClassInType(superBound) instanceof PsiTypeParameter) {
                    return TypesDistinctProver.provablyDistinct(type2, bound);
                }
                return GenericsUtil.checkNotAssignable(bound, superBound, false);
            }
        } else {
            if (type2 instanceof PsiArrayType) {
                return GenericsUtil.checkNotAssignable(bound, type2, true);
            }
            if (type2 instanceof PsiIntersectionType) {
                for (PsiType psiType2 : ((PsiIntersectionType)type2).getConjuncts()) {
                    if (GenericsUtil.checkNotInBounds(psiType2, bound, uncheckedConversionByDefault)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean checkExtendsWildcardCaptureFailure(PsiWildcardType type2, PsiType bound) {
        LOG.assertTrue(type2.isExtends());
        PsiType extendsBound = type2.getExtendsBound();
        PsiType boundBound = bound;
        if (bound instanceof PsiWildcardType) {
            if (((PsiWildcardType)bound).isBounded()) {
                boundBound = ((PsiWildcardType)bound).isSuper() ? ((PsiWildcardType)bound).getSuperBound() : ((PsiWildcardType)bound).getExtendsBound();
            } else {
                return false;
            }
        }
        PsiClass extendsBoundClass = PsiUtil.resolveClassInClassTypeOnly(extendsBound);
        PsiClass boundBoundClass = PsiUtil.resolveClassInClassTypeOnly(boundBound);
        if (boundBoundClass != null && extendsBoundClass != null && !boundBoundClass.isInterface() && !extendsBoundClass.isInterface()) {
            return !InheritanceUtil.isInheritorOrSelf(boundBoundClass, extendsBoundClass, true) && !InheritanceUtil.isInheritorOrSelf(extendsBoundClass, boundBoundClass, true);
        }
        return !TypeConversionUtil.areTypesConvertible(boundBound, extendsBound) && !TypeConversionUtil.areTypesConvertible(extendsBound, boundBound);
    }

    private static boolean checkNotAssignable(PsiType bound, PsiType type2, boolean allowUncheckedConversion) {
        if (bound instanceof PsiWildcardType) {
            if (((PsiWildcardType)bound).isBounded()) {
                PsiType boundBound = ((PsiWildcardType)bound).isExtends() ? ((PsiWildcardType)bound).getExtendsBound() : ((PsiWildcardType)bound).getSuperBound();
                return !TypeConversionUtil.isAssignable(boundBound, type2, allowUncheckedConversion);
            }
            return true;
        }
        return !TypeConversionUtil.isAssignable(bound, type2, allowUncheckedConversion);
    }

    @NotNull
    public static PsiClassType getExpectedGenericType(PsiElement context2, PsiClass aClass, PsiClassType expectedType) {
        List<PsiType> arguments2 = GenericsUtil.getExpectedTypeArguments(context2, aClass, Arrays.asList(aClass.getTypeParameters()), expectedType);
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(context2.getProject()).createType(aClass, arguments2.toArray(PsiType.EMPTY_ARRAY));
        if (psiClassType == null) {
            GenericsUtil.$$$reportNull$$$0(13);
        }
        return psiClassType;
    }

    @NotNull
    public static List<PsiType> getExpectedTypeArguments(PsiElement context2, PsiClass aClass, @NotNull Iterable<? extends PsiTypeParameter> typeParams, @NotNull PsiClassType expectedType) {
        PsiClassType.ClassResolveResult resolve2;
        PsiClass expectedClass;
        if (typeParams == null) {
            GenericsUtil.$$$reportNull$$$0(14);
        }
        if (expectedType == null) {
            GenericsUtil.$$$reportNull$$$0(15);
        }
        if (!InheritanceUtil.isInheritorOrSelf(aClass, expectedClass = (resolve2 = expectedType.resolveGenerics()).getElement(), true)) {
            List<PsiType> list2 = ContainerUtil.map(typeParams, p -> null);
            if (list2 == null) {
                GenericsUtil.$$$reportNull$$$0(16);
            }
            return list2;
        }
        PsiSubstitutor substitutor2 = TypeConversionUtil.getClassSubstitutor(expectedClass, aClass, PsiSubstitutor.EMPTY);
        assert (substitutor2 != null);
        List<PsiType> list3 = ContainerUtil.map(typeParams, p -> GenericsUtil.getExpectedTypeArg(context2, resolve2, substitutor2, p));
        if (list3 == null) {
            GenericsUtil.$$$reportNull$$$0(17);
        }
        return list3;
    }

    @Nullable
    private static PsiType getExpectedTypeArg(PsiElement context2, PsiClassType.ClassResolveResult expectedType, PsiSubstitutor superClassSubstitutor, PsiTypeParameter typeParam) {
        PsiClass expectedClass = expectedType.getElement();
        assert (expectedClass != null);
        for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable(expectedClass)) {
            PsiType paramSubstitution = superClassSubstitutor.substitute(parameter2);
            PsiClass inheritorCandidateParameter = PsiUtil.resolveClassInType(paramSubstitution);
            if (inheritorCandidateParameter instanceof PsiTypeParameter && ((PsiTypeParameter)inheritorCandidateParameter).getOwner() == typeParam.getOwner() && inheritorCandidateParameter != typeParam) continue;
            PsiType argSubstitution = expectedType.getSubstitutor().substitute(parameter2);
            PsiType substitution = JavaPsiFacade.getInstance(context2.getProject()).getResolveHelper().getSubstitutionForTypeParameter(typeParam, paramSubstitution, argSubstitution, true, PsiUtil.getLanguageLevel(context2));
            if (substitution == null || substitution == PsiType.NULL) continue;
            return substitution;
        }
        return null;
    }

    public static boolean isGenericReference(PsiJavaCodeReferenceElement referenceElement, PsiJavaCodeReferenceElement qualifierElement) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList qualifierParameterList = qualifierElement.getParameterList();
        if (qualifierParameterList != null && (typeParameterElements = qualifierParameterList.getTypeParameterElements()).length > 0) {
            return true;
        }
        PsiReferenceParameterList parameterList2 = referenceElement.getParameterList();
        if (parameterList2 != null) {
            PsiTypeElement[] typeParameterElements2 = parameterList2.getTypeParameterElements();
            return typeParameterElements2.length > 0;
        }
        return false;
    }

    @NotNull
    public static PsiType eliminateExtendsFinalWildcard(@NotNull PsiType type2) {
        if (type2 == null) {
            GenericsUtil.$$$reportNull$$$0(18);
        }
        if (!(type2 instanceof PsiClassType)) {
            PsiType psiType2 = type2;
            if (psiType2 == null) {
                GenericsUtil.$$$reportNull$$$0(19);
            }
            return psiType2;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiType[] parameters2 = classType.getParameters();
        boolean changed = false;
        for (int i = 0; i < parameters2.length; ++i) {
            PsiClass boundClass;
            PsiWildcardType wildcardType;
            PsiClassType bound;
            PsiType param = parameters2[i];
            if (!(param instanceof PsiWildcardType) || (bound = ObjectUtils.tryCast((wildcardType = (PsiWildcardType)param).getBound(), PsiClassType.class)) == null || !wildcardType.isExtends() || (boundClass = PsiUtil.resolveClassInClassTypeOnly(bound)) == null || !boundClass.hasModifierProperty("final")) continue;
            parameters2[i] = bound;
            changed = true;
        }
        if (!changed) {
            PsiType psiType3 = type2;
            if (psiType3 == null) {
                GenericsUtil.$$$reportNull$$$0(20);
            }
            return psiType3;
        }
        PsiClass target = classType.resolve();
        if (target == null) {
            PsiClassType psiClassType = classType;
            if (psiClassType == null) {
                GenericsUtil.$$$reportNull$$$0(21);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory(target.getProject()).createType(target, parameters2).annotate(classType.getAnnotationProvider());
        if (psiClassType == null) {
            GenericsUtil.$$$reportNull$$$0(22);
        }
        return psiClassType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 18: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/GenericsUtil";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParams";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperBound";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperClasses";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/GenericsUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableTypeByExpressionType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedGenericType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeArguments";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "eliminateExtendsFinalWildcard";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeByExpressionType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeArguments";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "eliminateExtendsFinalWildcard";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

