/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.patterns;

import java.util.ArrayList;
import java.util.Collection;
import ksp.com.intellij.patterns.ElementPattern;
import ksp.com.intellij.patterns.InitialPatternCondition;
import ksp.com.intellij.patterns.ObjectPattern;
import ksp.com.intellij.patterns.PatternCondition;
import ksp.com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionPattern<T>
extends ObjectPattern<Collection<T>, CollectionPattern<T>> {
    private static final InitialPatternCondition CONDITION = new InitialPatternCondition<Collection>(Collection.class){

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context2) {
            return o instanceof Collection;
        }
    };

    protected CollectionPattern() {
        super(CONDITION);
    }

    public CollectionPattern<T> all(final ElementPattern<? extends T> pattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("all"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context2) {
                if (collection == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (Object t : collection) {
                    if (pattern.accepts(t, context2)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "ksp/com/intellij/patterns/CollectionPattern$2", "accepts"));
            }
        });
    }

    public CollectionPattern<T> atLeastOne(final ElementPattern<? extends T> pattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("atLeastOne"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context2) {
                if (collection == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (Object t : collection) {
                    if (!pattern.accepts(t, context2)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "ksp/com/intellij/patterns/CollectionPattern$3", "accepts"));
            }
        });
    }

    public CollectionPattern<T> filter(final ElementPattern<? extends T> elementPattern, final ElementPattern<Collection<T>> continuationPattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("filter"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context2) {
                if (collection == null) {
                    4.$$$reportNull$$$0(0);
                }
                ArrayList filtered = new ArrayList();
                for (Object t : collection) {
                    if (!elementPattern.accepts(t, context2)) continue;
                    filtered.add(t);
                }
                return continuationPattern.accepts(filtered, context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "ksp/com/intellij/patterns/CollectionPattern$4", "accepts"));
            }
        });
    }

    public CollectionPattern<T> first(final ElementPattern<? extends T> elementPattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("first"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context2) {
                if (collection == null) {
                    5.$$$reportNull$$$0(0);
                }
                return !collection.isEmpty() && elementPattern.accepts(collection.iterator().next(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "ksp/com/intellij/patterns/CollectionPattern$5", "accepts"));
            }
        });
    }

    public CollectionPattern<T> empty() {
        return this.size(0);
    }

    public CollectionPattern<T> notEmpty() {
        return this.atLeast(1);
    }

    public CollectionPattern<T> atLeast(final int size) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("atLeast"){

            @Override
            public boolean accepts(@NotNull Collection<T> ts, ProcessingContext context2) {
                if (ts == null) {
                    6.$$$reportNull$$$0(0);
                }
                return ts.size() >= size;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ts", "ksp/com/intellij/patterns/CollectionPattern$6", "accepts"));
            }
        });
    }

    public CollectionPattern<T> size(final int size) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("size"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context2) {
                if (collection == null) {
                    7.$$$reportNull$$$0(0);
                }
                return size == collection.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "ksp/com/intellij/patterns/CollectionPattern$7", "accepts"));
            }
        });
    }

    public CollectionPattern<T> last(final ElementPattern elementPattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("last"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context2) {
                if (collection == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (collection.isEmpty()) {
                    return false;
                }
                Object last = null;
                for (Object t : collection) {
                    last = t;
                }
                return elementPattern.accepts(last, context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "ksp/com/intellij/patterns/CollectionPattern$8", "accepts"));
            }
        });
    }
}

