/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util.text;

import java.util.Comparator;
import ksp.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class NaturalComparator
implements Comparator<String> {
    public static final Comparator<String> INSTANCE = new NaturalComparator();

    private NaturalComparator() {
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return NaturalComparator.naturalCompare(s1, s2, s1.length(), s2.length(), true);
    }

    @Contract(pure=true)
    private static int naturalCompare(@NotNull String s1, @NotNull String s2, int length1, int length2, boolean ignoreCase) {
        int j;
        if (s1 == null) {
            NaturalComparator.$$$reportNull$$$0(0);
        }
        if (s2 == null) {
            NaturalComparator.$$$reportNull$$$0(1);
        }
        int i = 0;
        for (j = 0; i < length1 && j < length2; ++i, ++j) {
            char ch1 = s1.charAt(i);
            char ch2 = s2.charAt(j);
            if ((StringUtil.isDecimalDigit(ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit(ch2) || ch2 == ' ')) {
                int end2;
                int start1 = NaturalComparator.skipChar(s1, NaturalComparator.skipChar(s1, i, length1, ' '), length1, '0');
                int start2 = NaturalComparator.skipChar(s2, NaturalComparator.skipChar(s2, j, length2, ' '), length2, '0');
                int end1 = NaturalComparator.skipDigits(s1, start1, length1);
                int lengthDiff = end1 - start1 - ((end2 = NaturalComparator.skipDigits(s2, start2, length2)) - start2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                int numberDiff = NaturalComparator.compareCharRange(s1, s2, start1, start2, end1);
                if (numberDiff != 0) {
                    return numberDiff;
                }
                int fullLengthDiff = end1 - i - (end2 - j);
                if (fullLengthDiff != 0) {
                    return fullLengthDiff;
                }
                int leadingDiff = NaturalComparator.compareCharRange(s1, s2, i, j, start1);
                if (leadingDiff != 0) {
                    return leadingDiff;
                }
                i = end1 - 1;
                j = end2 - 1;
                continue;
            }
            int diff = NaturalComparator.compareChars(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        if (i < length1) {
            return 1;
        }
        if (j < length2) {
            return -1;
        }
        if (length1 != length2) {
            return length1 - length2;
        }
        return ignoreCase ? NaturalComparator.naturalCompare(s1, s2, length1, length2, false) : 0;
    }

    private static int compareCharRange(@NotNull String s1, @NotNull String s2, int offset1, int offset2, int end1) {
        if (s1 == null) {
            NaturalComparator.$$$reportNull$$$0(2);
        }
        if (s2 == null) {
            NaturalComparator.$$$reportNull$$$0(3);
        }
        int i = offset1;
        int j = offset2;
        while (i < end1) {
            int diff = s1.charAt(i) - s2.charAt(j);
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    private static int compareChars(char ch1, char ch2, boolean ignoreCase) {
        if (ch1 == ' ' && ch2 > ' ' && ch2 < '0') {
            return 1;
        }
        if (ch2 == ' ' && ch1 > ' ' && ch1 < '0') {
            return -1;
        }
        return StringUtil.compare(ch1, ch2, ignoreCase);
    }

    private static int skipDigits(String s, int start, int end) {
        while (start < end && StringUtil.isDecimalDigit(s.charAt(start))) {
            ++start;
        }
        return start;
    }

    private static int skipChar(String s, int start, int end, char c) {
        while (start < end && s.charAt(start) == c) {
            ++start;
        }
        return start;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/openapi/util/text/NaturalComparator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "naturalCompare";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareCharRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

