/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.application;

import java.awt.EventQueue;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;
import ksp.com.intellij.diagnostic.LoadingState;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.AccessToken;
import ksp.com.intellij.openapi.application.AppUIExecutor;
import ksp.com.intellij.openapi.application.Application;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.application.TransactionGuard;
import ksp.com.intellij.openapi.application.TransactionId;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProgressIndicatorProvider;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.openapi.util.registry.Registry;
import ksp.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance(TransactionGuardImpl.class);
    private final Map<ModalityState, Boolean> myWriteSafeModalities = CollectionFactory.createConcurrentWeakMap();
    private boolean myWritingAllowed;
    private boolean myErrorReported;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.NON_MODAL, true);
        this.myWritingAllowed = SwingUtilities.isEventDispatchThread();
    }

    @Override
    public void submitTransaction(@NotNull Disposable parentDisposable, @Nullable TransactionId expectedContext, @NotNull Runnable transaction) {
        if (parentDisposable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(0);
        }
        if (transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(1);
        }
        ModalityState modality = expectedContext == null ? ModalityState.NON_MODAL : ((TransactionIdImpl)expectedContext).myModality;
        Application app = ApplicationManager.getApplication();
        if (app.isWriteThread() && this.myWritingAllowed && !ModalityState.current().dominates(modality)) {
            if (!Disposer.isDisposed(parentDisposable)) {
                transaction.run();
            }
        } else {
            ((AppUIExecutor)AppUIExecutor.onWriteThread(modality).later().expireWith(parentDisposable)).execute(transaction);
        }
    }

    @Override
    public void submitTransactionAndWait(@NotNull Runnable runnable) throws ProcessCanceledException {
        Application app;
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(2);
        }
        if ((app = ApplicationManager.getApplication()).isWriteThread()) {
            if (!this.myWritingAllowed) {
                @NonNls String message2 = "Cannot run synchronous submitTransactionAndWait from invokeLater. Please use asynchronous submit*Transaction. See TransactionGuard FAQ for details.\nTransaction: " + runnable;
                if (!this.isWriteSafeModality(ModalityState.current())) {
                    message2 = message2 + "\nUnsafe modality: " + ModalityState.current();
                }
                LOG.error(message2);
            }
            runnable.run();
            return;
        }
        if (app.isReadAccessAllowed()) {
            throw new IllegalStateException("submitTransactionAndWait should not be invoked from a read action");
        }
        ModalityState state = ModalityState.defaultModalityState();
        if (!this.isWriteSafeModality(state)) {
            LOG.error("Cannot run synchronous submitTransactionAndWait from a background thread created in a write-unsafe context");
        }
        app.invokeAndWait(runnable, state);
    }

    public void performUserActivity(Runnable activity) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        try (AccessToken ignore = this.startActivity(true);){
            activity.run();
        }
    }

    @NotNull
    public AccessToken startActivity(boolean userActivity) {
        boolean allowWriting;
        this.myErrorReported = false;
        boolean bl = allowWriting = userActivity && this.isWriteSafeModality(ModalityState.current());
        if (this.myWritingAllowed == allowWriting) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                TransactionGuardImpl.$$$reportNull$$$0(3);
            }
            return accessToken;
        }
        if (allowWriting) {
            ApplicationManager.getApplication().assertIsWriteThread();
        } else if (!EventQueue.isDispatchThread()) {
            LOG.error("must be swing thread");
        }
        final boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = allowWriting;
        return new AccessToken(){

            @Override
            public void finish() {
                TransactionGuardImpl.this.myWritingAllowed = prev;
            }
        };
    }

    @Override
    public boolean isWritingAllowed() {
        ApplicationManager.getApplication().assertIsWriteThread();
        return this.myWritingAllowed;
    }

    @Override
    public boolean isWriteSafeModality(ModalityState state) {
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state));
    }

    public void assertWriteActionAllowed() {
        ApplicationManager.getApplication().assertIsWriteThread();
        if (!this.myWritingAllowed && TransactionGuardImpl.areAssertionsEnabled() && !this.myErrorReported) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(ModalityState.current()));
            this.myErrorReported = true;
        }
    }

    @NonNls
    private static String reportWriteUnsafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(4);
        }
        return "Write-unsafe context! Model changes are allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + modality;
    }

    @Override
    public void assertWriteSafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(5);
        }
        if (!this.isWriteSafeModality(modality) && TransactionGuardImpl.areAssertionsEnabled()) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(modality));
        }
    }

    private static boolean areAssertionsEnabled() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is("ide.require.transaction.for.model.changes", false);
    }

    @Override
    public void submitTransactionLater(@NotNull Disposable parentDisposable, @NotNull Runnable transaction) {
        if (parentDisposable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(6);
        }
        if (transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(7);
        }
        TransactionIdImpl ctx = this.getContextTransaction();
        ApplicationManager.getApplication().invokeLaterOnWriteThread(transaction, ctx == null ? ModalityState.NON_MODAL : ctx.myModality);
    }

    @Override
    public TransactionIdImpl getContextTransaction() {
        if (ApplicationManager.getApplication().isWriteThread() ? !this.myWritingAllowed : ProgressIndicatorProvider.getGlobalProgressIndicator() == null) {
            return null;
        }
        ModalityState state = ModalityState.defaultModalityState();
        return this.isWriteSafeModality(state) ? new TransactionIdImpl(state) : null;
    }

    public void enteredModality(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(8);
        }
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    @NotNull
    public Runnable wrapLaterInvocation(final @NotNull Runnable runnable, final @NotNull ModalityState modalityState) {
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(9);
        }
        if (modalityState == null) {
            TransactionGuardImpl.$$$reportNull$$$0(10);
        }
        return new Runnable(){

            @Override
            public void run() {
                if (TransactionGuardImpl.this.isWriteSafeModality(modalityState)) {
                    ApplicationManager.getApplication().assertIsWriteThread();
                    TransactionGuardImpl.this.runWithWritingAllowed(runnable);
                } else {
                    runnable.run();
                }
            }

            public String toString() {
                return runnable.toString();
            }
        };
    }

    private void runWithWritingAllowed(@NotNull Runnable runnable) {
        if (runnable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(11);
        }
        boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = true;
        try {
            runnable.run();
        }
        finally {
            this.myWritingAllowed = prev;
        }
    }

    public String toString() {
        return "TransactionGuardImpl{myWritingAllowed=" + this.myWritingAllowed + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 2: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/application/TransactionGuardImpl";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/application/TransactionGuardImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "submitTransaction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "submitTransactionAndWait";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportWriteUnsafeContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertWriteSafeContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "submitTransactionLater";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enteredModality";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapLaterInvocation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runWithWritingAllowed";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TransactionIdImpl
    implements TransactionId {
        final ModalityState myModality;

        private TransactionIdImpl(ModalityState modality) {
            this.myModality = modality;
        }

        public String toString() {
            return this.myModality.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionIdImpl)) {
                return false;
            }
            TransactionIdImpl id = (TransactionIdImpl)o;
            return Objects.equals(this.myModality, id.myModality);
        }

        public int hashCode() {
            return Objects.hash(this.myModality);
        }
    }
}

