/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.java.parser;

import java.util.List;
import java.util.function.Predicate;
import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.lang.LighterLazyParseableNode;
import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.lang.PsiBuilderFactory;
import ksp.com.intellij.lang.PsiBuilderUtil;
import ksp.com.intellij.lang.WhitespacesAndCommentsBinder;
import ksp.com.intellij.lang.impl.PsiBuilderAdapter;
import ksp.com.intellij.lang.impl.TokenSequence;
import ksp.com.intellij.lang.java.JavaLanguage;
import ksp.com.intellij.lang.java.JavaParserDefinition;
import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.lexer.TokenList;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.NlsContexts;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaDocElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.indexing.IndexingDataKeys;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class JavaParserUtil {
    public static final TokenSet WS_COMMENTS = TokenSet.orSet(ElementType.JAVA_COMMENT_BIT_SET, TokenSet.WHITE_SPACE);
    private static final Key<LanguageLevel> LANG_LEVEL_KEY = Key.create("JavaParserUtil.LanguageLevel");
    private static final Key<Boolean> DEEP_PARSE_BLOCKS_IN_STATEMENTS = Key.create("JavaParserUtil.ParserExtender");
    private static final TokenSet PRECEDING_COMMENT_SET = TokenSet.orSet(TokenSet.create(JavaElementType.MODULE), ElementType.FULL_MEMBER_BIT_SET);
    private static final TokenSet TRAILING_COMMENT_SET = TokenSet.orSet(TokenSet.create(JavaElementType.PACKAGE_STATEMENT), ElementType.IMPORT_STATEMENT_BASE_BIT_SET, ElementType.FULL_MEMBER_BIT_SET, ElementType.JAVA_STATEMENT_BIT_SET);
    public static final WhitespacesAndCommentsBinder PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(false);
    public static final WhitespacesAndCommentsBinder SPECIAL_PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(true);
    public static final WhitespacesAndCommentsBinder TRAILING_COMMENT_BINDER = new TrailingWhitespacesAndCommentsBinder();

    @NotNull
    public static TokenList obtainTokens(@NotNull PsiFile file2) {
        if (file2 == null) {
            JavaParserUtil.$$$reportNull$$$0(0);
        }
        TokenList tokenList = (TokenList)CachedValuesManager.getCachedValue(file2, () -> CachedValueProvider.Result.create(TokenSequence.performLexing(file2.getViewProvider().getContents(), JavaParserDefinition.createLexer(PsiUtil.getLanguageLevel(file2))), file2));
        if (tokenList == null) {
            JavaParserUtil.$$$reportNull$$$0(1);
        }
        return tokenList;
    }

    private JavaParserUtil() {
    }

    public static void setLanguageLevel(PsiBuilder builder2, LanguageLevel level) {
        builder2.putUserData(LANG_LEVEL_KEY, level);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(PsiBuilder builder2) {
        LanguageLevel level = builder2.getUserData(LANG_LEVEL_KEY);
        assert (level != null) : builder2;
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            JavaParserUtil.$$$reportNull$$$0(2);
        }
        return languageLevel;
    }

    public static void setParseStatementCodeBlocksDeep(PsiBuilder builder2, boolean deep) {
        builder2.putUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS, deep);
    }

    public static boolean isParseStatementCodeBlocksDeep(PsiBuilder builder2) {
        return Boolean.TRUE.equals(builder2.getUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS));
    }

    @NotNull
    public static PsiBuilder createBuilder(ASTNode chameleon) {
        CharSequence text;
        PsiElement psi2 = chameleon.getPsi();
        assert (psi2 != null) : chameleon;
        Project project = psi2.getProject();
        CharSequence indexedText = psi2.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (TreeUtil.isCollapsedChameleon(chameleon)) {
            text = chameleon.getChars();
        } else {
            text = indexedText;
            if (text == null) {
                text = chameleon.getChars();
            }
        }
        LanguageLevel level = PsiUtil.getLanguageLevel(psi2);
        Lexer lexer = psi2 instanceof PsiFile && indexedText != null ? JavaParserUtil.obtainTokens((PsiFile)psi2).asLexer() : JavaParserDefinition.createLexer(level);
        Language language = psi2.getLanguage();
        if (!language.isKindOf(JavaLanguage.INSTANCE)) {
            language = JavaLanguage.INSTANCE;
        }
        PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, lexer, language, text);
        JavaParserUtil.setLanguageLevel(builder2, level);
        PsiBuilder psiBuilder = builder2;
        if (psiBuilder == null) {
            JavaParserUtil.$$$reportNull$$$0(3);
        }
        return psiBuilder;
    }

    @NotNull
    public static PsiBuilder createBuilder(LighterLazyParseableNode chameleon) {
        PsiFile psi2 = chameleon.getContainingFile();
        assert (psi2 != null) : chameleon;
        Project project = psi2.getProject();
        PsiBuilderFactory factory2 = PsiBuilderFactory.getInstance();
        LanguageLevel level = PsiUtil.getLanguageLevel(psi2);
        Lexer lexer = JavaParserDefinition.createLexer(level);
        PsiBuilder builder2 = factory2.createBuilder(project, chameleon, lexer, chameleon.getTokenType().getLanguage(), chameleon.getText());
        JavaParserUtil.setLanguageLevel(builder2, level);
        PsiBuilder psiBuilder = builder2;
        if (psiBuilder == null) {
            JavaParserUtil.$$$reportNull$$$0(4);
        }
        return psiBuilder;
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper) {
        return JavaParserUtil.parseFragment(chameleon, wrapper, true, LanguageLevel.HIGHEST);
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper, boolean eatAll, LanguageLevel level) {
        PsiElement psi2;
        PsiElement psiElement = psi2 = chameleon.getTreeParent() != null ? chameleon.getTreeParent().getPsi() : chameleon.getPsi();
        assert (psi2 != null) : chameleon;
        Project project = psi2.getProject();
        PsiBuilderFactory factory2 = PsiBuilderFactory.getInstance();
        Lexer lexer = chameleon.getElementType() == JavaDocElementType.DOC_COMMENT ? JavaParserDefinition.createDocLexer(level) : JavaParserDefinition.createLexer(level);
        PsiBuilder builder2 = factory2.createBuilder(project, chameleon, lexer, chameleon.getElementType().getLanguage(), chameleon.getChars());
        JavaParserUtil.setLanguageLevel(builder2, level);
        PsiBuilder.Marker root = builder2.mark();
        wrapper.parse(builder2);
        if (!builder2.eof()) {
            if (!eatAll) {
                throw new AssertionError((Object)("Unexpected token: '" + builder2.getTokenText() + "'"));
            }
            PsiBuilder.Marker extras = builder2.mark();
            while (!builder2.eof()) {
                builder2.advanceLexer();
            }
            extras.error(JavaPsiBundle.message("unexpected.tokens", new Object[0]));
        }
        root.done(chameleon.getElementType());
        return builder2.getTreeBuilt().getFirstChildNode();
    }

    public static void done(PsiBuilder.Marker marker, IElementType type2) {
        marker.done(type2);
        WhitespacesAndCommentsBinder left = PRECEDING_COMMENT_SET.contains(type2) ? PRECEDING_COMMENT_BINDER : null;
        WhitespacesAndCommentsBinder right = TRAILING_COMMENT_SET.contains(type2) ? TRAILING_COMMENT_BINDER : null;
        marker.setCustomEdgeTokenBinders(left, right);
    }

    @Nullable
    public static IElementType exprType(@Nullable PsiBuilder.Marker marker) {
        return marker != null ? ((LighterASTNode)((Object)marker)).getTokenType() : null;
    }

    public static void error(PsiBuilder builder2, @NotNull @NlsContexts.ParsingError String message2) {
        if (message2 == null) {
            JavaParserUtil.$$$reportNull$$$0(5);
        }
        builder2.mark().error(message2);
    }

    public static void error(PsiBuilder builder2, @NotNull @NlsContexts.ParsingError String message2, @Nullable PsiBuilder.Marker before) {
        if (message2 == null) {
            JavaParserUtil.$$$reportNull$$$0(6);
        }
        if (before == null) {
            JavaParserUtil.error(builder2, message2);
        } else {
            before.precede().errorBefore(message2, before);
        }
    }

    public static boolean expectOrError(PsiBuilder builder2, TokenSet expected, @PropertyKey(resourceBundle="messages.JavaPsiBundle") @PropertyKey(resourceBundle="messages.JavaPsiBundle") String key) {
        if (!PsiBuilderUtil.expect(builder2, expected)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean expectOrError(PsiBuilder builder2, IElementType expected, @PropertyKey(resourceBundle="messages.JavaPsiBundle") @PropertyKey(resourceBundle="messages.JavaPsiBundle") String key) {
        if (!PsiBuilderUtil.expect(builder2, expected)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static void emptyElement(PsiBuilder builder2, IElementType type2) {
        builder2.mark().done(type2);
    }

    public static void emptyElement(PsiBuilder.Marker before, IElementType type2) {
        before.precede().doneBefore(type2, before);
    }

    public static void semicolon(PsiBuilder builder2) {
        JavaParserUtil.expectOrError(builder2, JavaTokenType.SEMICOLON, "expected.semicolon");
    }

    public static PsiBuilder braceMatchingBuilder(PsiBuilder builder2) {
        PsiBuilder.Marker pos = builder2.mark();
        int braceCount = 1;
        while (!builder2.eof()) {
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == JavaTokenType.LBRACE) {
                ++braceCount;
            } else if (tokenType == JavaTokenType.RBRACE) {
                --braceCount;
            }
            if (braceCount == 0) break;
            builder2.advanceLexer();
        }
        int stopAt = builder2.getCurrentOffset();
        pos.rollbackTo();
        return JavaParserUtil.stoppingBuilder(builder2, stopAt);
    }

    public static PsiBuilder stoppingBuilder(PsiBuilder builder2, final int stopAt) {
        return new PsiBuilderAdapter(builder2){

            @Override
            public IElementType getTokenType() {
                return this.getCurrentOffset() < stopAt ? super.getTokenType() : null;
            }

            @Override
            public boolean eof() {
                return this.getCurrentOffset() >= stopAt || super.eof();
            }
        };
    }

    public static PsiBuilder stoppingBuilder(final PsiBuilder builder2, final Predicate<? super Pair<IElementType, String>> condition) {
        return new PsiBuilderAdapter(builder2){

            @Override
            public IElementType getTokenType() {
                Pair<IElementType, String> input = Pair.create(builder2.getTokenType(), builder2.getTokenText());
                return condition.test(input) ? null : super.getTokenType();
            }

            @Override
            public boolean eof() {
                Pair<IElementType, String> input = Pair.create(builder2.getTokenType(), builder2.getTokenText());
                return condition.test(input) || super.eof();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/java/parser/JavaParserUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/java/parser/JavaParserUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainTokens";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrailingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private TrailingWhitespacesAndCommentsBinder() {
        }

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.size() == 0) {
                return 0;
            }
            int result2 = 0;
            for (int idx = 0; idx < tokens.size(); ++idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (!StringUtil.containsLineBreak(getter2.get(idx))) continue;
                    break;
                }
                if (!ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                result2 = idx + 1;
            }
            return result2;
        }
    }

    private static class PrecedingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAfterEmptyImport;

        PrecedingWhitespacesAndCommentsBinder(boolean afterImport) {
            this.myAfterEmptyImport = afterImport;
        }

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.size() == 0) {
                return 0;
            }
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                if (tokens.get(idx) != JavaDocElementType.DOC_COMMENT) continue;
                return idx;
            }
            int result2 = tokens.size();
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (StringUtil.getLineBreakCount(getter2.get(idx)) <= 1) continue;
                    break;
                }
                if (!ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                if (!atStreamEdge && (idx != 0 || !this.myAfterEmptyImport) && (idx <= 0 || !TokenSet.WHITE_SPACE.contains(tokens.get(idx - 1)) || !StringUtil.containsLineBreak(getter2.get(idx - 1)))) continue;
                result2 = idx;
            }
            return result2;
        }
    }

    @FunctionalInterface
    public static interface ParserWrapper {
        public void parse(PsiBuilder var1);
    }
}

