/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.core;

import ksp.com.intellij.core.CoreApplicationEnvironment;
import ksp.com.intellij.core.CoreEncodingProjectManager;
import ksp.com.intellij.core.CoreInjectedLanguageManager;
import ksp.com.intellij.core.CoreProjectScopeBuilder;
import ksp.com.intellij.core.CorePsiDocumentManager;
import ksp.com.intellij.core.MockDocumentCommitProcessor;
import ksp.com.intellij.lang.injection.InjectedLanguageManager;
import ksp.com.intellij.mock.MockDumbService;
import ksp.com.intellij.mock.MockDumbUtil;
import ksp.com.intellij.mock.MockFileIndexFacade;
import ksp.com.intellij.mock.MockProject;
import ksp.com.intellij.mock.MockResolveScopeManager;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.project.DumbService;
import ksp.com.intellij.openapi.project.DumbUtil;
import ksp.com.intellij.openapi.roots.FileIndexFacade;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.psi.PsiDocumentManager;
import ksp.com.intellij.psi.PsiFileFactory;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.SmartPointerManager;
import ksp.com.intellij.psi.impl.DocumentCommitProcessor;
import ksp.com.intellij.psi.impl.PsiCachedValuesFactory;
import ksp.com.intellij.psi.impl.PsiFileFactoryImpl;
import ksp.com.intellij.psi.impl.PsiManagerImpl;
import ksp.com.intellij.psi.impl.PsiModificationTrackerImpl;
import ksp.com.intellij.psi.impl.ResolveScopeManager;
import ksp.com.intellij.psi.impl.file.PsiDirectoryFactory;
import ksp.com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import ksp.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import ksp.com.intellij.psi.impl.source.resolve.ResolveCache;
import ksp.com.intellij.psi.search.ProjectScopeBuilder;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.PsiModificationTracker;
import ksp.com.intellij.util.CachedValuesManagerImpl;
import ksp.com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

public class CoreProjectEnvironment {
    private final Disposable myParentDisposable;
    private final CoreApplicationEnvironment myEnvironment;
    protected final FileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;
    protected final MockProject myProject;
    protected final MessageBus myMessageBus;

    public CoreProjectEnvironment(@NotNull Disposable parentDisposable, @NotNull CoreApplicationEnvironment applicationEnvironment) {
        if (parentDisposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(0);
        }
        if (applicationEnvironment == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(1);
        }
        this.myParentDisposable = parentDisposable;
        this.myEnvironment = applicationEnvironment;
        this.myProject = this.createProject(this.myEnvironment.getApplication().getPicoContainer(), this.myParentDisposable);
        this.preregisterServices();
        this.myFileIndexFacade = this.createFileIndexFacade();
        this.myMessageBus = this.myProject.getMessageBus();
        PsiModificationTrackerImpl modificationTracker = new PsiModificationTrackerImpl(this.myProject);
        this.myProject.registerService(PsiModificationTracker.class, modificationTracker);
        this.myProject.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.myProject.registerService(ResolveCache.class, new ResolveCache(this.myProject));
        this.myPsiManager = new PsiManagerImpl(this.myProject);
        this.myProject.registerService(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(SmartPointerManager.class, SmartPointerManagerImpl.class);
        this.myProject.registerService(DocumentCommitProcessor.class, new MockDocumentCommitProcessor());
        this.myProject.registerService(PsiDocumentManager.class, new CorePsiDocumentManager(this.myProject));
        this.myProject.registerService(ResolveScopeManager.class, this.createResolveScopeManager(this.myPsiManager));
        this.myProject.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myProject)));
        this.myProject.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.myProject));
        this.myProject.registerService(ProjectScopeBuilder.class, this.createProjectScopeBuilder());
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
        this.myProject.registerService(DumbUtil.class, new MockDumbUtil());
        this.myProject.registerService(CoreEncodingProjectManager.class, CoreEncodingProjectManager.class);
        this.myProject.registerService(InjectedLanguageManager.class, new CoreInjectedLanguageManager());
    }

    @NotNull
    protected MockProject createProject(@NotNull PicoContainer parent2, @NotNull Disposable parentDisposable) {
        if (parent2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(3);
        }
        return new MockProject(parent2, parentDisposable);
    }

    @NotNull
    protected ProjectScopeBuilder createProjectScopeBuilder() {
        return new CoreProjectScopeBuilder(this.myProject, this.myFileIndexFacade);
    }

    protected void preregisterServices() {
    }

    @NotNull
    protected FileIndexFacade createFileIndexFacade() {
        return new MockFileIndexFacade(this.myProject);
    }

    @NotNull
    protected ResolveScopeManager createResolveScopeManager(@NotNull PsiManager psiManager2) {
        if (psiManager2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(4);
        }
        return new MockResolveScopeManager(psiManager2.getProject());
    }

    public <T> void addProjectExtension(@NotNull ExtensionPointName<T> name2, @NotNull T extension) {
        if (name2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(5);
        }
        if (extension == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(6);
        }
        name2.getPoint(this.myProject).registerExtension(extension, this.myParentDisposable);
    }

    public <T> void registerProjectComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation2) {
        if (interfaceClass == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(7);
        }
        if (implementation2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(8);
        }
        CoreApplicationEnvironment.registerComponentInstance(this.myProject.getPicoContainer(), interfaceClass, implementation2);
        if (implementation2 instanceof Disposable) {
            Disposer.register(this.myProject, (Disposable)implementation2);
        }
    }

    @NotNull
    public Disposable getParentDisposable() {
        Disposable disposable = this.myParentDisposable;
        if (disposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(9);
        }
        return disposable;
    }

    @NotNull
    public CoreApplicationEnvironment getEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.myEnvironment;
        if (coreApplicationEnvironment == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(10);
        }
        return coreApplicationEnvironment;
    }

    @NotNull
    public MockProject getProject() {
        MockProject mockProject = this.myProject;
        if (mockProject == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(11);
        }
        return mockProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/core/CoreProjectEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/core/CoreProjectEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDisposable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createResolveScopeManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addProjectExtension";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectComponent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

