/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.Processors;
import java.util.function.Function;

public final class ComponentNames {
    private final Function<ClassName, ClassName> rootRenamer;

    public static ComponentNames withoutRenaming() {
        return new ComponentNames(Function.identity());
    }

    public static ComponentNames withRenaming(Function<ClassName, ClassName> rootRenamer) {
        return new ComponentNames(rootRenamer);
    }

    private ComponentNames(Function<ClassName, ClassName> rootRenamer) {
        this.rootRenamer = rootRenamer;
    }

    public ClassName generatedComponentTreeDeps(ClassName root) {
        return Processors.append(Processors.getEnclosedClassName(this.rootRenamer.apply(root)), "_ComponentTreeDeps");
    }

    public ClassName generatedComponentsWrapper(ClassName root) {
        return Processors.append(Processors.getEnclosedClassName(this.rootRenamer.apply(root)), "_HiltComponents");
    }

    public ClassName generatedComponent(ClassName root, ClassName component) {
        return this.generatedComponentsWrapper(root).nestedClass(ComponentNames.componentName(component));
    }

    private static String componentName(ClassName component) {
        return Processors.getEnclosedName(component).replaceAll("Component$", "C");
    }
}

