/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.processor.internal.ClassNames;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

final class Generators {
    private static final ImmutableMap<ClassName, String> SUPPRESS_ANNOTATION_PROPERTY_NAME = ImmutableMap.builder().put((Object)ClassNames.SUPPRESS_WARNINGS, (Object)"value").put((Object)ClassNames.KOTLIN_SUPPRESS, (Object)"names").build();

    static void addGeneratedBaseClassJavadoc(TypeSpec.Builder builder, ClassName annotation) {
        builder.addJavadoc("A generated base class to be extended by the @$T annotated class. If using the Gradle plugin, this is swapped as the base class via bytecode transformation.", new Object[]{annotation});
    }

    static void copyConstructors(XTypeElement baseClass, TypeSpec.Builder builder) {
        Generators.copyConstructors(baseClass, CodeBlock.builder().build(), builder);
    }

    static void copyConstructors(XTypeElement baseClass, CodeBlock body, TypeSpec.Builder builder) {
        ImmutableList constructors = (ImmutableList)baseClass.getConstructors().stream().filter(constructor -> !constructor.isPrivate()).collect(DaggerStreams.toImmutableList());
        if (constructors.size() == 1 && ((XConstructorElement)Iterables.getOnlyElement((Iterable)constructors)).getParameters().isEmpty() && body.isEmpty()) {
            return;
        }
        constructors.forEach(constructor -> builder.addMethod(Generators.copyConstructor(constructor, body)));
    }

    private static Optional<AnnotationSpec> getNullableAnnotationSpec(XElement element) {
        for (XAnnotation annotation : element.getAllAnnotations()) {
            if (!annotation.getClassName().simpleName().contentEquals("Nullable")) continue;
            AnnotationSpec annotationSpec = JavaPoetExtKt.toAnnotationSpec((XAnnotation)annotation);
            return AndroidClassNames.NULLABLE_INTERNAL.equals((Object)annotationSpec.type) ? Optional.of(AnnotationSpec.builder((ClassName)AndroidClassNames.NULLABLE).build()) : Optional.of(annotationSpec);
        }
        return Optional.empty();
    }

    private static ParameterSpec getParameterSpecWithNullable(XVariableElement parameter) {
        ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)parameter.getType().getTypeName(), (String)XElements.getSimpleName((XElement)parameter), (Modifier[])new Modifier[0]);
        Generators.getNullableAnnotationSpec((XElement)parameter).ifPresent(arg_0 -> ((ParameterSpec.Builder)builder).addAnnotation(arg_0));
        return builder.build();
    }

    static MethodSpec copyConstructor(XConstructorElement constructor) {
        return Generators.copyConstructor(constructor, CodeBlock.builder().build());
    }

    private static MethodSpec copyConstructor(XConstructorElement constructor, CodeBlock body) {
        List params = constructor.getParameters().stream().map(Generators::getParameterSpecWithNullable).collect(Collectors.toList());
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addParameters(params).addStatement("super($L)", new Object[]{params.stream().map(param -> param.name).collect(Collectors.joining(", "))}).addCode(body);
        ((Optional)constructor.getAllAnnotations().stream().filter(a -> a.getTypeElement().hasAnnotation(AndroidClassNames.TARGET_API)).collect(DaggerCollectors.toOptional())).map(JavaPoetExtKt::toAnnotationSpec).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addAnnotation(arg_0));
        return builder.build();
    }

    static void copySuppressAnnotations(XElement element, TypeSpec.Builder builder) {
        ImmutableSet suppressValues = (ImmutableSet)SUPPRESS_ANNOTATION_PROPERTY_NAME.keySet().stream().filter(arg_0 -> ((XElement)element).hasAnnotation(arg_0)).flatMap(annotation -> element.getAnnotation(annotation).getAsStringList((String)SUPPRESS_ANNOTATION_PROPERTY_NAME.get(annotation)).stream()).collect(DaggerStreams.toImmutableSet());
        if (!suppressValues.isEmpty()) {
            AnnotationSpec.Builder annotation2 = AnnotationSpec.builder((ClassName)ClassNames.SUPPRESS_WARNINGS);
            suppressValues.forEach(value -> annotation2.addMember("value", "$S", new Object[]{value}));
            builder.addAnnotation(annotation2.build());
        }
    }

    static void copyLintAnnotations(XElement element, TypeSpec.Builder builder) {
        if (element.hasAnnotation(AndroidClassNames.TARGET_API)) {
            builder.addAnnotation(JavaPoetExtKt.toAnnotationSpec((XAnnotation)element.getAnnotation(AndroidClassNames.TARGET_API)));
        }
    }

    static void addComponentOverride(AndroidEntryPointMetadata metadata, TypeSpec.Builder builder) {
        if (metadata.overridesAndroidEntryPointClass()) {
            return;
        }
        builder.addSuperinterface((TypeName)ClassNames.GENERATED_COMPONENT_MANAGER_HOLDER).addMethod(MethodSpec.methodBuilder((String)"generatedComponent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)TypeName.OBJECT).addStatement("return $L.generatedComponent()", new Object[]{Generators.componentManagerCallBlock(metadata)}).build());
    }

    static void addInjectionMethods(AndroidEntryPointMetadata metadata, TypeSpec.Builder builder) {
        switch (metadata.androidType()) {
            case ACTIVITY: 
            case FRAGMENT: 
            case VIEW: 
            case SERVICE: {
                Generators.addComponentManagerMethods(metadata, builder);
            }
            case BROADCAST_RECEIVER: {
                Generators.addInjectAndMaybeOptionalInjectMethod(metadata, builder);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static void addComponentManagerMethods(AndroidEntryPointMetadata metadata, TypeSpec.Builder typeSpecBuilder) {
        if (metadata.overridesAndroidEntryPointClass()) {
            return;
        }
        ParameterSpec managerParam = metadata.componentManagerParam();
        typeSpecBuilder.addField(Generators.componentManagerField(metadata));
        typeSpecBuilder.addMethod(Generators.createComponentManagerMethod(metadata));
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"componentManager").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(managerParam.type).beginControlFlow("if ($N == null)", new Object[]{managerParam});
        if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.VIEW) {
            typeSpecBuilder.addField(Generators.componentManagerLockField());
            methodSpecBuilder.beginControlFlow("synchronized (componentManagerLock)", new Object[0]).beginControlFlow("if ($N == null)", new Object[]{managerParam});
        }
        methodSpecBuilder.addStatement("$N = createComponentManager()", new Object[]{managerParam}).endControlFlow();
        if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.VIEW) {
            methodSpecBuilder.endControlFlow().endControlFlow();
        }
        methodSpecBuilder.addStatement("return $N", new Object[]{managerParam});
        typeSpecBuilder.addMethod(methodSpecBuilder.build());
    }

    private static MethodSpec createComponentManagerMethod(AndroidEntryPointMetadata metadata) {
        Preconditions.checkState((boolean)metadata.componentManagerInitArgs().isPresent(), (Object)"This method should not have been called for metadata where the init args are not present.");
        return MethodSpec.methodBuilder((String)"createComponentManager").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(metadata.componentManager()).addStatement("return new $T($L)", new Object[]{metadata.componentManager(), metadata.componentManagerInitArgs().get()}).build();
    }

    private static FieldSpec componentManagerField(AndroidEntryPointMetadata metadata) {
        ParameterSpec managerParam = metadata.componentManagerParam();
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)managerParam.type, (String)managerParam.name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.VIEW) {
            builder.addModifiers(new Modifier[]{Modifier.VOLATILE});
        }
        return builder.build();
    }

    private static FieldSpec componentManagerLockField() {
        return FieldSpec.builder((TypeName)TypeName.get(Object.class), (String)"componentManagerLock", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new Object()", new Object[0]).build();
    }

    private static void addInjectAndMaybeOptionalInjectMethod(AndroidEntryPointMetadata metadata, TypeSpec.Builder typeSpecBuilder) {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"inject").addModifiers(new Modifier[]{Modifier.PROTECTED});
        if (metadata.allowsOptionalInjection()) {
            CodeBlock parentCodeBlock;
            if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.BROADCAST_RECEIVER) {
                parentCodeBlock = CodeBlock.of((String)"optionalInjectGetParent()", (Object[])new Object[0]);
                typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"optionalInjectGetParent").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)TypeName.OBJECT).addStatement("return $L", new Object[]{Generators.getParentCodeBlock(metadata)}).build());
            } else {
                parentCodeBlock = CodeBlock.of((String)"$T.getApplication(context.getApplicationContext())", (Object[])new Object[]{ClassNames.CONTEXTS});
            }
            methodSpecBuilder.beginControlFlow("if (!optionalInjectParentUsesHilt($L))", new Object[]{parentCodeBlock}).addStatement("return", new Object[0]).endControlFlow();
            typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"optionalInjectParentUsesHilt").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)TypeName.OBJECT, "parent", new Modifier[0]).returns(TypeName.BOOLEAN).addStatement("return (parent instanceof $T) && (!(parent instanceof $T) || (($T) parent).wasInjectedByHilt())", new Object[]{ClassNames.GENERATED_COMPONENT_MANAGER, AndroidClassNames.INJECTED_BY_HILT, AndroidClassNames.INJECTED_BY_HILT}).build());
        }
        if (metadata.overridesAndroidEntryPointClass() && Generators.ancestorExtendsGeneratedHiltClass(metadata)) {
            methodSpecBuilder.addAnnotation(Override.class);
        }
        typeSpecBuilder.addField(Generators.injectedField(metadata));
        switch (metadata.androidType()) {
            case ACTIVITY: 
            case FRAGMENT: 
            case VIEW: 
            case SERVICE: {
                methodSpecBuilder.beginControlFlow("if (!injected)", new Object[0]).addStatement("injected = true", new Object[0]).addStatement("(($T) $L).$L($L)", new Object[]{metadata.injectorClassName(), Generators.generatedComponentCallBlock(metadata), metadata.injectMethodName(), Generators.unsafeCastThisTo(metadata.elementClassName())}).endControlFlow();
                break;
            }
            case BROADCAST_RECEIVER: {
                typeSpecBuilder.addField(Generators.injectedLockField());
                methodSpecBuilder.addParameter(ParameterSpec.builder((TypeName)AndroidClassNames.CONTEXT, (String)"context", (Modifier[])new Modifier[0]).build()).beginControlFlow("if (!injected)", new Object[0]).beginControlFlow("synchronized (injectedLock)", new Object[0]).beginControlFlow("if (!injected)", new Object[0]).addStatement("(($T) $T.generatedComponent(context)).$L($L)", new Object[]{metadata.injectorClassName(), metadata.componentManager(), metadata.injectMethodName(), Generators.unsafeCastThisTo(metadata.elementClassName())}).addStatement("injected = true", new Object[0]).endControlFlow().endControlFlow().endControlFlow();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (metadata.allowsOptionalInjection() || metadata.baseAllowsOptionalInjection()) {
            typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"wasInjectedByHilt").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return injected", new Object[0]).build());
            if (metadata.allowsOptionalInjection()) {
                typeSpecBuilder.addSuperinterface((TypeName)AndroidClassNames.INJECTED_BY_HILT);
            }
        }
        typeSpecBuilder.addMethod(methodSpecBuilder.build());
    }

    private static CodeBlock getParentCodeBlock(AndroidEntryPointMetadata metadata) {
        switch (metadata.androidType()) {
            case ACTIVITY: 
            case SERVICE: {
                return CodeBlock.of((String)"$T.getApplication(getApplicationContext())", (Object[])new Object[]{ClassNames.CONTEXTS});
            }
            case FRAGMENT: {
                return CodeBlock.of((String)"getHost()", (Object[])new Object[0]);
            }
            case VIEW: {
                return CodeBlock.of((String)"$L.maybeGetParentComponentManager()", (Object[])new Object[]{Generators.componentManagerCallBlock(metadata)});
            }
            case BROADCAST_RECEIVER: {
                throw new AssertionError((Object)"BroadcastReceiver types should not get here");
            }
        }
        throw new AssertionError();
    }

    private static CodeBlock generatedComponentCallBlock(AndroidEntryPointMetadata metadata) {
        return CodeBlock.of((String)"$L.generatedComponent()", (Object[])new Object[]{!metadata.isRootMetadata() && metadata.rootMetadata().requiresBytecodeInjection() ? Generators.unsafeCastThisTo(ClassNames.GENERATED_COMPONENT_MANAGER_HOLDER) : "this"});
    }

    private static CodeBlock componentManagerCallBlock(AndroidEntryPointMetadata metadata) {
        return CodeBlock.of((String)"$L.componentManager()", (Object[])new Object[]{!metadata.isRootMetadata() && metadata.rootMetadata().requiresBytecodeInjection() ? Generators.unsafeCastThisTo(ClassNames.GENERATED_COMPONENT_MANAGER_HOLDER) : "this"});
    }

    static CodeBlock unsafeCastThisTo(ClassName castType) {
        return CodeBlock.of((String)"$T.<$T>unsafeCast(this)", (Object[])new Object[]{ClassNames.UNSAFE_CASTS, castType});
    }

    private static boolean ancestorExtendsGeneratedHiltClass(AndroidEntryPointMetadata metadata) {
        while (metadata.baseMetadata().isPresent()) {
            if ((metadata = metadata.baseMetadata().get()).requiresBytecodeInjection()) continue;
            return true;
        }
        return false;
    }

    private static FieldSpec injectedField(AndroidEntryPointMetadata metadata) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)"injected", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (metadata.androidType() == AndroidEntryPointMetadata.AndroidType.BROADCAST_RECEIVER) {
            builder.addModifiers(new Modifier[]{Modifier.VOLATILE});
        }
        if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.VIEW) {
            builder.initializer("false", new Object[0]);
        }
        return builder.build();
    }

    private static FieldSpec injectedLockField() {
        return FieldSpec.builder((TypeName)TypeName.OBJECT, (String)"injectedLock", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{TypeName.OBJECT}).build();
    }

    private Generators() {
    }
}

