/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.testing;

import dagger.hilt.android.internal.testing.TestComponentData;
import java.lang.reflect.InvocationTargetException;

public abstract class TestComponentDataSupplier {
    protected abstract TestComponentData get();

    static TestComponentData get(Class<?> testClass) {
        String generatedClassName = TestComponentDataSupplier.getEnclosedClassName(testClass) + "_TestComponentDataSupplier";
        try {
            return Class.forName(generatedClassName).asSubclass(TestComponentDataSupplier.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(TestComponentDataSupplier.errorMessage(testClass, generatedClassName), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(TestComponentDataSupplier.errorMessage(testClass, generatedClassName), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(TestComponentDataSupplier.errorMessage(testClass, generatedClassName), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(TestComponentDataSupplier.errorMessage(testClass, generatedClassName), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(TestComponentDataSupplier.errorMessage(testClass, generatedClassName), e);
        }
    }

    private static String errorMessage(Class<?> testClass, String generatedClassName) {
        return String.format("Hilt test, %s, is missing generated file: %s. Check that the test class is  annotated with @HiltAndroidTest and that the processor is running over your test.", testClass.getSimpleName(), generatedClassName);
    }

    private static String getEnclosedClassName(Class<?> testClass) {
        StringBuilder sb = new StringBuilder();
        Class<?> currClass = testClass;
        while (currClass != null) {
            Class<?> enclosingClass = currClass.getEnclosingClass();
            if (enclosingClass != null) {
                sb.insert(0, "_" + currClass.getSimpleName());
            } else {
                sb.insert(0, currClass.getCanonicalName());
            }
            currClass = enclosingClass;
        }
        return sb.toString();
    }
}

