/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a$\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0006\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\b\u001a\n\u0010\r\u001a\u00020\f*\u00020\u0001\u00a8\u0006\u000e"}, d2={"getSdkPathFromEnvironmentVariable", "Ljava/io/File;", "forEachZipEntry", "", "Ljava/util/zip/ZipInputStream;", "block", "Lkotlin/Function2;", "Ljava/io/InputStream;", "Ljava/util/zip/ZipEntry;", "getSdkPath", "Lorg/gradle/api/Project;", "isClassFile", "", "isJarFile", "plugin"})
public final class FilesKt {
    public static final boolean isClassFile(@NotNull File $this$isClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassFile, (String)"$this$isClassFile");
        return $this$isClassFile.isFile() && Intrinsics.areEqual((Object)kotlin.io.FilesKt.getExtension((File)$this$isClassFile), (Object)"class");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isClassFile(@NotNull ZipEntry $this$isClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassFile, (String)"$this$isClassFile");
        if ($this$isClassFile.isDirectory()) return false;
        String string = $this$isClassFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean isJarFile(@NotNull File $this$isJarFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJarFile, (String)"$this$isJarFile");
        return $this$isJarFile.isFile() && Intrinsics.areEqual((Object)kotlin.io.FilesKt.getExtension((File)$this$isJarFile), (Object)"jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forEachZipEntry(@NotNull ZipInputStream $this$forEachZipEntry, @NotNull Function2<? super InputStream, ? super ZipEntry, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachZipEntry, (String)"$this$forEachZipEntry");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Closeable closeable = $this$forEachZipEntry;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipInputStream it = (ZipInputStream)closeable;
            boolean bl3 = false;
            ZipEntry inputEntry = $this$forEachZipEntry.getNextEntry();
            while (inputEntry != null) {
                block.invoke((Object)$this$forEachZipEntry, (Object)inputEntry);
                inputEntry = $this$forEachZipEntry.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File getSdkPath(@NotNull Project $this$getSdkPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getSdkPath, (String)"$this$getSdkPath");
        Project project = $this$getSdkPath.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"rootProject");
        File file = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootProject.projectDir");
        File localPropsFile = kotlin.io.FilesKt.resolve((File)file, (String)"local.properties");
        if (localPropsFile.exists()) {
            File sdkDirectory;
            String localSdkDir;
            Properties localProps = new Properties();
            Object object = localPropsFile;
            boolean bl = false;
            object = new FileInputStream((File)object);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)object;
                boolean bl3 = false;
                localProps.load(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object object2 = localProps.get("sdk.dir");
            String string = localSdkDir = object2 != null ? object2.toString() : null;
            if (localSdkDir != null && (sdkDirectory = new File(localSdkDir)).isDirectory()) {
                return sdkDirectory;
            }
        }
        return FilesKt.getSdkPathFromEnvironmentVariable();
    }

    private static final File getSdkPathFromEnvironmentVariable() {
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new String[]{"ANDROID_HOME", "ANDROID_SDK_ROOT"});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File sdkDirectory;
            String it = (String)element$iv;
            boolean bl = false;
            String envValue = System.getenv(it);
            if (envValue == null || !(sdkDirectory = new File(envValue)).isDirectory()) continue;
            return sdkDirectory;
        }
        String string = "ANDROID_SDK_ROOT environment variable is not set";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }
}

