/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ErrorTypeException;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtils;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public final class Processors {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_INITIALIZER_NAME = "<clinit>";

    public static void generateAggregatingClass(String aggregatingPackage, AnnotationSpec aggregatingAnnotation, XTypeElement originatingElement, Class<?> generatorClass) {
        Processors.generateAggregatingClass(aggregatingPackage, aggregatingAnnotation, originatingElement, generatorClass, XFiler.Mode.Isolating);
    }

    public static void generateAggregatingClass(String aggregatingPackage, AnnotationSpec aggregatingAnnotation, XTypeElement originatingElement, Class<?> generatorClass, XFiler.Mode mode) {
        ClassName name = ClassName.get((String)aggregatingPackage, (String)("_" + Processors.getFullEnclosedName((XElement)originatingElement)), (String[])new String[0]);
        XProcessingEnv env = XConverters.getProcessingEnv((XElement)originatingElement);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(aggregatingAnnotation).addJavadoc("This class should only be referenced by generated code! ", new Object[0]).addJavadoc("This class aggregates information across multiple compilations.\n", new Object[0]);
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)originatingElement);
        Processors.addGeneratedAnnotation(builder, env, generatorClass);
        env.getFiler().write(JavaFile.builder((String)name.packageName(), (TypeSpec)builder.build()).build(), mode);
    }

    public static ImmutableMap<String, XAnnotationValue> getAnnotationValues(XAnnotation annotation) {
        ImmutableMap.Builder annotationMembers = ImmutableMap.builder();
        for (XAnnotationValue value : annotation.getAnnotationValues()) {
            annotationMembers.put((Object)value.getName(), (Object)value);
        }
        return annotationMembers.build();
    }

    public static XTypeElement getAnnotationClassValue(XAnnotation annotation, String key) {
        return (XTypeElement)Iterables.getOnlyElement(Processors.getAnnotationClassValues(annotation, key));
    }

    public static ImmutableList<XTypeElement> getAnnotationClassValues(XAnnotation annotation, String key) {
        ImmutableList<XTypeElement> values = Processors.getOptionalAnnotationClassValues(annotation, key);
        ProcessorErrors.checkState(values.size() >= 1, (XElement)annotation.getTypeElement(), "@%s, '%s' class is invalid or missing: %s", annotation.getName(), key, XAnnotations.toStableString((XAnnotation)annotation));
        return values;
    }

    public static ImmutableList<XTypeElement> getOptionalAnnotationClassValues(XAnnotation annotation, String key) {
        return (ImmutableList)Processors.getOptionalAnnotationValues(annotation, key).stream().filter(XAnnotationValue::hasTypeValue).flatMap(annotationValue -> Processors.getTypeFromAnnotationValue(annotation, annotationValue).stream()).map(XType::getTypeElement).collect(DaggerStreams.toImmutableList());
    }

    private static ImmutableList<XAnnotationValue> getOptionalAnnotationValues(XAnnotation annotation, String key) {
        return ((Optional)annotation.getAnnotationValues().stream().filter(annotationValue -> annotationValue.getName().equals(key)).collect(DaggerCollectors.toOptional())).map(annotationValue -> annotationValue.hasListValue() ? ImmutableList.copyOf((Collection)annotationValue.asAnnotationValueList()) : ImmutableList.of((Object)annotationValue)).orElse(ImmutableList.of());
    }

    private static ImmutableList<XType> getTypeFromAnnotationValue(XAnnotation annotation, XAnnotationValue annotationValue) {
        Processors.validateAnnotationValueType(annotation, annotationValue);
        return ImmutableList.of((Object)annotationValue.asType());
    }

    private static void validateAnnotationValueType(XAnnotation annotation, XAnnotationValue annotationValue) {
        boolean error = false;
        try {
            if (annotationValue.asType().isError()) {
                error = true;
            }
        }
        catch (TypeNotPresentException unused) {
            error = true;
        }
        if (error) {
            throw new ErrorTypeException(String.format("@%s, '%s' class is invalid or missing: %s", XElements.getSimpleName((XMemberContainer)annotation.getTypeElement()), annotationValue.getName(), XAnnotations.toStableString((XAnnotation)annotation)), (XElement)annotation.getTypeElement());
        }
    }

    public static XTypeElement getTopLevelType(XElement originalElement) {
        Preconditions.checkNotNull((Object)originalElement);
        for (XElement e = originalElement; e != null; e = e.getEnclosingElement()) {
            if (!Processors.isTopLevel(e)) continue;
            return XElements.asTypeElement((XElement)e);
        }
        throw new IllegalStateException("Cannot find a top-level type for " + XElements.toStableString((XElement)originalElement));
    }

    public static boolean isTopLevel(XElement element) {
        return element.getEnclosingElement() == null;
    }

    public static boolean hasAnnotation(Element element, ClassName className) {
        return Processors.getAnnotationMirrorOptional(element, className).isPresent();
    }

    public static boolean hasErrorTypeAnnotation(XElement element) {
        for (XAnnotation annotation : element.getAllAnnotations()) {
            if (!annotation.getType().isError()) continue;
            return true;
        }
        return false;
    }

    static Optional<AnnotationMirror> getAnnotationMirrorOptional(Element element, ClassName className) {
        return (Optional)element.getAnnotationMirrors().stream().filter(mirror -> ClassName.get((TypeMirror)mirror.getAnnotationType()).equals((Object)className)).collect(DaggerCollectors.toOptional());
    }

    public static String getEnclosedName(ClassName name) {
        return Joiner.on((char)'_').join((Iterable)name.simpleNames());
    }

    public static ClassName getEnclosedClassName(ClassName className) {
        return ClassName.get((String)className.packageName(), (String)Processors.getEnclosedName(className), (String[])new String[0]);
    }

    public static ClassName getEnclosedClassName(XTypeElement typeElement) {
        return Processors.getEnclosedClassName(typeElement.getClassName());
    }

    public static String getFullEnclosedName(XElement element) {
        Preconditions.checkNotNull((Object)element);
        String qualifiedName = "";
        while (element != null) {
            if (element.getEnclosingElement() == null) {
                qualifiedName = element.getClosestMemberContainer().asClassName().getCanonicalName() + qualifiedName;
            } else if (!XElements.getSimpleName((XElement)element).isEmpty()) {
                qualifiedName = "." + XElements.getSimpleName((XElement)element) + qualifiedName;
            }
            element = element.getEnclosingElement();
        }
        return qualifiedName.replace('.', '_');
    }

    public static ClassName append(ClassName name, String suffix) {
        return name.peerClass(name.simpleName() + suffix);
    }

    public static ClassName prepend(ClassName name, String prefix) {
        return name.peerClass(prefix + name.simpleName());
    }

    public static ClassName removeNameSuffix(XTypeElement type, String suffix) {
        ClassName originalName = type.getClassName();
        String originalSimpleName = originalName.simpleName();
        ProcessorErrors.checkState(originalSimpleName.endsWith(suffix), (XElement)type, "Name of type %s must end with '%s'", originalName, suffix);
        String withoutSuffix = originalSimpleName.substring(0, originalSimpleName.length() - suffix.length());
        return originalName.peerClass(withoutSuffix);
    }

    public static boolean isAssignableFrom(XTypeElement element, ClassName className) {
        return Processors.isAssignableFromAnyOf(element, (ImmutableSet<ClassName>)ImmutableSet.of((Object)className));
    }

    public static boolean isAssignableFromAnyOf(XTypeElement element, ImmutableSet<ClassName> classNames) {
        for (ClassName className : classNames) {
            if (!element.getClassName().equals((Object)className)) continue;
            return true;
        }
        XType superClass = element.getSuperClass();
        if (superClass != null && !superClass.isNone() && !superClass.isError()) {
            Preconditions.checkState((boolean)XTypes.isDeclared((XType)superClass));
            if (Processors.isAssignableFromAnyOf(superClass.getTypeElement(), classNames)) {
                return true;
            }
        }
        for (XType iface : element.getSuperInterfaces()) {
            if (iface.isError()) continue;
            Preconditions.checkState((boolean)XTypes.isDeclared((XType)iface), (String)"Interface type is %s", (Object)XTypes.getKindName((XType)iface));
            if (!Processors.isAssignableFromAnyOf(iface.getTypeElement(), classNames)) continue;
            return true;
        }
        return false;
    }

    public static ImmutableList<XAnnotation> getMapKeyAnnotations(XElement element) {
        return KotlinMetadataUtils.getMetadataUtil().getAnnotationsAnnotatedWith(element, ClassNames.MAP_KEY);
    }

    public static boolean isAnnotatedWithInject(XElement element) {
        return element.hasAnyAnnotation(new ClassName[]{ClassNames.INJECT, ClassNames.JAKARTA_INJECT});
    }

    public static ImmutableList<XAnnotation> getQualifierAnnotations(XElement element) {
        return KotlinMetadataUtils.getMetadataUtil().getAnnotationsAnnotatedWithAnyOf(element, ClassNames.QUALIFIER, ClassNames.JAKARTA_QUALIFIER);
    }

    public static boolean isAnnotatedWithScope(XElement element) {
        return element.hasAnyAnnotation(new ClassName[]{ClassNames.SCOPE, ClassNames.JAKARTA_SCOPE});
    }

    public static ImmutableList<XAnnotation> getScopeAnnotations(XElement element) {
        return ImmutableList.builder().addAll((Iterable)element.getAnnotationsAnnotatedWith(ClassNames.SCOPE)).addAll((Iterable)element.getAnnotationsAnnotatedWith(ClassNames.JAKARTA_SCOPE)).build();
    }

    public static String upperToLowerCamel(String upperCamel) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, upperCamel);
    }

    public static MethodSpec.Builder copyMethodSpecWithoutBody(MethodSpec methodSpec) {
        MethodSpec.Builder builder = methodSpec.isConstructor() ? MethodSpec.constructorBuilder() : MethodSpec.methodBuilder((String)methodSpec.name).returns(methodSpec.returnType);
        return builder.addAnnotations((Iterable)methodSpec.annotations).addModifiers((Iterable)methodSpec.modifiers).addParameters((Iterable)methodSpec.parameters).addExceptions((Iterable)methodSpec.exceptions).addJavadoc(methodSpec.javadoc.toString(), new Object[0]).addTypeVariables((Iterable)methodSpec.typeVariables);
    }

    public static boolean hasDaggerAbstractMethodAnnotation(XExecutableElement method) {
        return method.hasAnnotation(ClassNames.BINDS) || method.hasAnnotation(ClassNames.BINDS_OPTIONAL_OF) || method.hasAnnotation(ClassNames.MULTIBINDS) || method.hasAnnotation(ClassNames.CONTRIBUTES_ANDROID_INJECTOR);
    }

    public static boolean requiresModuleInstance(XTypeElement module) {
        return module.getDeclaredMethods().stream().filter(Processors::isBindingMethod).anyMatch(method -> !method.isAbstract() && !method.isStatic()) && !module.isKotlinObject();
    }

    public static boolean hasVisibleEmptyConstructor(XTypeElement type) {
        List constructors = type.getConstructors();
        return constructors.isEmpty() || constructors.stream().filter(constructor -> constructor.getParameters().isEmpty()).anyMatch(constructor -> !constructor.isPrivate());
    }

    private static boolean isBindingMethod(XExecutableElement method) {
        return method.hasAnnotation(ClassNames.PROVIDES) || method.hasAnnotation(ClassNames.BINDS) || method.hasAnnotation(ClassNames.BINDS_OPTIONAL_OF) || method.hasAnnotation(ClassNames.MULTIBINDS);
    }

    public static void addGeneratedAnnotation(TypeSpec.Builder typeSpecBuilder, XProcessingEnv env, Class<?> generatorClass) {
        Processors.addGeneratedAnnotation(typeSpecBuilder, env, generatorClass.getName());
    }

    public static void addGeneratedAnnotation(TypeSpec.Builder typeSpecBuilder, XProcessingEnv env, String generatorClass) {
        XTypeElement annotation = env.findGeneratedAnnotation();
        if (annotation != null) {
            typeSpecBuilder.addAnnotation(AnnotationSpec.builder((ClassName)annotation.getClassName()).addMember("value", "$S", new Object[]{generatorClass}).build());
        }
    }

    public static AnnotationSpec getOriginatingElementAnnotation(XTypeElement element) {
        TypeName rawType = Processors.rawTypeName((TypeName)Processors.getTopLevelType((XElement)element).getClassName());
        return AnnotationSpec.builder((ClassName)ClassNames.ORIGINATING_ELEMENT).addMember("topLevelClass", "$T.class", new Object[]{rawType}).build();
    }

    public static TypeName rawTypeName(TypeName typeName) {
        return typeName instanceof ParameterizedTypeName ? ((ParameterizedTypeName)typeName).rawType : typeName;
    }

    public static Optional<XTypeElement> getOriginatingTestElement(XElement element) {
        XTypeElement topLevelType = Processors.getOriginatingTopLevelType(element);
        return topLevelType.hasAnnotation(ClassNames.HILT_ANDROID_TEST) ? Optional.of(topLevelType) : Optional.empty();
    }

    private static XTypeElement getOriginatingTopLevelType(XElement element) {
        XTypeElement topLevelType = Processors.getTopLevelType(element);
        if (topLevelType.hasAnnotation(ClassNames.ORIGINATING_ELEMENT)) {
            return Processors.getOriginatingTopLevelType((XElement)XAnnotations.getAsTypeElement((XAnnotation)topLevelType.getAnnotation(ClassNames.ORIGINATING_ELEMENT), (String)"topLevelClass"));
        }
        return topLevelType;
    }

    public static boolean hasJavaPackagePrivateVisibility(XHasModifiers element) {
        return !element.isPrivate() && !element.isProtected() && !element.isInternal() && !element.isPublic();
    }

    private Processors() {
    }
}

