/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExecutableTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import java.io.IOException;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public final class BroadcastReceiverGenerator {
    private static final String ON_RECEIVE_DESCRIPTOR = "onReceive(Landroid/content/Context;Landroid/content/Intent;)V";
    private final XProcessingEnv env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public BroadcastReceiverGenerator(XProcessingEnv env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers()).addMethod(this.onReceiveMethod());
        if (this.metadata.requiresBytecodeInjection() && !BroadcastReceiverGenerator.isOnReceiveImplemented(this.metadata.baseElement())) {
            builder.addAnnotation(ClassNames.ON_RECEIVE_BYTECODE_INJECTION_MARKER);
        }
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)this.metadata.element());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyConstructors(this.metadata.baseElement(), builder, this.metadata.element());
        this.metadata.baseElement().getTypeParameters().stream().map(XTypeParameterElement::getTypeVariableName).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addInjectionMethods(this.metadata, builder);
        Generators.copyLintAnnotations((XElement)this.metadata.element(), builder);
        Generators.copySuppressAnnotations((XElement)this.metadata.element(), builder);
        this.env.getFiler().write(JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build(), XFiler.Mode.Isolating);
    }

    private static boolean isOnReceiveImplemented(XTypeElement typeElement) {
        boolean isImplemented = typeElement.getDeclaredMethods().stream().filter(method -> !method.isAbstract()).anyMatch(method -> method.getJvmDescriptor().equals(ON_RECEIVE_DESCRIPTOR));
        if (isImplemented) {
            return true;
        }
        if (typeElement.getSuperClass() != null) {
            return BroadcastReceiverGenerator.isOnReceiveImplemented(typeElement.getSuperClass().getTypeElement());
        }
        return false;
    }

    private MethodSpec onReceiveMethod() throws IOException {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"onReceive").addAnnotation(Override.class).addAnnotation(AndroidClassNames.CALL_SUPER).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)AndroidClassNames.CONTEXT, (String)"context", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)AndroidClassNames.INTENT, (String)"intent", (Modifier[])new Modifier[0]).build()).addStatement("inject(context)", new Object[0]);
        if (this.metadata.overridesAndroidEntryPointClass()) {
            method.addStatement("super.onReceive(context, intent)", new Object[0]);
        } else {
            XMethodElement onReceiveMethod = (XMethodElement)Iterables.getOnlyElement(BroadcastReceiverGenerator.findMethodsByName(this.env.requireTypeElement((TypeName)AndroidClassNames.BROADCAST_RECEIVER), "onReceive"));
            this.findMethodBySubsignature(this.metadata.baseElement(), onReceiveMethod).filter(onReceive -> !onReceive.isAbstract()).ifPresent(onReceive -> method.addStatement("super.onReceive(context, intent)", new Object[0]));
        }
        return method.build();
    }

    private Optional<XMethodElement> findMethodBySubsignature(XTypeElement typeElement, XMethodElement method) {
        String methodName = XElements.getSimpleName((XElement)method);
        XType currentType = typeElement.getType();
        Optional match = Optional.empty();
        while (!match.isPresent() && currentType != null) {
            match = (Optional)BroadcastReceiverGenerator.findMethodsByName(currentType.getTypeElement(), methodName).stream().filter(m -> XExecutableTypes.isSubsignature((XExecutableElement)m, (XExecutableElement)method)).collect(DaggerCollectors.toOptional());
            currentType = currentType.getTypeElement().getSuperClass();
        }
        return match;
    }

    private static ImmutableSet<XMethodElement> findMethodsByName(XTypeElement typeElement, String name) {
        return (ImmutableSet)typeElement.getDeclaredMethods().stream().filter(m -> XElements.getSimpleName((XElement)m).contentEquals(name)).collect(DaggerStreams.toImmutableSet());
    }
}

