/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.uninstallmodules;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;

final class AggregatedUninstallModulesGenerator {
    private final ProcessingEnvironment env;
    private final TypeElement testElement;
    private final ImmutableList<TypeElement> uninstallModuleElements;

    AggregatedUninstallModulesGenerator(TypeElement testElement, ImmutableList<TypeElement> uninstallModuleElements, ProcessingEnvironment env) {
        this.testElement = testElement;
        this.uninstallModuleElements = uninstallModuleElements;
        this.env = env;
    }

    void generate() throws IOException {
        Processors.generateAggregatingClass("dagger.hilt.android.internal.uninstallmodules.codegen", this.aggregatedUninstallModulesAnnotation(), this.testElement, this.getClass(), this.env);
    }

    private AnnotationSpec aggregatedUninstallModulesAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.AGGREGATED_UNINSTALL_MODULES);
        builder.addMember("test", "$S", new Object[]{this.testElement.getQualifiedName()});
        this.uninstallModuleElements.stream().map(TypeElement::getQualifiedName).forEach(uninstallModule -> builder.addMember("uninstallModules", "$S", new Object[]{uninstallModule}));
        return builder.build();
    }
}

