/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.AutoValue_BaseProcessor_ProcessingState;
import dagger.hilt.processor.internal.ErrorTypeException;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrorHandler;
import dagger.hilt.processor.internal.Processors;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class BaseProcessor
extends AbstractProcessor {
    private final Set<ProcessingState> stateToReprocess = new LinkedHashSet<ProcessingState>();
    private Elements elements;
    private Types types;
    private Messager messager;
    private ProcessorErrorHandler errorHandler;

    @Override
    public final Set<String> getSupportedOptions() {
        return ImmutableSet.builder().addAll(HiltCompilerOptions.getProcessorOptions()).addAll(this.additionalProcessingOptions()).build();
    }

    protected Set<String> additionalProcessingOptions() {
        return ImmutableSet.of();
    }

    protected void preRoundProcess(RoundEnvironment roundEnv) {
    }

    protected void processEach(TypeElement annotation, Element element) throws Exception {
    }

    protected void postRoundProcess(RoundEnvironment roundEnv) throws Exception {
    }

    protected boolean claimAnnotations() {
        return false;
    }

    protected boolean delayErrors() {
        return false;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.messager = this.processingEnv.getMessager();
        this.elements = this.processingEnv.getElementUtils();
        this.types = this.processingEnv.getTypeUtils();
        this.errorHandler = new ProcessorErrorHandler(processingEnvironment);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.preRoundProcess(roundEnv);
        boolean roundError = false;
        LinkedHashMultimap elementMultiMap = LinkedHashMultimap.create();
        for (ProcessingState processingState : this.stateToReprocess) {
            elementMultiMap.put((Object)processingState.annotation(this.elements), (Object)processingState.element(this.elements));
        }
        for (TypeElement typeElement : annotations) {
            elementMultiMap.putAll((Object)typeElement, roundEnv.getElementsAnnotatedWith(typeElement));
        }
        this.stateToReprocess.clear();
        for (Map.Entry entry : elementMultiMap.asMap().entrySet()) {
            TypeElement annotation = (TypeElement)entry.getKey();
            for (Element element : (Collection)entry.getValue()) {
                try {
                    this.processEach(annotation, element);
                }
                catch (Exception e) {
                    if (e instanceof ErrorTypeException && !roundEnv.processingOver()) {
                        this.stateToReprocess.add(ProcessingState.of(annotation, element));
                        continue;
                    }
                    this.errorHandler.recordError(e);
                    roundError = true;
                }
            }
        }
        if (!roundError) {
            try {
                this.postRoundProcess(roundEnv);
            }
            catch (Exception e) {
                this.errorHandler.recordError(e);
            }
        }
        if (!this.delayErrors() || roundEnv.processingOver()) {
            this.errorHandler.checkErrors();
        }
        return this.claimAnnotations();
    }

    protected final ProcessorErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }

    public final Elements getElementUtils() {
        return this.elements;
    }

    public final Types getTypeUtils() {
        return this.types;
    }

    public final Messager getMessager() {
        return this.messager;
    }

    @AutoValue
    static abstract class ProcessingState {
        ProcessingState() {
        }

        private static ProcessingState of(TypeElement annotation, Element element) {
            Preconditions.checkState((boolean)MoreElements.isType(element));
            Preconditions.checkState((boolean)Processors.hasAnnotation(element, ClassName.get((TypeElement)annotation)));
            return new AutoValue_BaseProcessor_ProcessingState(ClassName.get((TypeElement)annotation), ClassName.get((TypeElement)MoreElements.asType(element)));
        }

        abstract ClassName annotationClassName();

        abstract ClassName elementClassName();

        TypeElement annotation(Elements elements) {
            return elements.getTypeElement(this.elementClassName().toString());
        }

        TypeElement element(Elements elements) {
            return elements.getTypeElement(this.annotationClassName().toString());
        }
    }
}

