/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.customtestapplication;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.customtestapplication.AutoValue_CustomTestApplicationMetadata;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.android.shaded.auto.common.MoreTypes;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

@AutoValue
abstract class CustomTestApplicationMetadata {
    CustomTestApplicationMetadata() {
    }

    abstract TypeElement element();

    abstract ClassName baseAppName();

    ClassName appName() {
        return Processors.append(Processors.getEnclosedClassName(ClassName.get((TypeElement)this.element())), "_Application");
    }

    static CustomTestApplicationMetadata of(Element element, Elements elements) {
        Preconditions.checkState((boolean)Processors.hasAnnotation(element, ClassNames.CUSTOM_TEST_APPLICATION), (String)"The given element, %s, is not annotated with @%s.", (Object)element, (Object)ClassNames.CUSTOM_TEST_APPLICATION.simpleName());
        ProcessorErrors.checkState(MoreElements.isType(element), element, "@%s should only be used on classes or interfaces but found: %s", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), element);
        TypeElement baseAppElement = CustomTestApplicationMetadata.getBaseElement(element, elements);
        return new AutoValue_CustomTestApplicationMetadata(MoreElements.asType(element), ClassName.get((TypeElement)baseAppElement));
    }

    private static TypeElement getBaseElement(Element element, Elements elements) {
        TypeElement baseElement;
        TypeElement baseSuperclassElement = baseElement = Processors.getAnnotationClassValue(elements, Processors.getAnnotationMirror(element, ClassNames.CUSTOM_TEST_APPLICATION), "value");
        while (!baseSuperclassElement.getSuperclass().getKind().equals((Object)TypeKind.NONE)) {
            ProcessorErrors.checkState(!Processors.hasAnnotation((Element)baseSuperclassElement, ClassNames.HILT_ANDROID_APP), element, "@%s value cannot be annotated with @%s. Found: %s", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), ClassNames.HILT_ANDROID_APP.simpleName(), baseSuperclassElement);
            ImmutableList injectFields = (ImmutableList)ElementFilter.fieldsIn(baseSuperclassElement.getEnclosedElements()).stream().filter(field -> Processors.hasAnnotation((Element)field, ClassNames.INJECT)).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(injectFields.isEmpty(), element, "@%s does not support application classes (or super classes) with @Inject fields. Found %s with @Inject fields %s.", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), baseSuperclassElement, injectFields);
            ImmutableList injectMethods = (ImmutableList)ElementFilter.methodsIn(baseSuperclassElement.getEnclosedElements()).stream().filter(method -> Processors.hasAnnotation((Element)method, ClassNames.INJECT)).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(injectMethods.isEmpty(), element, "@%s does not support application classes (or super classes) with @Inject methods. Found %s with @Inject methods %s.", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), baseSuperclassElement, injectMethods);
            ImmutableList injectConstructors = (ImmutableList)ElementFilter.constructorsIn(baseSuperclassElement.getEnclosedElements()).stream().filter(method -> Processors.hasAnnotation((Element)method, ClassNames.INJECT)).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(injectConstructors.isEmpty(), element, "@%s does not support application classes (or super classes) with @Inject constructors. Found %s with @Inject constructors %s.", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), baseSuperclassElement, injectConstructors);
            baseSuperclassElement = MoreTypes.asTypeElement(baseSuperclassElement.getSuperclass());
        }
        ProcessorErrors.checkState(Processors.isAssignableFrom(baseElement, ClassNames.APPLICATION), element, "@%s value should be an instance of %s. Found: %s", ClassNames.CUSTOM_TEST_APPLICATION.simpleName(), ClassNames.APPLICATION, baseElement);
        return baseElement;
    }
}

