/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.originatingelement;

import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public final class OriginatingElementProcessor
extends BaseProcessor {
    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.ORIGINATING_ELEMENT.toString());
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        ProcessorErrors.checkState(MoreElements.isType(element) && Processors.isTopLevel(element), element, "@%s should only be used to annotate top-level types, but found: %s", annotation.getSimpleName(), element);
        TypeElement originatingElementValue = Processors.getAnnotationClassValue(this.getElementUtils(), Processors.getAnnotationMirror(element, ClassNames.ORIGINATING_ELEMENT), "topLevelClass");
        ProcessorErrors.checkState(Processors.isTopLevel(originatingElementValue), element, "@%s.topLevelClass value should be a top-level class, but found: %s", annotation.getSimpleName(), originatingElementValue);
    }
}

