/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.value.AutoValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.android.shaded.auto.common.Visibility;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.KotlinMetadataUtils;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_PkgPrivateMetadata;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

@AutoValue
public abstract class PkgPrivateMetadata {
    private static final String PREFIX = "HiltWrapper_";

    public static TypeElement publicModule(TypeElement element, Elements elements) {
        return PkgPrivateMetadata.publicDep(element, elements, ClassNames.MODULE);
    }

    public static TypeElement publicEarlyEntryPoint(TypeElement element, Elements elements) {
        return PkgPrivateMetadata.publicDep(element, elements, ClassNames.EARLY_ENTRY_POINT);
    }

    private static TypeElement publicDep(TypeElement element, Elements elements, ClassName annotation) {
        return PkgPrivateMetadata.of(elements, element, annotation).map(PkgPrivateMetadata::generatedClassName).map(ClassName::canonicalName).map(elements::getTypeElement).orElse(element);
    }

    TypeName baseClassName() {
        return TypeName.get((TypeMirror)this.getTypeElement().asType());
    }

    abstract TypeElement getTypeElement();

    abstract Optional<AnnotationMirror> getOptionalInstallInAnnotationMirror();

    abstract ClassName getAnnotation();

    final ClassName generatedClassName() {
        return Processors.prepend(Processors.getEnclosedClassName(ClassName.get((TypeElement)this.getTypeElement())), PREFIX);
    }

    static Optional<PkgPrivateMetadata> of(Elements elements, TypeElement element, ClassName annotation) {
        Optional<AnnotationMirror> installIn;
        if (Visibility.effectiveVisibilityOfElement(element) == Visibility.PUBLIC && !KotlinMetadataUtils.getMetadataUtil().isVisibilityInternal(element)) {
            return Optional.empty();
        }
        if (Processors.hasAnnotation((Element)element, ClassNames.INSTALL_IN)) {
            installIn = Optional.of(Processors.getAnnotationMirror((Element)element, ClassNames.INSTALL_IN));
        } else if (Processors.hasAnnotation((Element)element, ClassNames.TEST_INSTALL_IN)) {
            installIn = Optional.of(Processors.getAnnotationMirror((Element)element, ClassNames.TEST_INSTALL_IN));
        } else {
            throw new IllegalStateException("Expected element to be annotated with @InstallIn: " + element);
        }
        if (annotation.equals((Object)ClassNames.MODULE) && Processors.requiresModuleInstance(elements, MoreElements.asType(element))) {
            return Optional.empty();
        }
        return Optional.of(new AutoValue_PkgPrivateMetadata(MoreElements.asType(element), installIn, annotation));
    }
}

