/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.shaded.auto.common;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.shaded.auto.common.AnnotationValues;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.android.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public final class AnnotationMirrors {
    private static final Equivalence<AnnotationMirror> ANNOTATION_MIRROR_EQUIVALENCE = new Equivalence<AnnotationMirror>(){

        protected boolean doEquivalent(AnnotationMirror left, AnnotationMirror right) {
            return MoreTypes.equivalence().equivalent((Object)left.getAnnotationType(), (Object)right.getAnnotationType()) && AnnotationValues.equivalence().pairwise().equivalent((Object)AnnotationMirrors.getAnnotationValuesWithDefaults(left).values(), (Object)AnnotationMirrors.getAnnotationValuesWithDefaults(right).values());
        }

        protected int doHash(AnnotationMirror annotation) {
            DeclaredType type = annotation.getAnnotationType();
            ImmutableCollection annotationValues = AnnotationMirrors.getAnnotationValuesWithDefaults(annotation).values();
            return Arrays.hashCode(new int[]{MoreTypes.equivalence().hash((Object)type), AnnotationValues.equivalence().pairwise().hash((Object)annotationValues)});
        }
    };

    public static Equivalence<AnnotationMirror> equivalence() {
        return ANNOTATION_MIRROR_EQUIVALENCE;
    }

    public static ImmutableMap<ExecutableElement, AnnotationValue> getAnnotationValuesWithDefaults(AnnotationMirror annotation) {
        ImmutableMap.Builder values = ImmutableMap.builder();
        Map<? extends ExecutableElement, ? extends AnnotationValue> declaredValues = annotation.getElementValues();
        for (ExecutableElement method : ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements())) {
            if (declaredValues.containsKey(method)) {
                values.put((Object)method, (Object)declaredValues.get(method));
                continue;
            }
            if (method.getDefaultValue() != null) {
                values.put((Object)method, (Object)method.getDefaultValue());
                continue;
            }
            String string = String.valueOf(MoreElements.asType(method.getEnclosingElement()).getQualifiedName());
            String string2 = String.valueOf(method.getSimpleName());
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unset annotation value without default should never happen: ").append(string).append('.').append(string2).append("()").toString());
        }
        return values.build();
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String elementName) {
        return AnnotationMirrors.getAnnotationElementAndValue(annotationMirror, elementName).getValue();
    }

    public static Map.Entry<ExecutableElement, AnnotationValue> getAnnotationElementAndValue(AnnotationMirror annotationMirror, String elementName) {
        Preconditions.checkNotNull((Object)annotationMirror);
        Preconditions.checkNotNull((Object)elementName);
        for (Map.Entry entry : AnnotationMirrors.getAnnotationValuesWithDefaults(annotationMirror).entrySet()) {
            if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals(elementName)) continue;
            return entry;
        }
        throw new IllegalArgumentException(String.format("@%s does not define an element %s()", MoreElements.asType(annotationMirror.getAnnotationType().asElement()).getQualifiedName(), elementName));
    }

    public static ImmutableSet<? extends AnnotationMirror> getAnnotatedAnnotations(Element element, final Class<? extends Annotation> annotationType) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        return FluentIterable.from(annotations).filter((Predicate)new Predicate<AnnotationMirror>(){

            public boolean apply(AnnotationMirror input) {
                return MoreElements.isAnnotationPresent(input.getAnnotationType().asElement(), annotationType);
            }
        }).toSet();
    }

    private AnnotationMirrors() {
    }
}

