/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.viewmodel;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableNetwork;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.shaded.auto.common.MoreTypes;
import dagger.hilt.processor.internal.Processors;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Ldagger/hilt/android/processor/internal/viewmodel/ViewModelValidationPlugin;", "Ldagger/spi/BindingGraphPlugin;", "()V", "isHiltViewModelBinding", "", "target", "Ldagger/model/Binding;", "isInternalHiltViewModelUsage", "source", "Ldagger/model/BindingGraph$Node;", "visitGraph", "", "bindingGraph", "Ldagger/model/BindingGraph;", "diagnosticReporter", "Ldagger/spi/DiagnosticReporter;", "java_dagger_hilt_android_processor_internal_viewmodel-validation_plugin_lib"})
public final class ViewModelValidationPlugin
implements BindingGraphPlugin {
    public void visitGraph(@NotNull BindingGraph bindingGraph, @NotNull DiagnosticReporter diagnosticReporter) {
        Intrinsics.checkNotNullParameter((Object)bindingGraph, (String)"bindingGraph");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        if (bindingGraph.rootComponentNode().isSubcomponent()) {
            return;
        }
        ImmutableNetwork immutableNetwork = bindingGraph.network();
        Intrinsics.checkNotNullExpressionValue((Object)immutableNetwork, (String)"bindingGraph.network()");
        ImmutableNetwork network = immutableNetwork;
        ImmutableSet immutableSet = bindingGraph.dependencyEdges();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"bindingGraph.dependencyEdges()");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EndpointPair pair;
            BindingGraph.DependencyEdge edge = (BindingGraph.DependencyEdge)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)network.incidentNodes((Object)edge), (String)"network.incidentNodes(edge)");
            Object object = pair.target();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.target()");
            BindingGraph.Node target = (BindingGraph.Node)object;
            Object object2 = pair.source();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"pair.source()");
            BindingGraph.Node source = (BindingGraph.Node)object2;
            if (!(target instanceof Binding) || !this.isHiltViewModelBinding((Binding)target) || this.isInternalHiltViewModelUsage(source)) continue;
            diagnosticReporter.reportDependency(Diagnostic.Kind.ERROR, edge, "\nInjection of an @HiltViewModel class is prohibited since it does not create a ViewModel instance correctly.\nAccess the ViewModel via the Android APIs (e.g. ViewModelProvider) instead." + "\nInjected ViewModel: " + ((Binding)target).key().type() + '\n');
        }
    }

    private final boolean isHiltViewModelBinding(Binding target) {
        return target.kind() == BindingKind.INJECTION && Processors.hasAnnotation(MoreTypes.asElement(target.key().type()), AndroidClassNames.HILT_VIEW_MODEL);
    }

    private final boolean isInternalHiltViewModelUsage(BindingGraph.Node source) {
        return source instanceof Binding && ((Binding)source).key().qualifier().isPresent() && Intrinsics.areEqual((Object)ClassName.get((TypeMirror)((AnnotationMirror)((Binding)source).key().qualifier().get()).getAnnotationType()), (Object)AndroidClassNames.HILT_VIEW_MODEL_MAP_QUALIFIER) && ((Binding)source).key().multibindingContributionIdentifier().isPresent();
    }
}

