/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.CodeBlock;
import dagger.model.$AutoValue_Key;
import dagger.spi.internal.shaded.com.google.auto.common.AnnotationMirrors;
import dagger.spi.internal.shaded.com.google.auto.common.MoreTypes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

@AutoValue
public abstract class Key {
    public final Optional<AnnotationMirror> qualifier() {
        return this.wrappedQualifier().map(Equivalence.Wrapper::get);
    }

    public final TypeMirror type() {
        return (TypeMirror)this.wrappedType().get();
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedQualifier();

    abstract Equivalence.Wrapper<TypeMirror> wrappedType();

    public abstract Optional<MultibindingContributionIdentifier> multibindingContributionIdentifier();

    public abstract Builder toBuilder();

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static String stableAnnotationMirrorToString(AnnotationMirror qualifier) {
        StringBuilder builder = new StringBuilder("@").append(qualifier.getAnnotationType());
        ImmutableMap<ExecutableElement, AnnotationValue> elementValues = AnnotationMirrors.getAnnotationValuesWithDefaults(qualifier);
        if (!elementValues.isEmpty()) {
            ImmutableMap.Builder namedValuesBuilder = ImmutableMap.builder();
            elementValues.forEach((key, value) -> namedValuesBuilder.put((Object)key.getSimpleName().toString(), (Object)Key.stableAnnotationValueToString(value)));
            ImmutableMap namedValues = namedValuesBuilder.build();
            builder.append('(');
            if (namedValues.size() == 1 && namedValues.containsKey((Object)"value")) {
                builder.append((String)namedValues.get((Object)"value"));
            } else {
                builder.append(Joiner.on((String)", ").withKeyValueSeparator("=").join((Map)namedValues));
            }
            builder.append(')');
        }
        return builder.toString();
    }

    private static String stableAnnotationValueToString(AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<String, Void>(){

            @Override
            protected String defaultAction(Object value, Void ignore) {
                return value.toString();
            }

            @Override
            public String visitString(String value, Void ignore) {
                return CodeBlock.of((String)"$S", (Object[])new Object[]{value}).toString();
            }

            @Override
            public String visitAnnotation(AnnotationMirror value, Void ignore) {
                return Key.stableAnnotationMirrorToString(value);
            }

            @Override
            public String visitArray(List<? extends AnnotationValue> value, Void ignore) {
                return value.stream().map(x$0 -> Key.stableAnnotationValueToString(x$0)).collect(Collectors.joining(", ", "{", "}"));
            }
        }, null);
    }

    public final String toString() {
        return Joiner.on((char)' ').skipNulls().join(this.qualifier().map(Key::stableAnnotationMirrorToString).orElse(null), (Object)this.type(), new Object[]{this.multibindingContributionIdentifier().orElse(null)});
    }

    public static Builder builder(TypeMirror type) {
        return new $AutoValue_Key.Builder().type(type);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder wrappedType(Equivalence.Wrapper<TypeMirror> var1);

        @CanIgnoreReturnValue
        public final Builder type(TypeMirror type) {
            return this.wrappedType((Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)((TypeMirror)Preconditions.checkNotNull((Object)type))));
        }

        abstract Builder wrappedQualifier(Optional<Equivalence.Wrapper<AnnotationMirror>> var1);

        abstract Builder wrappedQualifier(Equivalence.Wrapper<AnnotationMirror> var1);

        @CanIgnoreReturnValue
        public final Builder qualifier(AnnotationMirror qualifier) {
            return this.wrappedQualifier((Equivalence.Wrapper<AnnotationMirror>)AnnotationMirrors.equivalence().wrap((Object)((AnnotationMirror)Preconditions.checkNotNull((Object)qualifier))));
        }

        @CanIgnoreReturnValue
        public final Builder qualifier(Optional<AnnotationMirror> qualifier) {
            return this.wrappedQualifier(((Optional)Preconditions.checkNotNull(qualifier)).map(arg_0 -> AnnotationMirrors.equivalence().wrap(arg_0)));
        }

        public abstract Builder multibindingContributionIdentifier(Optional<MultibindingContributionIdentifier> var1);

        public abstract Builder multibindingContributionIdentifier(MultibindingContributionIdentifier var1);

        public abstract Key build();
    }

    public static final class MultibindingContributionIdentifier {
        private final String module;
        private final String bindingElement;

        @Deprecated
        public MultibindingContributionIdentifier(ExecutableElement bindingMethod, TypeElement contributingModule) {
            this(bindingMethod.getSimpleName().toString(), contributingModule.getQualifiedName().toString());
        }

        @Deprecated
        public MultibindingContributionIdentifier(String bindingElement, String module) {
            this.module = module;
            this.bindingElement = bindingElement;
        }

        @Deprecated
        public String module() {
            return this.module;
        }

        @Deprecated
        public String bindingElement() {
            return this.bindingElement;
        }

        public String toString() {
            return String.format("%s#%s", this.module, this.bindingElement);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MultibindingContributionIdentifier) {
                MultibindingContributionIdentifier other = (MultibindingContributionIdentifier)obj;
                return this.module.equals(other.module) && this.bindingElement.equals(other.bindingElement);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.module, this.bindingElement);
        }
    }
}

