/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.internal.shaded.com.google.auto.common;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dagger.spi.internal.shaded.com.google.auto.common.AnnotationMirrors;
import dagger.spi.internal.shaded.com.google.auto.common.AnnotationOutput;
import dagger.spi.internal.shaded.com.google.auto.common.MoreStreams;
import dagger.spi.internal.shaded.com.google.auto.common.MoreTypes;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class AnnotationValues {
    private static final Equivalence<AnnotationValue> ANNOTATION_VALUE_EQUIVALENCE = new Equivalence<AnnotationValue>(){

        protected boolean doEquivalent(AnnotationValue left, AnnotationValue right) {
            return left.accept(new SimpleAnnotationValueVisitor8<Boolean, AnnotationValue>(this){

                @Override
                protected Boolean defaultAction(Object left, AnnotationValue right) {
                    return left.equals(right.accept(new SimpleAnnotationValueVisitor8<Object, Void>(this){

                        @Override
                        protected Object defaultAction(Object object, Void unused) {
                            return object;
                        }
                    }, null));
                }

                @Override
                public Boolean visitAnnotation(AnnotationMirror left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, AnnotationMirror>(this){

                        @Override
                        protected Boolean defaultAction(Object right, AnnotationMirror left) {
                            return false;
                        }

                        @Override
                        public Boolean visitAnnotation(AnnotationMirror right, AnnotationMirror left) {
                            return AnnotationMirrors.equivalence().equivalent((Object)left, (Object)right);
                        }
                    }, left);
                }

                @Override
                public Boolean visitArray(List<? extends AnnotationValue> left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, List<? extends AnnotationValue>>(this){

                        @Override
                        protected Boolean defaultAction(Object ignored, List<? extends AnnotationValue> alsoIgnored) {
                            return false;
                        }

                        @Override
                        public Boolean visitArray(List<? extends AnnotationValue> right, List<? extends AnnotationValue> left) {
                            return AnnotationValues.equivalence().pairwise().equivalent(left, right);
                        }
                    }, left);
                }

                @Override
                public Boolean visitType(TypeMirror left, AnnotationValue right) {
                    return right.accept(new SimpleAnnotationValueVisitor8<Boolean, TypeMirror>(this){

                        @Override
                        protected Boolean defaultAction(Object ignored, TypeMirror alsoIgnored) {
                            return false;
                        }

                        @Override
                        public Boolean visitType(TypeMirror right, TypeMirror left) {
                            return MoreTypes.equivalence().equivalent((Object)left, (Object)right);
                        }
                    }, left);
                }
            }, right);
        }

        protected int doHash(AnnotationValue value) {
            return value.accept(new SimpleAnnotationValueVisitor8<Integer, Void>(this){

                @Override
                public Integer visitAnnotation(AnnotationMirror value, Void ignore) {
                    return AnnotationMirrors.equivalence().hash((Object)value);
                }

                @Override
                public Integer visitArray(List<? extends AnnotationValue> values, Void ignore) {
                    return AnnotationValues.equivalence().pairwise().hash(values);
                }

                @Override
                public Integer visitType(TypeMirror value, Void ignore) {
                    return MoreTypes.equivalence().hash((Object)value);
                }

                @Override
                protected Integer defaultAction(Object value, Void ignored) {
                    return value.hashCode();
                }
            }, null);
        }
    };
    private static final ArrayVisitor<DeclaredType> TYPE_MIRRORS_VISITOR = new ArrayVisitor<DeclaredType>(AnnotationValues::getTypeMirror);
    private static final ArrayVisitor<AnnotationMirror> ANNOTATION_MIRRORS_VISITOR = new ArrayVisitor<AnnotationMirror>(AnnotationValues::getAnnotationMirror);
    private static final ArrayVisitor<VariableElement> ENUMS_VISITOR = new ArrayVisitor<VariableElement>(AnnotationValues::getEnum);
    private static final ArrayVisitor<String> STRINGS_VISITOR = new ArrayVisitor<String>(AnnotationValues::getString);
    private static final ArrayVisitor<Integer> INTS_VISITOR = new ArrayVisitor<Integer>(AnnotationValues::getInt);
    private static final ArrayVisitor<Long> LONGS_VISITOR = new ArrayVisitor<Long>(AnnotationValues::getLong);
    private static final ArrayVisitor<Byte> BYTES_VISITOR = new ArrayVisitor<Byte>(AnnotationValues::getByte);
    private static final ArrayVisitor<Short> SHORTS_VISITOR = new ArrayVisitor<Short>(AnnotationValues::getShort);
    private static final ArrayVisitor<Float> FLOATS_VISITOR = new ArrayVisitor<Float>(AnnotationValues::getFloat);
    private static final ArrayVisitor<Double> DOUBLES_VISITOR = new ArrayVisitor<Double>(AnnotationValues::getDouble);
    private static final ArrayVisitor<Boolean> BOOLEANS_VISITOR = new ArrayVisitor<Boolean>(AnnotationValues::getBoolean);
    private static final ArrayVisitor<Character> CHARS_VISITOR = new ArrayVisitor<Character>(AnnotationValues::getChar);
    private static final ArrayVisitor<AnnotationValue> ANNOTATION_VALUES_VISITOR = new ArrayVisitor<AnnotationValue>(x -> x);

    public static Equivalence<AnnotationValue> equivalence() {
        return ANNOTATION_VALUE_EQUIVALENCE;
    }

    public static DeclaredType getTypeMirror(AnnotationValue value) {
        return (DeclaredType)TypeMirrorVisitor.INSTANCE.visit(value);
    }

    public static AnnotationMirror getAnnotationMirror(AnnotationValue value) {
        return (AnnotationMirror)AnnotationMirrorVisitor.INSTANCE.visit(value);
    }

    public static VariableElement getEnum(AnnotationValue value) {
        return (VariableElement)EnumVisitor.INSTANCE.visit(value);
    }

    private static <T> T valueOfType(AnnotationValue annotationValue, Class<T> type) {
        Object value = annotationValue.getValue();
        if (!type.isInstance(value)) {
            String string = type.getSimpleName();
            String string2 = String.valueOf(value);
            throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Expected ").append(string).append(", got instead: ").append(string2).toString());
        }
        return type.cast(value);
    }

    public static String getString(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, String.class);
    }

    public static int getInt(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Integer.class);
    }

    public static long getLong(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Long.class);
    }

    public static byte getByte(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Byte.class);
    }

    public static short getShort(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Short.class);
    }

    public static float getFloat(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Float.class).floatValue();
    }

    public static double getDouble(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Double.class);
    }

    public static boolean getBoolean(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Boolean.class);
    }

    public static char getChar(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, Character.class).charValue();
    }

    public static ImmutableList<DeclaredType> getTypeMirrors(AnnotationValue value) {
        return (ImmutableList)TYPE_MIRRORS_VISITOR.visit(value);
    }

    public static ImmutableList<AnnotationMirror> getAnnotationMirrors(AnnotationValue value) {
        return (ImmutableList)ANNOTATION_MIRRORS_VISITOR.visit(value);
    }

    public static ImmutableList<VariableElement> getEnums(AnnotationValue value) {
        return (ImmutableList)ENUMS_VISITOR.visit(value);
    }

    public static ImmutableList<String> getStrings(AnnotationValue value) {
        return (ImmutableList)STRINGS_VISITOR.visit(value);
    }

    public static ImmutableList<Integer> getInts(AnnotationValue value) {
        return (ImmutableList)INTS_VISITOR.visit(value);
    }

    public static ImmutableList<Long> getLongs(AnnotationValue value) {
        return (ImmutableList)LONGS_VISITOR.visit(value);
    }

    public static ImmutableList<Byte> getBytes(AnnotationValue value) {
        return (ImmutableList)BYTES_VISITOR.visit(value);
    }

    public static ImmutableList<Short> getShorts(AnnotationValue value) {
        return (ImmutableList)SHORTS_VISITOR.visit(value);
    }

    public static ImmutableList<Float> getFloats(AnnotationValue value) {
        return (ImmutableList)FLOATS_VISITOR.visit(value);
    }

    public static ImmutableList<Double> getDoubles(AnnotationValue value) {
        return (ImmutableList)DOUBLES_VISITOR.visit(value);
    }

    public static ImmutableList<Boolean> getBooleans(AnnotationValue value) {
        return (ImmutableList)BOOLEANS_VISITOR.visit(value);
    }

    public static ImmutableList<Character> getChars(AnnotationValue value) {
        return (ImmutableList)CHARS_VISITOR.visit(value);
    }

    public static ImmutableList<AnnotationValue> getAnnotationValues(AnnotationValue value) {
        return (ImmutableList)ANNOTATION_VALUES_VISITOR.visit(value);
    }

    public static String toString(AnnotationValue annotationValue) {
        return AnnotationOutput.toString(annotationValue);
    }

    private AnnotationValues() {
    }

    private static final class ArrayVisitor<T>
    extends SimpleAnnotationValueVisitor8<ImmutableList<T>, Void> {
        final Function<AnnotationValue, T> visitT;

        ArrayVisitor(Function<AnnotationValue, T> visitT) {
            this.visitT = (Function)Preconditions.checkNotNull(visitT);
        }

        @Override
        public ImmutableList<T> defaultAction(Object o, Void unused) {
            String string = String.valueOf(o);
            throw new IllegalStateException(new StringBuilder(32 + String.valueOf(string).length()).append("Expected an array, got instead: ").append(string).toString());
        }

        @Override
        public ImmutableList<T> visitArray(List<? extends AnnotationValue> values, Void unused) {
            return values.stream().map(this.visitT).collect(MoreStreams.toImmutableList());
        }
    }

    private static final class EnumVisitor
    extends DefaultVisitor<VariableElement> {
        static final EnumVisitor INSTANCE = new EnumVisitor();

        EnumVisitor() {
            super(VariableElement.class);
        }

        @Override
        public VariableElement visitEnumConstant(VariableElement value, Void unused) {
            return value;
        }
    }

    private static final class AnnotationMirrorVisitor
    extends DefaultVisitor<AnnotationMirror> {
        static final AnnotationMirrorVisitor INSTANCE = new AnnotationMirrorVisitor();

        AnnotationMirrorVisitor() {
            super(AnnotationMirror.class);
        }

        @Override
        public AnnotationMirror visitAnnotation(AnnotationMirror value, Void unused) {
            return value;
        }
    }

    private static final class TypeMirrorVisitor
    extends DefaultVisitor<DeclaredType> {
        static final TypeMirrorVisitor INSTANCE = new TypeMirrorVisitor();

        TypeMirrorVisitor() {
            super(DeclaredType.class);
        }

        @Override
        public DeclaredType visitType(TypeMirror value, Void unused) {
            return MoreTypes.asDeclared(value);
        }
    }

    private static class DefaultVisitor<T>
    extends SimpleAnnotationValueVisitor8<T, Void> {
        final Class<T> clazz;

        DefaultVisitor(Class<T> clazz) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz);
        }

        @Override
        public T defaultAction(Object o, Void unused) {
            String string = this.clazz.getSimpleName();
            String string2 = String.valueOf(o);
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Expected a ").append(string).append(", got instead: ").append(string2).toString());
        }
    }
}

