/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.common.collect.Lists;
import com.google.errorprone.annotations.FormatMethod;
import dagger.spi.model.BindingGraph;
import javax.tools.Diagnostic;

public abstract class DiagnosticReporter {
    public abstract void reportComponent(Diagnostic.Kind var1, BindingGraph.ComponentNode var2, String var3);

    @FormatMethod
    public final void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat, Object firstArg, Object ... moreArgs) {
        this.reportComponent(diagnosticKind, componentNode, this.formatMessage(messageFormat, firstArg, moreArgs));
    }

    public abstract void reportBinding(Diagnostic.Kind var1, BindingGraph.MaybeBinding var2, String var3);

    @FormatMethod
    public final void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String messageFormat, Object firstArg, Object ... moreArgs) {
        this.reportBinding(diagnosticKind, binding, this.formatMessage(messageFormat, firstArg, moreArgs));
    }

    public abstract void reportDependency(Diagnostic.Kind var1, BindingGraph.DependencyEdge var2, String var3);

    @FormatMethod
    public final void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
        this.reportDependency(diagnosticKind, dependencyEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
    }

    public abstract void reportSubcomponentFactoryMethod(Diagnostic.Kind var1, BindingGraph.ChildFactoryMethodEdge var2, String var3);

    @FormatMethod
    public final void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
        this.reportSubcomponentFactoryMethod(diagnosticKind, childFactoryMethodEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
    }

    private String formatMessage(String messageFormat, Object firstArg, Object[] moreArgs) {
        return String.format(messageFormat, Lists.asList((Object)firstArg, (Object[])moreArgs).toArray());
    }
}

