/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.spi.shaded.androidx.room.compiler.processing.XArrayType;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorType;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class XTypes {
    private static final Equivalence<XType> XTYPE_EQUIVALENCE = new Equivalence<XType>(){

        protected boolean doEquivalent(XType left, XType right) {
            return left.getTypeName().equals((Object)right.getTypeName());
        }

        protected int doHash(XType type2) {
            return type2.getTypeName().hashCode();
        }

        public String toString() {
            return "XTypes.equivalence()";
        }
    };

    public static Equivalence<XType> equivalence() {
        return XTYPE_EQUIVALENCE;
    }

    public static XType getEnclosingType(XType type2) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type2));
        XProcessingEnv.Backend backend = XConverters.getProcessingEnv(type2).getBackend();
        switch (backend) {
            case JAVAC: {
                return XConverters.toXProcessing(MoreTypes.asDeclared(XConverters.toJavac(type2)).getEnclosingType(), XConverters.getProcessingEnv(type2));
            }
            case KSP: {
                XTypeElement enclosingTypeElement2 = type2.getTypeElement().getEnclosingTypeElement();
                return enclosingTypeElement2 == null ? null : enclosingTypeElement2.getType();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)backend)));
    }

    public static boolean isAssignableTo(XType type1, XType type2) {
        return type2.isAssignableFrom(type1);
    }

    public static boolean isSubtype(XType type1, XType type2) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv(type1);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toJavac(processingEnv).getTypeUtils().isSubtype(XConverters.toJavac(type1), XConverters.toJavac(type2));
            }
            case KSP: {
                if (XTypes.isPrimitive(type1) || XTypes.isPrimitive(type2)) {
                    return type1.isSameType(type2);
                }
                return XTypes.isAssignableTo(type1, type2);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    public static TypeName erasedTypeName(XType type2) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv(type2);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toXProcessing(XConverters.toJavac(processingEnv).getTypeUtils().erasure(XConverters.toJavac(type2)), processingEnv).getTypeName();
            }
            case KSP: {
                return XTypes.erasedTypeName(type2.getTypeName());
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    private static TypeName erasedTypeName(TypeName typeName2) {
        if (typeName2 instanceof ArrayTypeName) {
            return ArrayTypeName.of((TypeName)XTypes.erasedTypeName(((ArrayTypeName)typeName2).componentType));
        }
        if (typeName2 instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName2).rawType;
        }
        if (typeName2 instanceof TypeVariableName) {
            return XTypes.erasedTypeName((TypeName)((TypeVariableName)typeName2).bounds.get(0));
        }
        return typeName2;
    }

    public static void checkTypePresent(XType type2) {
        if (XTypeKt.isArray(type2)) {
            XTypes.checkTypePresent(XTypes.asArray(type2).getComponentType());
        } else if (XTypes.isDeclared(type2)) {
            type2.getTypeArguments().forEach(XTypes::checkTypePresent);
        } else if (type2.isError()) {
            throw new TypeNotPresentException(type2.toString(), null);
        }
    }

    public static boolean isRawParameterizedType(XType type2) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv(type2);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XTypes.isDeclared(type2) && type2.getTypeArguments().isEmpty() && !type2.getTypeElement().getType().getTypeArguments().isEmpty();
            }
            case KSP: {
                return XTypes.isDeclared(type2) && type2.getRawType() != null && type2.getTypeName().equals((Object)type2.getRawType().getTypeName()) && !type2.getTypeElement().getType().getTypeArguments().isEmpty();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    public static XArrayType asArray(XType type2) {
        return (XArrayType)type2;
    }

    public static boolean isTypeOf(XType type2, ClassName className2) {
        return XTypes.isDeclared(type2) && type2.getTypeElement().getClassName().equals((Object)className2);
    }

    public static boolean isNullType(XType type2) {
        XProcessingEnv.Backend backend = XConverters.getProcessingEnv(type2).getBackend();
        switch (backend) {
            case JAVAC: {
                return XConverters.toJavac(type2).getKind().equals((Object)TypeKind.NULL);
            }
            case KSP: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)backend)));
    }

    public static boolean isNoType(XType type2) {
        return type2.isNone() || XTypeKt.isVoid(type2);
    }

    public static boolean isWildcard(XType type2) {
        XProcessingEnv.Backend backend = XConverters.getProcessingEnv(type2).getBackend();
        switch (backend) {
            case JAVAC: {
                return XConverters.toJavac(type2).getKind().equals((Object)TypeKind.WILDCARD);
            }
            case KSP: {
                return type2.getTypeName() instanceof WildcardTypeName;
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)backend)));
    }

    public static boolean isDeclared(XType type2) {
        return !XTypes.isWildcard(type2) && !XTypeKt.isArray(type2) && type2.getTypeElement() != null;
    }

    public static boolean isTypeVariable(XType type2) {
        return type2.getTypeName() instanceof TypeVariableName;
    }

    public static boolean areEquivalentTypes(XType type1, XType type2) {
        return type1.getTypeName().equals((Object)type2.getTypeName());
    }

    public static boolean isPrimitive(XType type2) {
        return type2.getTypeName().isPrimitive();
    }

    public static boolean hasTypeParameters(XType type2) {
        return !type2.getTypeArguments().isEmpty();
    }

    public static boolean isExecutable(XType type2) {
        return type2 instanceof XExecutableType;
    }

    public static boolean isMethod(XExecutableType type2) {
        return type2 instanceof XMethodType;
    }

    public static boolean isConstructor(XExecutableType type2) {
        return type2 instanceof XConstructorType;
    }

    public static boolean isFloat(XType type2) {
        return type2.getTypeName().equals((Object)TypeName.FLOAT) || type2.getTypeName().equals((Object)KnownTypeNames.BOXED_FLOAT);
    }

    public static boolean isShort(XType type2) {
        return type2.getTypeName().equals((Object)TypeName.SHORT) || type2.getTypeName().equals((Object)KnownTypeNames.BOXED_SHORT);
    }

    public static boolean isChar(XType type2) {
        return type2.getTypeName().equals((Object)TypeName.CHAR) || type2.getTypeName().equals((Object)KnownTypeNames.BOXED_CHAR);
    }

    public static boolean isDouble(XType type2) {
        return type2.getTypeName().equals((Object)TypeName.DOUBLE) || type2.getTypeName().equals((Object)KnownTypeNames.BOXED_DOUBLE);
    }

    public static boolean isBoolean(XType type2) {
        return type2.getTypeName().equals((Object)TypeName.BOOLEAN) || type2.getTypeName().equals((Object)KnownTypeNames.BOXED_BOOLEAN);
    }

    public static Optional<XType> nonObjectSuperclass(XType type2) {
        return XTypes.isDeclared(type2) ? type2.getSuperTypes().stream().filter(supertype -> !supertype.getTypeName().equals((Object)TypeName.OBJECT)).filter(supertype -> XTypes.isDeclared(supertype) && supertype.getTypeElement().isClass()).collect(DaggerCollectors.toOptional()) : Optional.empty();
    }

    public static XType unwrapType(XType type2) {
        XType unwrapped = XTypes.unwrapTypeOrDefault(type2, null);
        Preconditions.checkArgument((unwrapped != null ? 1 : 0) != 0, (String)"%s is a raw type", (Object)type2);
        return unwrapped;
    }

    private static XType unwrapTypeOrDefault(XType type2, XType defaultType) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type2));
        XTypeElement typeElement2 = type2.getTypeElement();
        Preconditions.checkArgument((typeElement2.getType().getTypeArguments().size() == 1 ? 1 : 0) != 0, (String)"%s does not have exactly 1 type parameter. Found: %s", (Object)typeElement2.getQualifiedName(), typeElement2.getType().getTypeArguments());
        return (XType)Iterables.getOnlyElement(type2.getTypeArguments(), (Object)defaultType);
    }

    public static String toStableString(XType type2) {
        try {
            return XTypes.toStableString(type2.getTypeName());
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    private static String toStableString(TypeName typeName2) {
        if (typeName2 instanceof ClassName) {
            return ((ClassName)typeName2).canonicalName();
        }
        if (typeName2 instanceof ArrayTypeName) {
            return String.format("%s[]", XTypes.toStableString(((ArrayTypeName)typeName2).componentType));
        }
        if (typeName2 instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName2;
            return String.format("%s<%s>", parameterizedTypeName.rawType, parameterizedTypeName.typeArguments.stream().map(XTypes::toStableString).collect(Collectors.joining(",")));
        }
        if (typeName2 instanceof WildcardTypeName) {
            WildcardTypeName wildcardTypeName = (WildcardTypeName)typeName2;
            TypeName upperBound = (TypeName)Iterables.getOnlyElement((Iterable)wildcardTypeName.upperBounds);
            if (!upperBound.equals((Object)TypeName.OBJECT)) {
                Preconditions.checkState((boolean)wildcardTypeName.lowerBounds.isEmpty());
                return String.format("? extends %s", XTypes.toStableString(upperBound));
            }
            if (!wildcardTypeName.lowerBounds.isEmpty()) {
                TypeName lowerBound = (TypeName)Iterables.getOnlyElement((Iterable)wildcardTypeName.lowerBounds);
                return String.format("? super %s", XTypes.toStableString(lowerBound));
            }
            return "?";
        }
        if (typeName2 instanceof TypeVariableName) {
            return ((TypeVariableName)typeName2).name;
        }
        return typeName2.toString();
    }

    public static String getKindName(XType type2) {
        if (XTypeKt.isArray(type2)) {
            return "ARRAY";
        }
        if (XTypes.isWildcard(type2)) {
            return "WILDCARD";
        }
        if (XTypes.isTypeVariable(type2)) {
            return "TYPEVAR";
        }
        if (XTypeKt.isVoid(type2)) {
            return "VOID";
        }
        if (XTypes.isNullType(type2)) {
            return "NULL";
        }
        if (XTypes.isNoType(type2)) {
            return "NONE";
        }
        if (XTypes.isPrimitive(type2)) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, type2.getTypeName().toString());
        }
        if (type2.isError()) {
            return "ERROR";
        }
        if (XTypes.isDeclared(type2)) {
            return "DECLARED";
        }
        return "UNKNOWN";
    }

    public static void resolveIfNeeded(XType type2) {
        if (XConverters.getProcessingEnv(type2).getBackend() == XProcessingEnv.Backend.JAVAC) {
            XConverters.toJavac(type2).accept(TypeResolutionVisitor.INSTANCE, new HashSet());
        }
    }

    private XTypes() {
    }

    private static final class TypeResolutionVisitor
    extends SimpleTypeVisitor8<Void, Set<Element>> {
        static final TypeResolutionVisitor INSTANCE = new TypeResolutionVisitor();

        private TypeResolutionVisitor() {
        }

        @Override
        public Void visitDeclared(DeclaredType t, Set<Element> visited) {
            if (!visited.add(t.asElement())) {
                return null;
            }
            if (MoreElements.asType(t.asElement()).getQualifiedName().toString().contains("$")) {
                t.asElement().getKind();
            }
            t.getTypeArguments().forEach(arg -> arg.accept(this, visited));
            return null;
        }

        @Override
        public Void visitError(ErrorType t, Set<Element> visited) {
            this.visitDeclared((DeclaredType)t, visited);
            return null;
        }

        @Override
        public Void visitArray(ArrayType t, Set<Element> visited) {
            t.getComponentType().accept(this, visited);
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, Set<Element> visited) {
            if (t.getExtendsBound() != null) {
                t.getExtendsBound().accept(this, visited);
            }
            if (t.getSuperBound() != null) {
                t.getSuperBound().accept(this, visited);
            }
            return null;
        }

        @Override
        protected Void defaultAction(TypeMirror e, Set<Element> visited) {
            return null;
        }
    }

    private static class KnownTypeNames {
        static final TypeName BOXED_SHORT = TypeName.SHORT.box();
        static final TypeName BOXED_DOUBLE = TypeName.DOUBLE.box();
        static final TypeName BOXED_FLOAT = TypeName.FLOAT.box();
        static final TypeName BOXED_CHAR = TypeName.CHAR.box();
        static final TypeName BOXED_BOOLEAN = TypeName.BOOLEAN.box();

        private KnownTypeNames() {
        }
    }
}

