/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XArrayType;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XEnumEntry;
import dagger.spi.shaded.androidx.room.compiler.processing.XEnumTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class XElements {
    private static final SimpleTypeVisitor8<String, Void> JVM_DESCRIPTOR_TYPE_VISITOR = new SimpleTypeVisitor8<String, Void>(){

        @Override
        public String visitArray(ArrayType arrayType, Void v) {
            return "[" + XElements.javacGetDescriptor(arrayType.getComponentType());
        }

        @Override
        public String visitDeclared(DeclaredType declaredType, Void v) {
            return "L" + this.getInternalName(declaredType.asElement()) + ";";
        }

        @Override
        public String visitError(ErrorType errorType, Void v) {
            return this.visitDeclared((DeclaredType)errorType, v);
        }

        @Override
        public String visitExecutable(ExecutableType executableType2, Void v) {
            String parameterDescriptors2 = executableType2.getParameterTypes().stream().map(x$0 -> XElements.javacGetDescriptor(x$0)).collect(Collectors.joining());
            String returnDescriptor = XElements.javacGetDescriptor(executableType2.getReturnType());
            return "(" + parameterDescriptors2 + ")" + returnDescriptor;
        }

        @Override
        public String visitIntersection(IntersectionType intersectionType, Void v) {
            return XElements.javacGetDescriptor(intersectionType.getBounds().get(0));
        }

        @Override
        public String visitNoType(NoType noType, Void v) {
            return "V";
        }

        @Override
        public String visitPrimitive(PrimitiveType primitiveType, Void v) {
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case SHORT: {
                    return "S";
                }
                case INT: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case CHAR: {
                    return "C";
                }
                case FLOAT: {
                    return "F";
                }
                case DOUBLE: {
                    return "D";
                }
            }
            throw new IllegalArgumentException("Unknown primitive type.");
        }

        @Override
        public String visitTypeVariable(TypeVariable typeVariable, Void v) {
            return XElements.javacGetDescriptor(typeVariable.getUpperBound());
        }

        @Override
        public String defaultAction(TypeMirror typeMirror, Void v) {
            throw new IllegalArgumentException("Unsupported type: " + typeMirror);
        }

        @Override
        public String visitWildcard(WildcardType wildcardType, Void v) {
            return "";
        }

        private String getInternalName(Element element) {
            try {
                TypeElement typeElement2 = MoreElements.asType(element);
                switch (typeElement2.getNestingKind()) {
                    case TOP_LEVEL: {
                        return typeElement2.getQualifiedName().toString().replace('.', '/');
                    }
                    case MEMBER: {
                        return this.getInternalName(typeElement2.getEnclosingElement()) + "$" + typeElement2.getSimpleName();
                    }
                }
                throw new IllegalArgumentException("Unsupported nesting kind.");
            }
            catch (IllegalArgumentException typeElement2) {
                if (element instanceof QualifiedNameable) {
                    QualifiedNameable qualifiedNameElement = (QualifiedNameable)element;
                    return qualifiedNameElement.getQualifiedName().toString().replace('.', '/');
                }
                return element.getSimpleName().toString();
            }
        }
    };

    public static String getSimpleName(XMemberContainer memberContainer) {
        return memberContainer.getClassName().simpleName();
    }

    public static String getSimpleName(XElement element) {
        if (XElementKt.isTypeElement(element)) {
            return XElements.asTypeElement(element).getName();
        }
        if (XElementKt.isVariableElement(element)) {
            return XElements.asVariable(element).getName();
        }
        if (XElements.isEnumEntry(element)) {
            return XElements.asEnumEntry(element).getName();
        }
        if (XElementKt.isMethod(element)) {
            return XElements.asMethod(element).getJvmName();
        }
        if (XElementKt.isConstructor(element)) {
            return "<init>";
        }
        if (XElements.isTypeParameter(element)) {
            return XElements.asTypeParameter(element).getName();
        }
        throw new AssertionError((Object)("No simple name for: " + element));
    }

    public static XTypeElement closestEnclosingTypeElement(XElement element) {
        return XElements.optionalClosestEnclosingTypeElement(element).orElseThrow(() -> new IllegalStateException("No enclosing TypeElement for: " + element));
    }

    public static boolean transitivelyEncloses(XElement encloser, XElement enclosed) {
        for (XElement current = enclosed; current != null; current = current.getEnclosingElement()) {
            if (!current.equals(encloser)) continue;
            return true;
        }
        return false;
    }

    private static Optional<XTypeElement> optionalClosestEnclosingTypeElement(XElement element) {
        if (XElementKt.isTypeElement(element)) {
            return Optional.of(XElements.asTypeElement(element));
        }
        if (XElementKt.isConstructor(element)) {
            return Optional.of(XElements.asConstructor(element).getEnclosingElement());
        }
        if (XElementKt.isMethod(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asMethod(element).getEnclosingElement());
        }
        if (XElementKt.isField(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asField(element).getEnclosingElement());
        }
        if (XElementKt.isMethodParameter(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asMethodParameter(element).getEnclosingElement());
        }
        return Optional.empty();
    }

    public static boolean isAbstract(XElement element) {
        return XElements.asHasModifiers(element).isAbstract();
    }

    public static boolean isPublic(XElement element) {
        return XElements.asHasModifiers(element).isPublic();
    }

    public static boolean isPrivate(XElement element) {
        return XElements.asHasModifiers(element).isPrivate();
    }

    public static boolean isStatic(XElement element) {
        return XElements.asHasModifiers(element).isStatic();
    }

    private static XHasModifiers asHasModifiers(XElement element) {
        Preconditions.checkArgument((boolean)(element instanceof XHasModifiers), (String)"Element %s does not have modifiers", (Object)element);
        return (XHasModifiers)((Object)element);
    }

    public static boolean isPackage(XElement element) {
        if (XConverters.getProcessingEnv(element).getBackend() == XProcessingEnv.Backend.JAVAC) {
            Preconditions.checkState((XConverters.toJavac(element).getKind() != ElementKind.PACKAGE ? 1 : 0) != 0);
        }
        return false;
    }

    public static boolean isTypeParameter(XElement element) {
        return element instanceof XTypeParameterElement;
    }

    public static XTypeParameterElement asTypeParameter(XElement element) {
        return (XTypeParameterElement)element;
    }

    public static boolean isEnumEntry(XElement element) {
        return element instanceof XEnumEntry;
    }

    public static boolean isEnum(XElement element) {
        return element instanceof XEnumTypeElement;
    }

    public static boolean isExecutable(XElement element) {
        return XElementKt.isConstructor(element) || XElementKt.isMethod(element);
    }

    public static XExecutableElement asExecutable(XElement element) {
        Preconditions.checkState((boolean)XElements.isExecutable(element));
        return (XExecutableElement)element;
    }

    public static XTypeElement asTypeElement(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isTypeElement(element));
        return (XTypeElement)element;
    }

    public static XExecutableParameterElement asMethodParameter(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethodParameter(element));
        return (XExecutableParameterElement)element;
    }

    public static XFieldElement asField(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isField(element));
        return (XFieldElement)element;
    }

    public static XEnumEntry asEnumEntry(XElement element) {
        return (XEnumEntry)element;
    }

    public static XVariableElement asVariable(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isVariableElement(element));
        return (XVariableElement)element;
    }

    public static XConstructorElement asConstructor(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isConstructor(element));
        return (XConstructorElement)element;
    }

    public static XMethodElement asMethod(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethod(element));
        return (XMethodElement)element;
    }

    public static ImmutableSet<XAnnotation> getAnnotatedAnnotations(XAnnotated annotated, ClassName annotationName) {
        return annotated.getAllAnnotations().stream().filter(annotation -> annotation.getType().getTypeElement().hasAnnotation(annotationName)).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, ClassName ... annotations2) {
        return XElements.hasAnyAnnotation(annotated, (Collection<ClassName>)ImmutableSet.copyOf((Object[])annotations2));
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().anyMatch(annotated::hasAnnotation);
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, ClassName ... annotations2) {
        return XElements.getAnyAnnotation(annotated, (Collection<ClassName>)ImmutableSet.copyOf((Object[])annotations2));
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().filter(annotated::hasAnnotation).map(annotated::getAnnotation).findFirst();
    }

    public static ImmutableSet<XAnnotation> getAllAnnotations(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().filter(annotated::hasAnnotation).map(annotated::getAnnotation).collect(DaggerStreams.toImmutableSet());
    }

    public static String getFieldDescriptor(XFieldElement element) {
        return XElements.getSimpleName(element) + ":" + XElements.getDescriptor(element.getType());
    }

    public static String getMethodDescriptor(XMethodElement element) {
        return XElements.getSimpleName(element) + XElements.getDescriptor(element.getExecutableType());
    }

    private static String getDescriptor(XExecutableType type2) {
        String parameterDescriptors2 = type2.getParameterTypes().stream().map(XElements::getDescriptor).collect(Collectors.joining());
        String returnDescriptor = XTypes.isMethod(type2) ? XElements.getDescriptor(((XMethodType)type2).getReturnType()) : "V";
        return "(" + parameterDescriptors2 + ")" + returnDescriptor;
    }

    private static String getDescriptor(XType type2) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv(type2);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XElements.javacGetDescriptor(XConverters.toJavac(type2));
            }
            case KSP: {
                return XElements.kspGetDescriptor(type2);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    private static String kspGetDescriptor(XType type2) {
        if (XTypeKt.isKotlinUnit(type2) || type2.isNone() || XTypeKt.isVoid(type2) || XTypeKt.isVoidObject(type2)) {
            return "V";
        }
        if (XTypeKt.isArray(type2)) {
            XArrayType arrayType = (XArrayType)type2;
            return "[" + XElements.getDescriptor(arrayType.getComponentType());
        }
        if (XTypes.isDeclared(type2) || type2.isError()) {
            return "L" + XElements.getInternalName(type2.getTypeElement()) + ";";
        }
        if (XTypes.isExecutable(type2)) {
            return XElements.getDescriptor((XExecutableType)((Object)type2));
        }
        if (XTypes.isTypeVariable(type2)) {
            throw new AssertionError((Object)("Generic type is currently unsupported: " + type2));
        }
        if (XTypeKt.isInt(type2)) {
            return "I";
        }
        if (XTypeKt.isLong(type2)) {
            return "J";
        }
        if (XTypeKt.isByte(type2)) {
            return "B";
        }
        if (XTypes.isShort(type2)) {
            return "S";
        }
        if (XTypes.isDouble(type2)) {
            return "D";
        }
        if (XTypes.isFloat(type2)) {
            return "F";
        }
        if (XTypes.isBoolean(type2)) {
            return "Z";
        }
        if (XTypes.isChar(type2)) {
            return "C";
        }
        if (XTypes.isWildcard(type2)) {
            return "";
        }
        throw new AssertionError((Object)("Unexpected type: " + type2));
    }

    private static String getInternalName(XTypeElement element) {
        if (XTypeElements.isNested(element)) {
            return XElements.getInternalName(element.getEnclosingTypeElement()) + "$" + XElements.getSimpleName(element);
        }
        return element.getQualifiedName().replace('.', '/');
    }

    private static String javacGetDescriptor(TypeMirror type2) {
        return type2.accept(JVM_DESCRIPTOR_TYPE_VISITOR, null);
    }

    public static String toStableString(XElement element) {
        try {
            if (XElementKt.isTypeElement(element)) {
                return XElements.asTypeElement(element).getQualifiedName();
            }
            if (XElements.isExecutable(element)) {
                XExecutableElement executable = XElements.asExecutable(element);
                return String.format("%s(%s)", XElements.getSimpleName((XElement)((Object)(XElementKt.isConstructor(element) ? XElements.asConstructor(element).getEnclosingElement() : executable))), executable.getParameters().stream().map(XVariableElement::getType).map(XTypes::toStableString).collect(Collectors.joining(",")));
            }
            if (XElements.isEnumEntry(element) || XElementKt.isField(element) || XElementKt.isMethodParameter(element) || XElements.isTypeParameter(element)) {
                return XElements.getSimpleName(element);
            }
            return element.toString();
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    public static String getKindName(XElement element) {
        if (XElementKt.isTypeElement(element)) {
            XTypeElement typeElement2 = XElements.asTypeElement(element);
            if (typeElement2.isClass()) {
                return "CLASS";
            }
            if (typeElement2.isInterface()) {
                return "INTERFACE";
            }
            if (typeElement2.isAnnotationClass()) {
                return "ANNOTATION_TYPE";
            }
        } else {
            if (XElements.isEnum(element)) {
                return "ENUM";
            }
            if (XElements.isEnumEntry(element)) {
                return "ENUM_CONSTANT";
            }
            if (XElementKt.isConstructor(element)) {
                return "CONSTRUCTOR";
            }
            if (XElementKt.isMethod(element)) {
                return "METHOD";
            }
            if (XElementKt.isField(element)) {
                return "FIELD";
            }
            if (XElementKt.isMethodParameter(element)) {
                return "PARAMETER";
            }
            if (XElements.isTypeParameter(element)) {
                return "TYPE_PARAMETER";
            }
        }
        return element.kindName();
    }

    private XElements() {
    }
}

