/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.spi.shaded.androidx.room.compiler.processing.XArrayType;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.type.TypeKind;

public final class XTypes {
    private static final Equivalence<XType> XTYPE_EQUIVALENCE = new Equivalence<XType>(){

        protected boolean doEquivalent(XType left, XType right) {
            return left.getTypeName().equals((Object)right.getTypeName());
        }

        protected int doHash(XType type2) {
            return type2.getTypeName().hashCode();
        }

        public String toString() {
            return "XTypes.equivalence()";
        }
    };

    public static Equivalence<XType> equivalence() {
        return XTYPE_EQUIVALENCE;
    }

    public static XType getEnclosingType(XType type2) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type2));
        XProcessingEnv.Backend backend = XConverters.getProcessingEnv(type2).getBackend();
        switch (backend) {
            case JAVAC: {
                return XConverters.toXProcessing(MoreTypes.asDeclared(XConverters.toJavac(type2)).getEnclosingType(), XConverters.getProcessingEnv(type2));
            }
            case KSP: {
                XTypeElement enclosingTypeElement2 = type2.getTypeElement().getEnclosingTypeElement();
                return enclosingTypeElement2 == null ? null : enclosingTypeElement2.getType();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)backend)));
    }

    public static boolean isAssignableTo(XType type1, XType type2) {
        return type2.isAssignableFrom(type1);
    }

    public static void checkTypePresent(XType type2) {
        if (XTypeKt.isArray(type2)) {
            XTypes.checkTypePresent(XTypes.asArray(type2).getComponentType());
        } else if (XTypes.isDeclared(type2)) {
            type2.getTypeArguments().forEach(XTypes::checkTypePresent);
        } else if (type2.isError()) {
            throw new TypeNotPresentException(type2.toString(), null);
        }
    }

    public static boolean isRawParameterizedType(XType type2) {
        return XTypes.isDeclared(type2) && type2.getTypeArguments().isEmpty() && !type2.getTypeElement().getType().getTypeArguments().isEmpty();
    }

    public static XArrayType asArray(XType type2) {
        return (XArrayType)type2;
    }

    public static boolean isTypeOf(XType type2, ClassName className2) {
        return XTypes.isDeclared(type2) && type2.getTypeElement().getClassName().equals((Object)className2);
    }

    public static boolean isNullType(XType type2) {
        XProcessingEnv.Backend backend = XConverters.getProcessingEnv(type2).getBackend();
        switch (backend) {
            case JAVAC: {
                return XConverters.toJavac(type2).getKind().equals((Object)TypeKind.NULL);
            }
            case KSP: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)backend)));
    }

    public static boolean isNoType(XType type2) {
        return type2.isNone() || XTypeKt.isVoid(type2);
    }

    public static boolean isWildcard(XType type2) {
        return type2.getTypeName() instanceof WildcardTypeName;
    }

    public static boolean isDeclared(XType type2) {
        return type2.getTypeElement() != null;
    }

    public static boolean isTypeVariable(XType type2) {
        return type2.getTypeName() instanceof TypeVariableName;
    }

    public static boolean areEquivalentTypes(XType type1, XType type2) {
        return type1.getTypeName().equals((Object)type2.getTypeName());
    }

    public static boolean isPrimitive(XType type2) {
        return type2.getTypeName().isPrimitive();
    }

    public static boolean hasTypeParameters(XType type2) {
        return !type2.getTypeArguments().isEmpty();
    }

    public static Optional<XType> nonObjectSuperclass(XType type2) {
        return XTypes.isDeclared(type2) ? type2.getSuperTypes().stream().filter(supertype -> !supertype.getTypeName().equals((Object)TypeName.OBJECT)).filter(supertype -> XTypes.isDeclared(supertype) && supertype.getTypeElement().isClass()).collect(DaggerCollectors.toOptional()) : Optional.empty();
    }

    public static XType unwrapType(XType type2) {
        XType unwrapped = XTypes.unwrapTypeOrDefault(type2, null);
        Preconditions.checkArgument((unwrapped != null ? 1 : 0) != 0, (String)"%s is a raw type", (Object)type2);
        return unwrapped;
    }

    private static XType unwrapTypeOrDefault(XType type2, XType defaultType) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type2));
        XTypeElement typeElement2 = type2.getTypeElement();
        Preconditions.checkArgument((typeElement2.getType().getTypeArguments().size() == 1 ? 1 : 0) != 0, (String)"%s does not have exactly 1 type parameter. Found: %s", (Object)typeElement2.getQualifiedName(), typeElement2.getType().getTypeArguments());
        return (XType)Iterables.getOnlyElement(type2.getTypeArguments(), (Object)defaultType);
    }

    private XTypes() {
    }
}

