/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.squareup.javapoet.ClassName;
import dagger.spi.model.AutoValue_DaggerAnnotation;
import dagger.spi.model.CompilerEnvironment;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import dagger.spi.shaded.auto.common.MoreTypes;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;

@AutoValue
public abstract class DaggerAnnotation {
    public static DaggerAnnotation fromJava(AnnotationMirror annotationMirror) {
        return new AutoValue_DaggerAnnotation(CompilerEnvironment.JAVA, (Equivalence.Wrapper<AnnotationMirror>)AnnotationMirrors.equivalence().wrap((Object)((AnnotationMirror)Preconditions.checkNotNull((Object)annotationMirror))), null);
    }

    public static DaggerAnnotation fromKsp(KSAnnotation ksAnnotation) {
        return new AutoValue_DaggerAnnotation(CompilerEnvironment.KSP, null, (KSAnnotation)Preconditions.checkNotNull((Object)ksAnnotation));
    }

    public DaggerTypeElement annotationTypeElement() {
        return DaggerTypeElement.fromJava(MoreTypes.asTypeElement(((AnnotationMirror)this.annotationMirror().get()).getAnnotationType()));
    }

    public ClassName className() {
        return this.annotationTypeElement().className();
    }

    public AnnotationMirror java() {
        Preconditions.checkState((this.compiler() == CompilerEnvironment.JAVA ? 1 : 0) != 0);
        return (AnnotationMirror)this.annotationMirror().get();
    }

    public KSAnnotation ksp() {
        Preconditions.checkState((this.compiler() == CompilerEnvironment.KSP ? 1 : 0) != 0);
        return this.kspInternal();
    }

    public abstract CompilerEnvironment compiler();

    @Nullable
    abstract Equivalence.Wrapper<AnnotationMirror> annotationMirror();

    @Nullable
    abstract KSAnnotation kspInternal();

    public final String toString() {
        return (this.compiler() == CompilerEnvironment.JAVA ? this.java() : this.ksp()).toString();
    }
}

