/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.Preconditions;
import dagger.internal.Providers;
import dagger.producers.internal.AbstractProducer;
import dagger.producers.monitoring.ProducerMonitor;
import dagger.producers.monitoring.ProducerToken;
import dagger.producers.monitoring.ProductionComponentMonitor;
import java.util.concurrent.Executor;
import javax.inject.Provider;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class AbstractProducesMethodProducer<D, T>
extends AbstractProducer<T>
implements AsyncFunction<D, T>,
Executor {
    private final dagger.internal.Provider<ProductionComponentMonitor> monitorProvider;
    @NullableDecl
    private final ProducerToken token;
    private final dagger.internal.Provider<Executor> executorProvider;
    private volatile ProducerMonitor monitor = null;

    protected AbstractProducesMethodProducer(dagger.internal.Provider<ProductionComponentMonitor> monitorProvider, @NullableDecl ProducerToken token, dagger.internal.Provider<Executor> executorProvider) {
        this.monitorProvider = (dagger.internal.Provider)Preconditions.checkNotNull(monitorProvider);
        this.token = token;
        this.executorProvider = (dagger.internal.Provider)Preconditions.checkNotNull(executorProvider);
    }

    @Deprecated
    protected AbstractProducesMethodProducer(Provider<ProductionComponentMonitor> monitorProvider, @NullableDecl ProducerToken token, Provider<Executor> executorProvider) {
        this((dagger.internal.Provider<ProductionComponentMonitor>)Providers.asDaggerProvider(monitorProvider), token, (dagger.internal.Provider<Executor>)Providers.asDaggerProvider(executorProvider));
    }

    @Override
    protected final ListenableFuture<T> compute() {
        this.monitor = ((ProductionComponentMonitor)this.monitorProvider.get()).producerMonitorFor(this.token);
        this.monitor.requested();
        ListenableFuture result = Futures.transformAsync(this.collectDependencies(), (AsyncFunction)this, (Executor)this);
        this.monitor.addCallbackTo(result);
        return result;
    }

    protected abstract ListenableFuture<D> collectDependencies();

    @Deprecated
    public final ListenableFuture<T> apply(D asyncDependencies) throws Exception {
        this.monitor.methodStarting();
        try {
            ListenableFuture<T> listenableFuture = this.callProducesMethod(asyncDependencies);
            return listenableFuture;
        }
        finally {
            this.monitor.methodFinished();
        }
    }

    protected abstract ListenableFuture<T> callProducesMethod(D var1) throws Exception;

    @Override
    @Deprecated
    public final void execute(Runnable runnable) {
        this.monitor.ready();
        ((Executor)this.executorProvider.get()).execute(runnable);
    }
}

