/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.CancellableProducer;
import dagger.producers.internal.CancellationListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Provider;

public final class Producers {
    private static final Function<Object, Produced<Object>> RESULT_TO_PRODUCED = new Function<Object, Produced<Object>>(){

        public Produced<Object> apply(Object result) {
            return Produced.successful(result);
        }
    };
    private static final AsyncFunction<Throwable, Produced<Object>> FUTURE_FALLBACK_FOR_PRODUCED = new AsyncFunction<Throwable, Produced<Object>>(){

        public ListenableFuture<Produced<Object>> apply(Throwable t) throws Exception {
            Produced produced = Produced.failed(t);
            return Futures.immediateFuture(produced);
        }
    };
    private static final Producer<Map<Object, Object>> EMPTY_MAP_PRODUCER = dagger.producers.Producers.immediateProducer(ImmutableMap.of());

    public static <T> ListenableFuture<Produced<T>> createFutureProduced(ListenableFuture<T> future) {
        return Futures.catchingAsync((ListenableFuture)Futures.transform(future, Producers.resultToProduced(), (Executor)MoreExecutors.directExecutor()), Throwable.class, Producers.futureFallbackForProduced(), (Executor)MoreExecutors.directExecutor());
    }

    private static <T> Function<T, Produced<T>> resultToProduced() {
        return RESULT_TO_PRODUCED;
    }

    private static <T> AsyncFunction<Throwable, Produced<T>> futureFallbackForProduced() {
        return FUTURE_FALLBACK_FOR_PRODUCED;
    }

    public static <T> ListenableFuture<Set<T>> createFutureSingletonSet(ListenableFuture<T> future) {
        return Futures.transform(future, (Function)new Function<T, Set<T>>(){

            public Set<T> apply(T value) {
                return ImmutableSet.of(value);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static <T> ListenableFuture<Set<T>> allAsSet(Iterable<? extends ListenableFuture<? extends T>> futures) {
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), (Function)new Function<List<T>, Set<T>>(){

            public Set<T> apply(List<T> values) {
                return ImmutableSet.copyOf(values);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static <T> Producer<T> producerFromProvider(final Provider<T> provider) {
        Preconditions.checkNotNull(provider);
        return new CompletedProducer<T>(){

            @Override
            public ListenableFuture<T> get() {
                return Futures.immediateFuture((Object)provider.get());
            }
        };
    }

    @Deprecated
    public static <T> Producer<T> immediateProducer(T value) {
        return dagger.producers.Producers.immediateProducer(value);
    }

    @Deprecated
    public static <T> Producer<T> immediateFailedProducer(Throwable throwable) {
        return dagger.producers.Producers.immediateFailedProducer(throwable);
    }

    public static <T> Producer<T> nonCancellationPropagatingViewOf(Producer<T> producer) {
        if (producer instanceof CancellableProducer) {
            return ((CancellableProducer)producer).newDependencyView();
        }
        throw new IllegalArgumentException("nonCancellationPropagatingViewOf called with non-CancellableProducer: " + producer);
    }

    public static <T> Producer<T> entryPointViewOf(Producer<T> producer, CancellationListener cancellationListener) {
        if (producer instanceof CancellableProducer) {
            return ((CancellableProducer)producer).newEntryPointView(cancellationListener);
        }
        throw new IllegalArgumentException("entryPointViewOf called with non-CancellableProducer: " + producer);
    }

    public static void cancel(Producer<?> producer, boolean mayInterruptIfRunning) {
        if (!(producer instanceof CancellableProducer)) {
            throw new IllegalArgumentException("cancel called with non-CancellableProducer: " + producer);
        }
        ((CancellableProducer)producer).cancel(mayInterruptIfRunning);
    }

    public static <K, V> Producer<Map<K, V>> emptyMapProducer() {
        return EMPTY_MAP_PRODUCER;
    }

    private Producers() {
    }

    private static abstract class CompletedProducer<T>
    implements CancellableProducer<T> {
        private CompletedProducer() {
        }

        @Override
        public void cancel(boolean mayInterruptIfRunning) {
        }

        @Override
        public Producer<T> newDependencyView() {
            return this;
        }

        @Override
        public Producer<T> newEntryPointView(CancellationListener cancellationListener) {
            return this;
        }
    }
}

