/*
 * Decompiled with CFR 0.152.
 */
package dagger.lint;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u000e*\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Ldagger/lint/DaggerKotlinIssueDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "isCompanionObject", "", "Lorg/jetbrains/uast/UClass;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "isObject", "Companion", "dagger-lint_main_java_dagger_lint-lint-artifact-lib"})
public final class DaggerKotlinIssueDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation SCOPES;
    @NotNull
    private static final Issue ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT;
    @NotNull
    private static final Issue ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION;
    @NotNull
    private static final Issue ISSUE_MODULE_COMPANION_OBJECTS;
    @NotNull
    private static final Issue ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT;
    @NotNull
    private static final String PROVIDES_ANNOTATION = "dagger.Provides";
    @NotNull
    private static final String JVM_STATIC_ANNOTATION = "kotlin.jvm.JvmStatic";
    @NotNull
    private static final String INJECT_ANNOTATION = "javax.inject.Inject";
    @NotNull
    private static final String QUALIFIER_ANNOTATION = "javax.inject.Qualifier";
    @NotNull
    private static final String MODULE_ANNOTATION = "dagger.Module";
    @NotNull
    private static final List<Issue> issues;

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UMethod.class, UField.class, UClass.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Lint.isKotlin((PsiElement)((PsiElement)context.getPsiFile()))) {
            return null;
        }
        return new UElementHandler(context, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ DaggerKotlinIssueDetector this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void visitField(UField node) {
                void $this$forEach$iv;
                Object v0;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!this.$context.getEvaluator().isLateInit((PsiModifierListOwner)node)) {
                        return;
                    }
                    Iterable iterable = node.getUAnnotations();
                    for (T t : iterable) {
                        UAnnotation it = (UAnnotation)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"javax.inject.Inject")) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                UAnnotation uAnnotation = v0;
                if (uAnnotation == null) {
                    return;
                }
                UAnnotation injectAnnotation = uAnnotation;
                Iterable iterable = node.getUAnnotations();
                JavaContext javaContext = this.$context;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PsiElement sourcePsi;
                    UAnnotation annotation = (UAnnotation)element$iv;
                    boolean bl = false;
                    if (annotation == injectAnnotation || !((sourcePsi = annotation.getSourcePsi()) instanceof KtAnnotationEntry)) continue;
                    KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ((KtAnnotationEntry)sourcePsi).getUseSiteTarget();
                    if ((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) != AnnotationUseSiteTarget.FIELD) continue;
                    PsiClass psiClass = annotation.resolve();
                    boolean bl2 = psiClass != null ? psiClass.hasAnnotation("javax.inject.Qualifier") : false;
                    if (!bl2) continue;
                    javaContext.report(DaggerKotlinIssueDetector.access$getISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION$cp(), javaContext.getLocation((UElement)annotation), DaggerKotlinIssueDetector.access$getISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION$cp().getBriefDescription(TextFormat.TEXT), LintFix.Companion.create().name("Remove 'field:'").replace().text("field:").with("").autoFix().build());
                }
            }

            public void visitMethod(UMethod node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!node.isConstructor() && node.hasAnnotation("dagger.Provides") && node.hasAnnotation("kotlin.jvm.JvmStatic")) {
                    UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)node));
                    if (uElement == null || (uElement = UastUtils.getContainingUClass((UElement)uElement)) == null) {
                        return;
                    }
                    UElement containingClass = uElement;
                    if (DaggerKotlinIssueDetector.access$isObject(this.this$0, (UClass)containingClass)) {
                        UAnnotation uAnnotation = node.findAnnotation("kotlin.jvm.JvmStatic");
                        if (uAnnotation == null) {
                            PsiAnnotation psiAnnotation = node.getJavaPsi().getModifierList().findAnnotation("kotlin.jvm.JvmStatic");
                            uAnnotation = psiAnnotation;
                            Intrinsics.checkNotNull((Object)psiAnnotation);
                        }
                        UAnnotation annotation = uAnnotation;
                        this.$context.report(DaggerKotlinIssueDetector.access$getISSUE_JVM_STATIC_PROVIDES_IN_OBJECT$cp(), Context.getLocation$default((Context)((Context)this.$context), (Object)annotation, null, (int)2, null), DaggerKotlinIssueDetector.access$getISSUE_JVM_STATIC_PROVIDES_IN_OBJECT$cp().getBriefDescription(TextFormat.TEXT), LintFix.Companion.create().name("Remove @JvmStatic").replace().pattern("(@(kotlin\\.jvm\\.)?JvmStatic)").with("").autoFix().build());
                    }
                }
            }

            public void visitClass(UClass node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.hasAnnotation("dagger.Module") && DaggerKotlinIssueDetector.access$isCompanionObject(this.this$0, node, this.$context.getEvaluator())) {
                    UElement uElement = UastContextKt.getUastParentOfType((PsiElement)((PsiElement)node), UClass.class, (boolean)false);
                    Intrinsics.checkNotNull((Object)uElement);
                    UClass parent = (UClass)uElement;
                    if (parent.hasAnnotation("dagger.Module")) {
                        this.$context.report(DaggerKotlinIssueDetector.access$getISSUE_MODULE_COMPANION_OBJECTS$cp(), this.$context.getLocation((UElement)node), DaggerKotlinIssueDetector.access$getISSUE_MODULE_COMPANION_OBJECTS$cp().getBriefDescription(TextFormat.TEXT), LintFix.Companion.create().name("Remove @Module").replace().pattern("(@(dagger\\.)?Module)").with("").autoFix().build());
                    } else {
                        Context.report$default((Context)((Context)this.$context), (Issue)DaggerKotlinIssueDetector.access$getISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT$cp(), (Location)this.$context.getLocation((UElement)node), (String)DaggerKotlinIssueDetector.access$getISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT$cp().getBriefDescription(TextFormat.TEXT), null, (int)8, null);
                    }
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompanionObject(UClass $this$isCompanionObject, JavaEvaluator evaluator) {
        if (!this.isObject($this$isCompanionObject)) return false;
        PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)$this$isCompanionObject;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.COMPANION_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"COMPANION_KEYWORD");
        if (!evaluator.hasModifier(psiModifierListOwner, ktModifierKeywordToken)) return false;
        return true;
    }

    private final boolean isObject(UClass $this$isObject) {
        return $this$isObject.getSourcePsi() instanceof KtObjectDeclaration;
    }

    public static final /* synthetic */ boolean access$isObject(DaggerKotlinIssueDetector $this, UClass $receiver) {
        return $this.isObject($receiver);
    }

    public static final /* synthetic */ Issue access$getISSUE_JVM_STATIC_PROVIDES_IN_OBJECT$cp() {
        return ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT;
    }

    public static final /* synthetic */ boolean access$isCompanionObject(DaggerKotlinIssueDetector $this, UClass $receiver, JavaEvaluator evaluator) {
        return $this.isCompanionObject($receiver, evaluator);
    }

    public static final /* synthetic */ Issue access$getISSUE_MODULE_COMPANION_OBJECTS$cp() {
        return ISSUE_MODULE_COMPANION_OBJECTS;
    }

    public static final /* synthetic */ Issue access$getISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT$cp() {
        return ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT;
    }

    public static final /* synthetic */ Issue access$getISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION$cp() {
        return ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION;
    }

    static {
        Object[] objectArray = new EnumSet[]{EnumSet.of((Enum)Scope.JAVA_FILE), EnumSet.of((Enum)Scope.TEST_SOURCES)};
        SCOPES = new Implementation(DaggerKotlinIssueDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), (EnumSet[])objectArray);
        ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT = Issue.Companion.create("JvmStaticProvidesInObjectDetector", "@JvmStatic used for @Provides function in an object class", "\n        It's redundant to annotate @Provides functions in object classes with @JvmStatic.\n        ", Category.CORRECTNESS, 5, Severity.WARNING, SCOPES);
        ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION = Issue.Companion.create("FieldSiteTargetOnQualifierAnnotation", "Redundant 'field:' used for Dagger qualifier annotation.", "\n        It's redundant to use 'field:' site-targets for qualifier annotations.\n        ", Category.CORRECTNESS, 5, Severity.WARNING, SCOPES);
        ISSUE_MODULE_COMPANION_OBJECTS = Issue.Companion.create("ModuleCompanionObjects", "Module companion objects should not be annotated with @Module.", "\n        Companion objects in @Module-annotated classes are considered part of the API.\n        ", Category.CORRECTNESS, 5, Severity.WARNING, SCOPES);
        ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT = Issue.Companion.create("ModuleCompanionObjectsNotInModuleParent", "Companion objects should not be annotated with @Module.", "\n        Companion objects in @Module-annotated classes are considered part of the API. This\n        companion object is not a companion to an @Module-annotated class though, and should be\n        moved to a top-level object declaration instead otherwise Dagger will ignore companion\n        object.\n        ", Category.CORRECTNESS, 5, Severity.WARNING, SCOPES);
        objectArray = new Issue[]{ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT, ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION, ISSUE_MODULE_COMPANION_OBJECTS, ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT};
        issues = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ldagger/lint/DaggerKotlinIssueDetector$Companion;", "", "<init>", "()V", "SCOPES", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE_JVM_STATIC_PROVIDES_IN_OBJECT", "Lcom/android/tools/lint/detector/api/Issue;", "ISSUE_FIELD_SITE_TARGET_ON_QUALIFIER_ANNOTATION", "ISSUE_MODULE_COMPANION_OBJECTS", "ISSUE_MODULE_COMPANION_OBJECTS_NOT_IN_MODULE_PARENT", "PROVIDES_ANNOTATION", "", "JVM_STATIC_ANNOTATION", "INJECT_ANNOTATION", "QUALIFIER_ANNOTATION", "MODULE_ANNOTATION", "issues", "", "getIssues", "()Ljava/util/List;", "dagger-lint_main_java_dagger_lint-lint-artifact-lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Issue> getIssues() {
            return issues;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

