/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import dagger.Binds;
import dagger.Provides;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.Types;

final class Util {
    static final Function<TypeElement, DeclaredType> AS_DECLARED_TYPE = typeElement -> MoreTypes.asDeclared(typeElement.asType());
    static final ElementVisitor<TypeElement, Void> ENCLOSING_TYPE_ELEMENT = new SimpleElementVisitor6<TypeElement, Void>(){

        @Override
        protected TypeElement defaultAction(Element e, Void p) {
            return (TypeElement)this.visit(e.getEnclosingElement());
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    };
    static final Function<Element, String> ELEMENT_SIMPLE_NAME = element -> element.getSimpleName().toString();

    static boolean requiresAPassedInstance(Elements elements, Types types, TypeElement typeElement) {
        ImmutableSet<ExecutableElement> methods = MoreElements.getLocalAndInheritedMethods(typeElement, types, elements);
        boolean foundInstanceMethod = false;
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.ABSTRACT) && !MoreElements.isAnnotationPresent(method, Binds.class)) {
                return true;
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC) || !Util.isAnyAnnotationPresent(method, Provides.class, Produces.class)) continue;
            foundInstanceMethod = true;
        }
        if (foundInstanceMethod) {
            return !Util.componentCanMakeNewInstances(typeElement);
        }
        return false;
    }

    static boolean componentCanMakeNewInstances(TypeElement typeElement) {
        switch (typeElement.getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
            default: {
                throw new AssertionError((Object)("TypeElement cannot have kind: " + (Object)((Object)typeElement.getKind())));
            }
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        if (Util.requiresEnclosingInstance(typeElement)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CONSTRUCTOR) || !((ExecutableElement)element).getParameters().isEmpty() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresEnclosingInstance(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return false;
            }
            case MEMBER: {
                return !typeElement.getModifiers().contains((Object)Modifier.STATIC);
            }
            case ANONYMOUS: 
            case LOCAL: {
                return true;
            }
        }
        throw new AssertionError((Object)("TypeElement cannot have nesting kind: " + (Object)((Object)typeElement.getNestingKind())));
    }

    static ImmutableSet<ExecutableElement> getUnimplementedMethods(Elements elements, Types types, TypeElement type) {
        return FluentIterable.from(MoreElements.getLocalAndInheritedMethods(type, types, elements)).filter(MoreElements.hasModifiers(Modifier.ABSTRACT)).toSet();
    }

    static boolean isAnyAnnotationPresent(Element element, Iterable<? extends Class<? extends Annotation>> annotationClasses) {
        for (Class<? extends Annotation> clazz : annotationClasses) {
            if (!MoreElements.isAnnotationPresent(element, clazz)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    static boolean isAnyAnnotationPresent(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... otherAnnotations) {
        return Util.isAnyAnnotationPresent(element, Lists.asList(first, (Object[])otherAnnotations));
    }

    static boolean isAnnotationPresent(Element element, TypeMirror annotationType) {
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).anyMatch(candidate -> MoreTypes.equivalence().equivalent(candidate, (Object)annotationType));
    }

    static <E extends Element> FluentIterable<E> elementsWithAnnotation(Iterable<E> elements, Class<? extends Annotation> annotation) {
        return FluentIterable.from(elements).filter(element -> MoreElements.isAnnotationPresent(element, annotation));
    }

    static <C extends Comparable<C>> Comparator<Optional<C>> optionalComparator() {
        return Comparator.comparing(optional -> optional.isPresent()).thenComparing(Optional::get);
    }

    static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf);
    }

    private Util() {
    }
}

