/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.KModifier;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.NullableTypeNames;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class XFunSpecs {
    public static Builder overriding(XMethodElement method, XType owner, CompilerOptions compilerOptions) {
        Builder builder = XFunSpecs.overridingWithoutParameters(method, owner, compilerOptions);
        XMethodType methodType = method.asMemberOf(owner);
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            XExecutableParameterElement parameter = method.getParameters().get(i);
            XType parameterType = methodType.getParameterTypes().get(i);
            builder.addParameter(XParameterSpecs.from(parameter, parameterType, compilerOptions));
        }
        return builder;
    }

    public static Builder overridingWithoutParameters(XMethodElement method, XType owner, CompilerOptions compilerOptions) {
        XMethodType methodType = method.asMemberOf(owner);
        Nullability nullability = Nullability.of(method);
        Builder builder = XFunSpecs.methodBuilder(method.getJvmName()).isOverride(true).addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations()).addTypeVariables(methodType.getTypeVariables()).varargs(method.isVarArgs()).returns(methodType.getReturnType(), compilerOptions);
        if (method.isPublic()) {
            builder.addModifiers(Modifier.PUBLIC);
        } else if (method.isProtected()) {
            builder.addModifiers(Modifier.PROTECTED);
        }
        return builder;
    }

    public static Builder methodBuilder(String name) {
        return new Builder(Builder.Kind.FUNCTION).name(name);
    }

    public static Builder constructorBuilder() {
        return new Builder(Builder.Kind.CONSTRUCTOR);
    }

    private XFunSpecs() {
    }

    public static class Builder {
        private final Kind kind;
        private final List<XCodeBlock> javadocs = new ArrayList<XCodeBlock>();
        private final List<XParameterSpec> parameters = new ArrayList<XParameterSpec>();
        private final List<XAnnotationSpec> annotations = new ArrayList<XAnnotationSpec>();
        private final List<XTypeName> typeVariableNames = new ArrayList<XTypeName>();
        private final List<XTypeName> exceptionNames = new ArrayList<XTypeName>();
        private final XCodeBlock.Builder bodyBuilder = XCodeBlock.builder();
        private String name;
        private VisibilityModifier visibility = null;
        private boolean isStatic = false;
        private boolean isAbstract = false;
        private boolean isOpen = false;
        private boolean isOverride = false;
        private boolean isVarArgs = false;
        private XTypeName returnType = null;
        private XCodeBlock superConstructorParametersCodeBlock = null;

        Builder(Kind kind) {
            this.kind = kind;
        }

        public ImmutableList<XParameterSpec> getParameters() {
            return ImmutableList.copyOf(this.parameters);
        }

        public XTypeName getReturnType() {
            return this.returnType;
        }

        @CanIgnoreReturnValue
        private Builder name(String name) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder visibility(VisibilityModifier visibility) {
            this.visibility = visibility;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isStatic(boolean isStatic) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.isStatic = isStatic;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isAbstract(boolean isAbstract) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.isAbstract = isAbstract;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isOpen(boolean isOpen) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.isOpen = isOpen;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isOverride(boolean isOverride) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.isOverride = isOverride;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addJavadoc(String format, Object ... args) {
            this.javadocs.add(XCodeBlock.of(format, args));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Collection<Modifier> modifiers) {
            return this.addModifiers(modifiers.toArray(new Modifier[0]));
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Modifier ... modifiers) {
            block8: for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case PUBLIC: {
                        this.visibility(VisibilityModifier.PUBLIC);
                        continue block8;
                    }
                    case PRIVATE: {
                        this.visibility(VisibilityModifier.PRIVATE);
                        continue block8;
                    }
                    case PROTECTED: {
                        this.visibility(VisibilityModifier.PROTECTED);
                        continue block8;
                    }
                    case ABSTRACT: {
                        this.isOpen(true);
                        this.isAbstract(true);
                        continue block8;
                    }
                    case STATIC: {
                        this.isStatic(true);
                        continue block8;
                    }
                    case FINAL: {
                        this.isOpen(false);
                        continue block8;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected modifier: " + (Object)((Object)modifier)));
                    }
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariables(Collection<? extends XType> typeVariables) {
            typeVariables.forEach(this::addTypeVariable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariableNames(Collection<XTypeName> typeVariableNames) {
            typeVariableNames.forEach(this::addTypeVariable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariable(XType type) {
            return this.addTypeVariable(type.asTypeName());
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariable(XTypeName typeName) {
            this.typeVariableNames.add(typeName);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotations(Collection<XAnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotationNames(Collection<XClassName> annotationNames) {
            annotationNames.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XAnnotation annotation) {
            return this.addAnnotation(XAnnotationSpecs.of(annotation));
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XClassName annotationName) {
            return this.addAnnotation(XAnnotationSpec.of(annotationName));
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XAnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParameters(Collection<XParameterSpec> parameters) {
            parameters.forEach(this::addParameter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParameter(XParameterSpec parameter) {
            this.parameters.add(parameter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParameter(XName name, XTypeName typeName) {
            return this.addParameter(XParameterSpecs.of(XConverters.toJavaPoet(name), typeName));
        }

        @CanIgnoreReturnValue
        public Builder addParameter(String name, XTypeName typeName) {
            return this.addParameter(XParameterSpecs.of(name, typeName));
        }

        @CanIgnoreReturnValue
        public Builder addExceptions(Collection<? extends XType> exceptions) {
            exceptions.forEach(this::addException);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addExceptionNames(Collection<XTypeName> exceptionNames) {
            exceptionNames.forEach(this::addException);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addException(XType exception) {
            return this.addException(exception.asTypeName());
        }

        @CanIgnoreReturnValue
        public Builder addException(XTypeName exceptionName) {
            this.exceptionNames.add(exceptionName);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStatement(String format, Object ... args) {
            this.bodyBuilder.addStatement(format, args);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStatement(XCodeBlock codeBlock) {
            this.bodyBuilder.addStatement("%L", codeBlock);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addCode(String format, Object ... args) {
            this.bodyBuilder.add(format, args);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addCode(XCodeBlock codeBlock) {
            this.bodyBuilder.add(codeBlock);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder callSuperConstructor(XCodeBlock superConstructorParametersCodeBlock) {
            this.superConstructorParametersCodeBlock = superConstructorParametersCodeBlock;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder callSuperConstructor(String format, Object ... args) {
            return this.callSuperConstructor(XCodeBlock.of(format, args));
        }

        @CanIgnoreReturnValue
        public Builder beginControlFlow(String controlFlow, Object ... args) {
            this.bodyBuilder.beginControlFlow(controlFlow, args);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder endControlFlow() {
            this.bodyBuilder.endControlFlow();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder varargs(boolean isVarArgs) {
            this.isVarArgs = isVarArgs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder returns(XType returnType, CompilerOptions compilerOptions) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.returnType = NullableTypeNames.asNullableTypeName(returnType, compilerOptions);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder returns(XTypeName returnType) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.returnType = returnType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addLocalVal(String name, XTypeName typeName, String format, Object ... args) {
            return this.addLocalVal(name, typeName, XCodeBlock.of(format, args));
        }

        @CanIgnoreReturnValue
        public Builder addLocalVal(String name, XTypeName typeName, XCodeBlock initialization) {
            this.bodyBuilder.add(XCodeBlocks.ofLocalVal(name, typeName, initialization));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addLocalVar(String name, XTypeName typeName, String format, Object ... args) {
            return this.addLocalVar(name, typeName, XCodeBlock.of(format, args));
        }

        @CanIgnoreReturnValue
        public Builder addLocalVar(String name, XTypeName typeName, XCodeBlock initialization) {
            this.bodyBuilder.add(XCodeBlocks.ofLocalVar(name, typeName, initialization));
            return this;
        }

        public XFunSpec build() {
            XCodeBlock body;
            XFunSpec.Builder builder;
            VisibilityModifier initialVisibility = this.visibility == null ? VisibilityModifier.PRIVATE : this.visibility;
            switch (this.kind.ordinal()) {
                case 0: {
                    builder = XFunSpec.builder(this.name, initialVisibility, this.isOpen, this.isOverride, false);
                    break;
                }
                case 1: {
                    Preconditions.checkState((this.name == null ? 1 : 0) != 0);
                    Preconditions.checkState((this.returnType == null ? 1 : 0) != 0);
                    builder = XFunSpec.constructorBuilder(initialVisibility, false);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.visibility == null) {
                XConverters.toJavaPoet((XFunSpec.Builder)builder).modifiers.remove((Object)Modifier.PRIVATE);
                XConverters.toKotlinPoet(builder).getModifiers().remove(KModifier.PRIVATE);
            }
            for (XCodeBlock javadoc : this.javadocs) {
                XConverters.toJavaPoet(builder).addJavadoc(XConverters.toJavaPoet(javadoc));
            }
            if (this.superConstructorParametersCodeBlock != null) {
                XConverters.toJavaPoet(builder).addStatement("super($L)", new Object[]{XConverters.toJavaPoet(this.superConstructorParametersCodeBlock)});
                XConverters.toKotlinPoet(builder).callSuperConstructor(new CodeBlock[]{XConverters.toKotlinPoet(this.superConstructorParametersCodeBlock)});
            }
            if (!XCodeBlocks.isEmpty(body = this.bodyBuilder.build())) {
                builder.addCode(body);
            }
            if (this.isAbstract) {
                builder.addAbstractModifier();
            }
            if (this.isStatic) {
                XConverters.toJavaPoet(builder).addModifiers(new Modifier[]{Modifier.STATIC});
            }
            if (this.isVarArgs) {
                XConverters.toJavaPoet(builder).varargs(this.isVarArgs);
            }
            if (this.returnType != null) {
                builder.returns(this.returnType);
            }
            builder.addParameters(this.parameters);
            builder.addTypeVariables(this.typeVariableNames);
            this.annotations.forEach(builder::addAnnotation);
            this.exceptionNames.forEach(exceptionName -> XConverters.toJavaPoet(builder).addException(XConverters.toJavaPoet(exceptionName)));
            return builder.build();
        }

        private static enum Kind {
            FUNCTION,
            CONSTRUCTOR;

        }
    }
}

