/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateBinding;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.BindingRepresentation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.DelegateRequestRepresentation;
import dagger.internal.codegen.writing.DirectInstanceBindingRepresentation;
import dagger.internal.codegen.writing.FrameworkInstanceBindingRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;

final class ProvisionBindingRepresentation
implements BindingRepresentation {
    private final BindingGraph graph;
    private final ComponentImplementation.CompilerMode compilerMode;
    private final ContributionBinding binding;
    private final DirectInstanceBindingRepresentation directInstanceBindingRepresentation;
    private final FrameworkInstanceBindingRepresentation frameworkInstanceBindingRepresentation;

    @AssistedInject
    ProvisionBindingRepresentation(@Assisted ContributionBinding binding, DirectInstanceBindingRepresentation.Factory directInstanceBindingRepresentationFactory, FrameworkInstanceBindingRepresentation.Factory frameworkInstanceBindingRepresentationFactory, BindingGraph graph, ComponentImplementation componentImplementation) {
        this.binding = binding;
        this.graph = graph;
        this.compilerMode = componentImplementation.compilerMode();
        this.directInstanceBindingRepresentation = directInstanceBindingRepresentationFactory.create(binding);
        this.frameworkInstanceBindingRepresentation = frameworkInstanceBindingRepresentationFactory.create(binding);
    }

    @Override
    public RequestRepresentation getRequestRepresentation(BindingRequest request) {
        return this.usesDirectInstanceExpression(request.requestKind()) ? this.directInstanceBindingRepresentation.getRequestRepresentation(request) : this.frameworkInstanceBindingRepresentation.getRequestRepresentation(request);
    }

    private boolean usesDirectInstanceExpression(RequestKind requestKind) {
        if (requestKind != RequestKind.INSTANCE && requestKind != RequestKind.FUTURE) {
            return false;
        }
        if (this.compilerMode.isFastInit() && this.graph.topLevelBindingGraph().hasFrameworkRequest(this.binding)) {
            return false;
        }
        switch (this.binding.kind()) {
            case SUBCOMPONENT_CREATOR: {
                return true;
            }
            case MEMBERS_INJECTOR: 
            case ASSISTED_FACTORY: {
                return false;
            }
            case ASSISTED_INJECTION: {
                throw new IllegalStateException("Assisted injection binding shouldn't be requested with an instance request.");
            }
        }
        return !ProvisionBindingRepresentation.needsCaching(this.binding, this.graph) && (!this.graph.topLevelBindingGraph().hasFrameworkRequest(this.binding) || !ProvisionBindingRepresentation.bindingHasDependencies(this.binding, this.graph));
    }

    static boolean needsCaching(ContributionBinding binding, BindingGraph graph) {
        if (!binding.scope().isPresent()) {
            return false;
        }
        if (binding.kind().equals((Object)BindingKind.DELEGATE)) {
            return DelegateRequestRepresentation.isBindsScopeStrongerThanDependencyScope((DelegateBinding)binding, graph);
        }
        return true;
    }

    private static boolean bindingHasDependencies(ContributionBinding binding, BindingGraph graph) {
        if (binding.dependencies().isEmpty()) {
            return false;
        }
        if (!binding.kind().equals((Object)BindingKind.DELEGATE)) {
            return true;
        }
        return binding.dependencies().stream().map(DependencyRequest::key).map(graph::contributionBinding).anyMatch(b -> ProvisionBindingRepresentation.bindingHasDependencies(b, graph));
    }

    @AssistedFactory
    static interface Factory {
        public ProvisionBindingRepresentation create(ContributionBinding var1);
    }
}

