/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.NullableTypeNames;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class FactoryGenerator
extends SourceFileGenerator<ContributionBinding> {
    private static final ImmutableSet<BindingKind> VALID_BINDING_KINDS = ImmutableSet.of((Object)((Object)BindingKind.INJECTION), (Object)((Object)BindingKind.ASSISTED_INJECTION), (Object)((Object)BindingKind.PROVISION));
    private final CompilerOptions compilerOptions;
    private final SourceFiles sourceFiles;

    @Inject
    FactoryGenerator(XFiler filer, CompilerOptions compilerOptions, SourceFiles sourceFiles, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
        this.compilerOptions = compilerOptions;
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(ContributionBinding binding) {
        return binding.bindingElement().get();
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(ContributionBinding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        Preconditions.checkArgument((boolean)VALID_BINDING_KINDS.contains((Object)binding.kind()));
        return ImmutableList.of((Object)this.factoryBuilder(binding));
    }

    private XTypeSpec factoryBuilder(ContributionBinding binding) {
        XTypeSpecs.Builder factoryBuilder = XTypeSpecs.classBuilder(SourceFiles.generatedClassNameForBinding(binding)).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypeVariableNames((Collection<XTypeName>)SourceFiles.bindingTypeElementTypeVariableNames(binding)).addAnnotation(this.scopeMetadataAnnotation(binding)).addAnnotation(this.qualifierMetadataAnnotation(binding));
        this.factoryTypeName(binding).ifPresent(factoryBuilder::addSuperinterface);
        FactoryFields factoryFields = FactoryFields.create(binding, this.compilerOptions);
        if (this.useStaticInstanceHolder(binding, factoryFields)) {
            factoryBuilder.addType(this.staticInstanceHolderType(binding));
        } else {
            factoryBuilder.addProperties((Collection<XPropertySpec>)factoryFields.getAll()).addFunction(this.constructorMethod(factoryFields));
        }
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(factoryBuilder::addAnnotation);
        return factoryBuilder.addFunction(this.getMethod(binding, factoryFields)).addFunction(this.staticCreateMethod(binding, factoryFields)).addFunction(this.staticProxyMethod(binding)).build();
    }

    private boolean useStaticInstanceHolder(ContributionBinding binding, FactoryFields factoryFields) {
        return factoryFields.isEmpty();
    }

    private XTypeSpec staticInstanceHolderType(ContributionBinding binding) {
        XClassName generatedClassName = SourceFiles.generatedClassNameForBinding(binding);
        XPropertySpecs.Builder instanceHolderFieldBuilder = XPropertySpecs.builder("INSTANCE", generatedClassName, Modifier.STATIC, Modifier.FINAL).initializer(XCodeBlock.ofNewInstance(generatedClassName, "", new Object[0]));
        if (!SourceFiles.bindingTypeElementTypeVariableNames(binding).isEmpty()) {
            instanceHolderFieldBuilder.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.RAWTYPES, new XAnnotationSpecs.Suppression[0]));
        }
        return XTypeSpecs.objectBuilder(FactoryGenerator.instanceHolderClassName(binding)).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addProperty(instanceHolderFieldBuilder.build()).build();
    }

    private static XClassName instanceHolderClassName(ContributionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding).nestedClass("InstanceHolder");
    }

    private XFunSpec constructorMethod(FactoryFields factoryFields) {
        XFunSpecs.Builder constructor = XFunSpecs.constructorBuilder().addModifiers(Modifier.PRIVATE);
        factoryFields.getAll().forEach(field -> constructor.addParameter(field.getName(), field.getType()).addStatement("this.%1N = %1N", field));
        return constructor.build();
    }

    private XFunSpec staticCreateMethod(ContributionBinding binding, FactoryFields factoryFields) {
        XFunSpecs.Builder createMethodBuilder = XFunSpecs.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariableNames((Collection<XTypeName>)SourceFiles.bindingTypeElementTypeVariableNames(binding));
        if (this.useStaticInstanceHolder(binding, factoryFields)) {
            if (!SourceFiles.bindingTypeElementTypeVariableNames(binding).isEmpty()) {
                createMethodBuilder.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.UNCHECKED, new XAnnotationSpecs.Suppression[0]));
            }
            createMethodBuilder.addStatement("return %T.INSTANCE", FactoryGenerator.instanceHolderClassName(binding));
        } else {
            ImmutableList.Builder arguments = ImmutableList.builder();
            factoryFields.moduleField.ifPresent(module -> {
                String moduleName = module.getName();
                XType moduleType = binding.bindingTypeElement().get().getType();
                arguments.add((Object)InjectionMethods.copyParameter(createMethodBuilder, moduleName, moduleType.asTypeName(), Nullability.NOT_NULLABLE, Accessibility.isTypeAccessibleFromPublicApi(moduleType, this.compilerOptions), this.compilerOptions));
            });
            factoryFields.frameworkFields.forEach((dependencyRequest, field) -> {
                String parameterName = field.getName();
                XType dependencyType = dependencyRequest.key().type().xprocessing();
                arguments.add((Object)InjectionMethods.copyFrameworkParameter(createMethodBuilder, parameterName, field.getType(), Nullability.NOT_NULLABLE, Accessibility.isTypeAccessibleFromPublicApi(dependencyType, this.compilerOptions), this.compilerOptions));
            });
            createMethodBuilder.addStatement("return %L", XCodeBlock.ofNewInstance(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), "%L", XCodeBlocks.makeParametersCodeBlock((Iterable<XCodeBlock>)arguments.build())));
        }
        return createMethodBuilder.build();
    }

    private XFunSpec getMethod(ContributionBinding binding, FactoryFields factoryFields) {
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        factoryFields.getAll().forEach(field -> uniqueFieldNames.claim(field.getName()));
        XFunSpecs.Builder getMethod = XFunSpecs.methodBuilder("get").addModifiers(Modifier.PUBLIC).isOverride(this.factoryTypeName(binding).isPresent()).returns(this.providedTypeName(binding));
        ImmutableMap assistedParameterUsages = (ImmutableMap)AssistedInjectionAnnotations.assistedParameters(binding).stream().collect(DaggerStreams.toImmutableMap(parameter -> parameter, parameter -> InjectionMethods.copyParameter(getMethod, uniqueFieldNames.getUniqueName(parameter.getJvmName()), parameter.getType().asTypeName(), Nullability.of(parameter), Accessibility.isTypeAccessibleFromPublicApi(parameter.getType(), this.compilerOptions), this.compilerOptions)));
        XCodeBlock invokeNewInstance = InjectionMethods.ProvisionMethod.invoke(binding, request -> this.sourceFiles.frameworkTypeUsageStatement(XCodeBlock.of("%N", factoryFields.get((DependencyRequest)request)), request.kind()), arg_0 -> ((ImmutableMap)assistedParameterUsages).get(arg_0), SourceFiles.generatedClassNameForBinding(binding), factoryFields.moduleField.map(module -> XCodeBlock.of("%N", module)), this.compilerOptions);
        if (!this.injectionSites(binding).isEmpty()) {
            String instanceName = "instance";
            XCodeBlock invokeInjectionSites = InjectionMethods.InjectionSiteMethod.invokeAll(binding, SourceFiles.generatedClassNameForBinding(binding), XCodeBlock.of("%N", instanceName), binding.key().type().xprocessing(), arg_0 -> this.sourceFiles.frameworkFieldUsages(binding.dependencies(), (ImmutableMap<DependencyRequest, XPropertySpec>)factoryFields.frameworkFields).get(arg_0), this.compilerOptions);
            getMethod.addLocalVar(instanceName, this.providedTypeName(binding), invokeNewInstance).addCode(invokeInjectionSites).addStatement("return %N", instanceName);
        } else {
            getMethod.addAnnotationNames((Collection<XClassName>)binding.nullability().nonTypeUseNullableAnnotations()).addStatement("return %L", invokeNewInstance);
        }
        return getMethod.build();
    }

    private XFunSpec staticProxyMethod(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: 
            case ASSISTED_INJECTION: {
                return this.staticProxyMethodForInjection(binding);
            }
            case PROVISION: {
                return this.staticProxyMethodForProvision((ProvisionBinding)binding);
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + binding));
    }

    private XFunSpec staticProxyMethodForInjection(ContributionBinding binding) {
        XConstructorElement constructor = XElements.asConstructor(binding.bindingElement().get());
        XTypeElement enclosingType = constructor.getEnclosingElement();
        XFunSpecs.Builder builder = XFunSpecs.methodBuilder(SourceFiles.generatedProxyMethodName(binding)).addModifiers(Modifier.PUBLIC, Modifier.STATIC).varargs(constructor.isVarArgs()).returns(this.providedTypeName(binding)).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(enclosingType)).addExceptions(constructor.getThrownTypes());
        XCodeBlock arguments = InjectionMethods.copyParameters(builder, new UniqueNameSet(), constructor.getParameters(), this.compilerOptions);
        return builder.addStatement("return %L", XCodeBlock.ofNewInstance(enclosingType.getType().asTypeName(), "%L", arguments)).build();
    }

    private XFunSpec staticProxyMethodForProvision(ProvisionBinding binding) {
        XCodeBlock module;
        XMethodElement method = XElements.asMethod(binding.bindingElement().get());
        XFunSpecs.Builder builder = XFunSpecs.methodBuilder(SourceFiles.generatedProxyMethodName(binding)).addModifiers(Modifier.PUBLIC, Modifier.STATIC).varargs(method.isVarArgs()).addExceptions(method.getThrownTypes());
        XTypeElement enclosingType = XElements.asTypeElement(method.getEnclosingElement());
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        if (method.isStatic() || enclosingType.isKotlinObject()) {
            module = XCodeBlocks.staticReferenceOf(enclosingType);
        } else {
            builder.addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(enclosingType));
            module = this.copyInstance(builder, parameterNameSet, enclosingType.getType());
        }
        XCodeBlock arguments = InjectionMethods.copyParameters(builder, parameterNameSet, method.getParameters(), this.compilerOptions);
        XCodeBlock invocation = XCodeBlock.of("%L.%N(%L)", module, this.referenceName(method), arguments);
        Nullability nullability = Nullability.of(method);
        return builder.addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations()).returns(this.contributedTypeName(binding)).addStatement("return %L", this.maybeWrapInCheckForNull(binding, invocation)).build();
    }

    private String referenceName(XMethodElement method) {
        return method.getJvmName();
    }

    private XCodeBlock maybeWrapInCheckForNull(ProvisionBinding binding, XCodeBlock codeBlock) {
        return binding.shouldCheckForNull(this.compilerOptions) ? XCodeBlock.of("%T.checkNotNullFromProvides(%L)", XTypeNames.DAGGER_PRECONDITIONS, codeBlock) : codeBlock;
    }

    private XCodeBlock copyInstance(XFunSpecs.Builder methodBuilder, UniqueNameSet parameterNameSet, XType type) {
        boolean isTypeNameAccessible = Accessibility.isTypeAccessibleFromPublicApi(type, this.compilerOptions);
        XCodeBlock instance = InjectionMethods.copyParameter(methodBuilder, parameterNameSet.getUniqueName("instance"), type.asTypeName(), Nullability.NOT_NULLABLE, isTypeNameAccessible, this.compilerOptions);
        return isTypeNameAccessible ? instance : XCodeBlock.of("(%L)", instance);
    }

    private XAnnotationSpec scopeMetadataAnnotation(ContributionBinding binding) {
        XAnnotationSpecs.Builder builder = XAnnotationSpecs.builder(XTypeNames.SCOPE_METADATA);
        binding.scope().map(Scope::scopeAnnotation).map(DaggerAnnotation::xprocessing).map(XAnnotation::getQualifiedName).ifPresent(scopeCanonicalName -> builder.addMember("value", "%S", scopeCanonicalName));
        return builder.build();
    }

    private XAnnotationSpec qualifierMetadataAnnotation(ContributionBinding binding) {
        XAnnotationSpecs.Builder builder = XAnnotationSpecs.builder(XTypeNames.QUALIFIER_METADATA);
        Stream.concat(Stream.of(binding.key()), this.provisionDependencies(binding).stream().map(DependencyRequest::key)).map(Key::qualifier).flatMap(DaggerStreams.presentValues()).map(DaggerAnnotation::xprocessing).map(XAnnotation::getQualifiedName).distinct().forEach(qualifier -> builder.addArrayMember("value", "%S", qualifier));
        return builder.build();
    }

    private ImmutableSet<DependencyRequest> provisionDependencies(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return ((InjectionBinding)binding).constructorDependencies();
            }
            case ASSISTED_INJECTION: {
                return ((AssistedInjectionBinding)binding).constructorDependencies();
            }
            case PROVISION: {
                return ((ProvisionBinding)binding).dependencies();
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
    }

    private ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return ((InjectionBinding)binding).injectionSites();
            }
            case ASSISTED_INJECTION: {
                return ((AssistedInjectionBinding)binding).injectionSites();
            }
            case PROVISION: {
                return ImmutableSet.of();
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
    }

    private XTypeName providedTypeName(ContributionBinding binding) {
        XTypeName typeName = Accessibility.isTypeAccessibleFromPublicApi(binding.contributedType(), this.compilerOptions) ? binding.contributedType().asTypeName() : XTypeName.ANY_OBJECT.copy(true);
        return NullableTypeNames.asNullableTypeName(typeName, binding.nullability(), this.compilerOptions);
    }

    private XTypeName contributedTypeName(ContributionBinding binding) {
        return binding.contributedPrimitiveType().isPresent() ? NullableTypeNames.asNullableTypeName(binding.contributedPrimitiveType().get().asTypeName(), binding.nullability(), this.compilerOptions) : this.providedTypeName(binding);
    }

    private Optional<XTypeName> factoryTypeName(ContributionBinding binding) {
        return binding.kind() == BindingKind.ASSISTED_INJECTION ? Optional.empty() : Optional.of(XTypeNames.factoryOf(this.providedTypeName(binding)));
    }

    private static final class FactoryFields {
        private final Optional<XPropertySpec> moduleField;
        private final ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields;

        static FactoryFields create(ContributionBinding binding, CompilerOptions compilerOptions) {
            UniqueNameSet nameSet = new UniqueNameSet();
            Optional<XPropertySpec> moduleField = binding.requiresModuleInstance() ? Optional.of(FactoryFields.createField(binding.bindingTypeElement().get().getType().asTypeName(), nameSet.getUniqueName("module"))) : Optional.empty();
            ImmutableMap.Builder frameworkFields = ImmutableMap.builder();
            SourceFiles.generateBindingFieldsForDependencies(binding, compilerOptions).forEach((dependency, field) -> frameworkFields.put(dependency, (Object)FactoryFields.createField(field.type(), nameSet.getUniqueName(field.name()))));
            return new FactoryFields(moduleField, (ImmutableMap<DependencyRequest, XPropertySpec>)frameworkFields.buildOrThrow());
        }

        private static XPropertySpec createField(XTypeName typeName, String name) {
            return XPropertySpecs.of(name, typeName, Modifier.PRIVATE, Modifier.FINAL);
        }

        private FactoryFields(Optional<XPropertySpec> moduleField, ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
            this.moduleField = moduleField;
            this.frameworkFields = frameworkFields;
        }

        XPropertySpec get(DependencyRequest request) {
            return (XPropertySpec)this.frameworkFields.get((Object)request);
        }

        ImmutableList<XPropertySpec> getAll() {
            return this.moduleField.isPresent() ? ImmutableList.builder().add((Object)this.moduleField.get()).addAll((Iterable)this.frameworkFields.values()).build() : this.frameworkFields.values().asList();
        }

        boolean isEmpty() {
            return this.getAll().isEmpty();
        }
    }
}

